/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.text.SubtitleDecoder;

public interface SubtitleDecoderFactory {
    public static final SubtitleDecoderFactory DEFAULT = new SubtitleDecoderFactory(){

        @Override
        public boolean supportsFormat(Format format) {
            return this.getDecoderClass(format.sampleMimeType) != null;
        }

        @Override
        public SubtitleDecoder createDecoder(Format format) {
            try {
                Class<?> clazz = this.getDecoderClass(format.sampleMimeType);
                if (clazz == null) {
                    throw new IllegalArgumentException("Attempted to create decoder for unsupported format");
                }
                return clazz.asSubclass(SubtitleDecoder.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected error instantiating decoder", e);
            }
        }

        private Class<?> getDecoderClass(String mimeType) {
            try {
                switch (mimeType) {
                    case "text/vtt": {
                        return Class.forName("com.google.android.exoplayer2.text.webvtt.WebvttDecoder");
                    }
                    case "application/ttml+xml": {
                        return Class.forName("com.google.android.exoplayer2.text.ttml.TtmlDecoder");
                    }
                    case "application/x-mp4vtt": {
                        return Class.forName("com.google.android.exoplayer2.text.webvtt.Mp4WebvttDecoder");
                    }
                    case "application/x-subrip": {
                        return Class.forName("com.google.android.exoplayer2.text.subrip.SubripDecoder");
                    }
                    case "application/x-quicktime-tx3g": {
                        return Class.forName("com.google.android.exoplayer2.text.tx3g.Tx3gDecoder");
                    }
                    case "application/cea-608": {
                        return Class.forName("com.google.android.exoplayer2.text.cea.Cea608Decoder");
                    }
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    };

    public boolean supportsFormat(Format var1);

    public SubtitleDecoder createDecoder(Format var1);
}

