/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.decoder.OutputBuffer;
import com.google.android.exoplayer2.decoder.SimpleDecoder;
import com.google.android.exoplayer2.text.SimpleSubtitleOutputBuffer;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import java.nio.ByteBuffer;

public abstract class SimpleSubtitleDecoder
extends SimpleDecoder<SubtitleInputBuffer, SubtitleOutputBuffer, SubtitleDecoderException>
implements SubtitleDecoder {
    private final String name;

    protected SimpleSubtitleDecoder(String name) {
        super((DecoderInputBuffer[])new SubtitleInputBuffer[2], (OutputBuffer[])new SubtitleOutputBuffer[2]);
        this.name = name;
        this.setInitialInputBufferSize(1024);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setPositionUs(long timeUs) {
    }

    @Override
    protected final SubtitleInputBuffer createInputBuffer() {
        return new SubtitleInputBuffer();
    }

    @Override
    protected final SubtitleOutputBuffer createOutputBuffer() {
        return new SimpleSubtitleOutputBuffer(this);
    }

    @Override
    protected final void releaseOutputBuffer(SubtitleOutputBuffer buffer) {
        super.releaseOutputBuffer(buffer);
    }

    @Override
    protected final SubtitleDecoderException decode(SubtitleInputBuffer inputBuffer, SubtitleOutputBuffer outputBuffer, boolean reset) {
        try {
            ByteBuffer inputData = inputBuffer.data;
            Subtitle subtitle = this.decode(inputData.array(), inputData.limit());
            outputBuffer.setContent(inputBuffer.timeUs, subtitle, inputBuffer.subsampleOffsetUs);
            return null;
        }
        catch (SubtitleDecoderException e) {
            return e;
        }
    }

    protected abstract Subtitle decode(byte[] var1, int var2) throws SubtitleDecoderException;
}

