/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming.manifest;

import android.net.Uri;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.List;
import java.util.UUID;

public class SsManifest {
    public static final int UNSET_LOOKAHEAD = -1;
    public final int majorVersion;
    public final int minorVersion;
    public final int lookAheadCount;
    public final boolean isLive;
    public final ProtectionElement protectionElement;
    public final StreamElement[] streamElements;
    public final long durationUs;
    public final long dvrWindowLengthUs;

    public SsManifest(int majorVersion, int minorVersion, long timescale, long duration, long dvrWindowLength, int lookAheadCount, boolean isLive, ProtectionElement protectionElement, StreamElement[] streamElements) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.lookAheadCount = lookAheadCount;
        this.isLive = isLive;
        this.protectionElement = protectionElement;
        this.streamElements = streamElements;
        this.dvrWindowLengthUs = dvrWindowLength == 0L ? -9223372036854775807L : Util.scaleLargeTimestamp(dvrWindowLength, 1000000L, timescale);
        this.durationUs = duration == 0L ? -9223372036854775807L : Util.scaleLargeTimestamp(duration, 1000000L, timescale);
    }

    public static class StreamElement {
        private static final String URL_PLACEHOLDER_START_TIME = "{start time}";
        private static final String URL_PLACEHOLDER_BITRATE = "{bitrate}";
        public final int type;
        public final String subType;
        public final long timescale;
        public final String name;
        public final int maxWidth;
        public final int maxHeight;
        public final int displayWidth;
        public final int displayHeight;
        public final String language;
        public final Format[] formats;
        public final int chunkCount;
        private final String baseUri;
        private final String chunkTemplate;
        private final List<Long> chunkStartTimes;
        private final long[] chunkStartTimesUs;
        private final long lastChunkDurationUs;

        public StreamElement(String baseUri, String chunkTemplate, int type, String subType, long timescale, String name, int maxWidth, int maxHeight, int displayWidth, int displayHeight, String language, Format[] formats, List<Long> chunkStartTimes, long lastChunkDuration) {
            this.baseUri = baseUri;
            this.chunkTemplate = chunkTemplate;
            this.type = type;
            this.subType = subType;
            this.timescale = timescale;
            this.name = name;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.displayWidth = displayWidth;
            this.displayHeight = displayHeight;
            this.language = language;
            this.formats = formats;
            this.chunkCount = chunkStartTimes.size();
            this.chunkStartTimes = chunkStartTimes;
            this.lastChunkDurationUs = Util.scaleLargeTimestamp(lastChunkDuration, 1000000L, timescale);
            this.chunkStartTimesUs = Util.scaleLargeTimestamps(chunkStartTimes, 1000000L, timescale);
        }

        public int getChunkIndex(long timeUs) {
            return Util.binarySearchFloor(this.chunkStartTimesUs, timeUs, true, true);
        }

        public long getStartTimeUs(int chunkIndex) {
            return this.chunkStartTimesUs[chunkIndex];
        }

        public long getChunkDurationUs(int chunkIndex) {
            return chunkIndex == this.chunkCount - 1 ? this.lastChunkDurationUs : this.chunkStartTimesUs[chunkIndex + 1] - this.chunkStartTimesUs[chunkIndex];
        }

        public Uri buildRequestUri(int track, int chunkIndex) {
            Assertions.checkState(this.formats != null);
            Assertions.checkState(this.chunkStartTimes != null);
            Assertions.checkState(chunkIndex < this.chunkStartTimes.size());
            String chunkUrl = this.chunkTemplate.replace(URL_PLACEHOLDER_BITRATE, Integer.toString(this.formats[track].bitrate)).replace(URL_PLACEHOLDER_START_TIME, this.chunkStartTimes.get(chunkIndex).toString());
            return UriUtil.resolveToUri(this.baseUri, chunkUrl);
        }
    }

    public static class ProtectionElement {
        public final UUID uuid;
        public final byte[] data;

        public ProtectionElement(UUID uuid, byte[] data) {
            this.uuid = uuid;
            this.data = data;
        }
    }
}

