/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.smoothstreaming;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaPeriod;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifest;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;

public final class SsMediaSource
implements MediaSource,
Loader.Callback<ParsingLoadable<SsManifest>> {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_MS = 30000L;
    private static final int MINIMUM_MANIFEST_REFRESH_PERIOD_MS = 5000;
    private static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private final Uri manifestUri;
    private final DataSource.Factory dataSourceFactory;
    private final SsChunkSource.Factory chunkSourceFactory;
    private final int minLoadableRetryCount;
    private final long livePresentationDelayMs;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private final SsManifestParser manifestParser;
    private final ArrayList<SsMediaPeriod> mediaPeriods;
    private MediaSource.Listener sourceListener;
    private DataSource manifestDataSource;
    private Loader manifestLoader;
    private long manifestLoadStartTimestamp;
    private SsManifest manifest;
    private Handler manifestRefreshHandler;

    public SsMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, SsChunkSource.Factory chunkSourceFactory, Handler eventHandler, AdaptiveMediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, chunkSourceFactory, 3, 30000L, eventHandler, eventListener);
    }

    public SsMediaSource(Uri manifestUri, DataSource.Factory dataSourceFactory, SsChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, AdaptiveMediaSourceEventListener eventListener) {
        this.manifestUri = Util.toLowerInvariant(manifestUri.getLastPathSegment()).equals("manifest") ? manifestUri : Uri.withAppendedPath((Uri)manifestUri, (String)"Manifest");
        this.dataSourceFactory = dataSourceFactory;
        this.chunkSourceFactory = chunkSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.livePresentationDelayMs = livePresentationDelayMs;
        this.eventDispatcher = new AdaptiveMediaSourceEventListener.EventDispatcher(eventHandler, eventListener);
        this.manifestParser = new SsManifestParser();
        this.mediaPeriods = new ArrayList();
    }

    @Override
    public void prepareSource(MediaSource.Listener listener) {
        this.sourceListener = listener;
        this.manifestDataSource = this.dataSourceFactory.createDataSource();
        this.manifestLoader = new Loader("Loader:Manifest");
        this.manifestRefreshHandler = new Handler();
        this.startLoadingManifest();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.manifestLoader.maybeThrowError();
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        Assertions.checkArgument(index == 0);
        SsMediaPeriod period = new SsMediaPeriod(this.manifest, this.chunkSourceFactory, this.minLoadableRetryCount, this.eventDispatcher, this.manifestLoader, allocator);
        this.mediaPeriods.add(period);
        return period;
    }

    @Override
    public void releasePeriod(MediaPeriod period) {
        ((SsMediaPeriod)period).release();
        this.mediaPeriods.remove(period);
    }

    @Override
    public void releaseSource() {
        this.sourceListener = null;
        this.manifest = null;
        this.manifestDataSource = null;
        this.manifestLoadStartTimestamp = 0L;
        if (this.manifestLoader != null) {
            this.manifestLoader.release();
            this.manifestLoader = null;
        }
        if (this.manifestRefreshHandler != null) {
            this.manifestRefreshHandler.removeCallbacksAndMessages(null);
            this.manifestRefreshHandler = null;
        }
    }

    @Override
    public void onLoadCompleted(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        SinglePeriodTimeline timeline;
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.manifest = loadable.getResult();
        this.manifestLoadStartTimestamp = elapsedRealtimeMs - loadDurationMs;
        for (int i = 0; i < this.mediaPeriods.size(); ++i) {
            this.mediaPeriods.get(i).updateManifest(this.manifest);
        }
        if (this.manifest.isLive) {
            long startTimeUs = Long.MAX_VALUE;
            long endTimeUs = Long.MIN_VALUE;
            for (int i = 0; i < this.manifest.streamElements.length; ++i) {
                SsManifest.StreamElement element = this.manifest.streamElements[i];
                if (element.chunkCount <= 0) continue;
                startTimeUs = Math.min(startTimeUs, element.getStartTimeUs(0));
                endTimeUs = Math.max(endTimeUs, element.getStartTimeUs(element.chunkCount - 1) + element.getChunkDurationUs(element.chunkCount - 1));
            }
            if (startTimeUs == Long.MAX_VALUE) {
                timeline = new SinglePeriodTimeline(-9223372036854775807L, false);
            } else {
                long durationUs;
                long defaultStartPositionUs;
                if (this.manifest.dvrWindowLengthUs != -9223372036854775807L && this.manifest.dvrWindowLengthUs > 0L) {
                    startTimeUs = Math.max(startTimeUs, endTimeUs - this.manifest.dvrWindowLengthUs);
                }
                if ((defaultStartPositionUs = (durationUs = endTimeUs - startTimeUs) - C.msToUs(this.livePresentationDelayMs)) < 5000000L) {
                    defaultStartPositionUs = Math.min(5000000L, durationUs / 2L);
                }
                timeline = new SinglePeriodTimeline(-9223372036854775807L, durationUs, startTimeUs, defaultStartPositionUs, true, true);
            }
        } else {
            boolean isSeekable = this.manifest.durationUs != -9223372036854775807L;
            timeline = new SinglePeriodTimeline(this.manifest.durationUs, isSeekable);
        }
        this.sourceListener.onSourceInfoRefreshed(timeline, this.manifest);
        this.scheduleManifestRefresh();
    }

    @Override
    public void onLoadCanceled(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    @Override
    public int onLoadError(ParsingLoadable<SsManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        boolean isFatal = error instanceof ParserException;
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
        return isFatal ? 3 : 0;
    }

    private void scheduleManifestRefresh() {
        if (!this.manifest.isLive) {
            return;
        }
        long nextLoadTimestamp = this.manifestLoadStartTimestamp + 5000L;
        long delayUntilNextLoad = Math.max(0L, nextLoadTimestamp - SystemClock.elapsedRealtime());
        this.manifestRefreshHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SsMediaSource.this.startLoadingManifest();
            }
        }, delayUntilNextLoad);
    }

    private void startLoadingManifest() {
        ParsingLoadable<SsManifest> loadable = new ParsingLoadable<SsManifest>(this.manifestDataSource, this.manifestUri, 4, this.manifestParser);
        long elapsedRealtimeMs = this.manifestLoader.startLoading(loadable, this, this.minLoadableRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, elapsedRealtimeMs);
    }
}

