/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import android.net.Uri;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HlsPlaylistParser
implements ParsingLoadable.Parser<HlsPlaylist> {
    private static final String TAG_VERSION = "#EXT-X-VERSION";
    private static final String TAG_STREAM_INF = "#EXT-X-STREAM-INF";
    private static final String TAG_MEDIA = "#EXT-X-MEDIA";
    private static final String TAG_DISCONTINUITY = "#EXT-X-DISCONTINUITY";
    private static final String TAG_DISCONTINUITY_SEQUENCE = "#EXT-X-DISCONTINUITY-SEQUENCE";
    private static final String TAG_INIT_SEGMENT = "#EXT-X-MAP";
    private static final String TAG_MEDIA_DURATION = "#EXTINF";
    private static final String TAG_MEDIA_SEQUENCE = "#EXT-X-MEDIA-SEQUENCE";
    private static final String TAG_TARGET_DURATION = "#EXT-X-TARGETDURATION";
    private static final String TAG_ENDLIST = "#EXT-X-ENDLIST";
    private static final String TAG_KEY = "#EXT-X-KEY";
    private static final String TAG_BYTERANGE = "#EXT-X-BYTERANGE";
    private static final String TYPE_AUDIO = "AUDIO";
    private static final String TYPE_VIDEO = "VIDEO";
    private static final String TYPE_SUBTITLES = "SUBTITLES";
    private static final String TYPE_CLOSED_CAPTIONS = "CLOSED-CAPTIONS";
    private static final String METHOD_NONE = "NONE";
    private static final String METHOD_AES128 = "AES-128";
    private static final String BOOLEAN_TRUE = "YES";
    private static final String BOOLEAN_FALSE = "NO";
    private static final Pattern REGEX_GROUP_ID = Pattern.compile("GROUP-ID=\"(.+?)\"");
    private static final Pattern REGEX_VIDEO = Pattern.compile("VIDEO=\"(.+?)\"");
    private static final Pattern REGEX_AUDIO = Pattern.compile("AUDIO=\"(.+?)\"");
    private static final Pattern REGEX_CLOSED_CAPTIONS = Pattern.compile("CLOSED-CAPTIONS=\"(.+?)\"");
    private static final Pattern REGEX_SUBTITLES = Pattern.compile("SUBTITLES=\"(.+?)\"");
    private static final Pattern REGEX_BANDWIDTH = Pattern.compile("BANDWIDTH=(\\d+)\\b");
    private static final Pattern REGEX_CODECS = Pattern.compile("CODECS=\"(.+?)\"");
    private static final Pattern REGEX_RESOLUTION = Pattern.compile("RESOLUTION=(\\d+x\\d+)");
    private static final Pattern REGEX_VERSION = Pattern.compile("#EXT-X-VERSION:(\\d+)\\b");
    private static final Pattern REGEX_TARGET_DURATION = Pattern.compile("#EXT-X-TARGETDURATION:(\\d+)\\b");
    private static final Pattern REGEX_MEDIA_SEQUENCE = Pattern.compile("#EXT-X-MEDIA-SEQUENCE:(\\d+)\\b");
    private static final Pattern REGEX_MEDIA_DURATION = Pattern.compile("#EXTINF:([\\d\\.]+)\\b");
    private static final Pattern REGEX_BYTERANGE = Pattern.compile("#EXT-X-BYTERANGE:(\\d+(?:@\\d+)?)\\b");
    private static final Pattern REGEX_ATTR_BYTERANGE = Pattern.compile("BYTERANGE=\"(\\d+(?:@\\d+)?)\\b\"");
    private static final Pattern REGEX_METHOD = Pattern.compile("METHOD=(NONE|AES-128)");
    private static final Pattern REGEX_URI = Pattern.compile("URI=\"(.+?)\"");
    private static final Pattern REGEX_IV = Pattern.compile("IV=([^,.*]+)");
    private static final Pattern REGEX_TYPE = Pattern.compile("TYPE=(AUDIO|VIDEO|SUBTITLES|CLOSED-CAPTIONS)");
    private static final Pattern REGEX_LANGUAGE = Pattern.compile("LANGUAGE=\"(.+?)\"");
    private static final Pattern REGEX_NAME = Pattern.compile("NAME=\"(.+?)\"");
    private static final Pattern REGEX_INSTREAM_ID = Pattern.compile("INSTREAM-ID=\"(.+?)\"");
    private static final Pattern REGEX_AUTOSELECT = HlsPlaylistParser.compileBooleanAttrPattern("AUTOSELECT");
    private static final Pattern REGEX_DEFAULT = HlsPlaylistParser.compileBooleanAttrPattern("DEFAULT");
    private static final Pattern REGEX_FORCED = HlsPlaylistParser.compileBooleanAttrPattern("FORCED");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HlsPlaylist parse(Uri uri, InputStream inputStream) throws IOException {
        LinkedList<String> extraLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(TAG_STREAM_INF)) {
                    extraLines.add(line);
                    HlsMasterPlaylist hlsMasterPlaylist = HlsPlaylistParser.parseMasterPlaylist(new LineIterator(extraLines, reader), uri.toString());
                    return hlsMasterPlaylist;
                }
                if (line.startsWith(TAG_TARGET_DURATION) || line.startsWith(TAG_MEDIA_SEQUENCE) || line.startsWith(TAG_MEDIA_DURATION) || line.startsWith(TAG_KEY) || line.startsWith(TAG_BYTERANGE) || line.equals(TAG_DISCONTINUITY) || line.equals(TAG_DISCONTINUITY_SEQUENCE) || line.equals(TAG_ENDLIST)) {
                    extraLines.add(line);
                    HlsMediaPlaylist hlsMediaPlaylist = HlsPlaylistParser.parseMediaPlaylist(new LineIterator(extraLines, reader), uri.toString());
                    return hlsMediaPlaylist;
                }
                extraLines.add(line);
            }
        }
        throw new ParserException("Failed to parse the playlist, could not identify any tags.");
    }

    private static HlsMasterPlaylist parseMasterPlaylist(LineIterator iterator, String baseUri) throws IOException {
        ArrayList<HlsMasterPlaylist.HlsUrl> variants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> audios = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> subtitles = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        Format muxedAudioFormat = null;
        Format muxedCaptionFormat = null;
        while (iterator.hasNext()) {
            int height;
            int width;
            String line = iterator.next();
            if (line.startsWith(TAG_MEDIA)) {
                int selectionFlags = HlsPlaylistParser.parseSelectionFlags(line);
                String uri = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_URI);
                String name = HlsPlaylistParser.parseStringAttr(line, REGEX_NAME);
                String language = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_LANGUAGE);
                switch (HlsPlaylistParser.parseStringAttr(line, REGEX_TYPE)) {
                    case "AUDIO": {
                        Format format = Format.createAudioContainerFormat(name, "application/x-mpegURL", null, null, -1, -1, -1, null, selectionFlags, language);
                        if (uri == null) {
                            muxedAudioFormat = format;
                            break;
                        }
                        audios.add(new HlsMasterPlaylist.HlsUrl(name, uri, format, null, format, null));
                        break;
                    }
                    case "SUBTITLES": {
                        Format format = Format.createTextContainerFormat(name, "application/x-mpegURL", "text/vtt", null, -1, selectionFlags, language);
                        subtitles.add(new HlsMasterPlaylist.HlsUrl(name, uri, format, null, format, null));
                        break;
                    }
                    case "CLOSED-CAPTIONS": {
                        if (!"CC1".equals(HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_INSTREAM_ID))) break;
                        muxedCaptionFormat = Format.createTextContainerFormat(name, "application/x-mpegURL", "application/cea-608", null, -1, selectionFlags, language);
                        break;
                    }
                }
                continue;
            }
            if (!line.startsWith(TAG_STREAM_INF)) continue;
            int bitrate = HlsPlaylistParser.parseIntAttr(line, REGEX_BANDWIDTH);
            String codecs = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_CODECS);
            String resolutionString = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_RESOLUTION);
            if (resolutionString != null) {
                String[] widthAndHeight = resolutionString.split("x");
                width = Integer.parseInt(widthAndHeight[0]);
                height = Integer.parseInt(widthAndHeight[1]);
                if (width <= 0 || height <= 0) {
                    width = -1;
                    height = -1;
                }
            } else {
                width = -1;
                height = -1;
            }
            line = iterator.next();
            String name = Integer.toString(variants.size());
            Format format = Format.createVideoContainerFormat(name, "application/x-mpegURL", null, codecs, bitrate, width, height, -1.0f, null);
            variants.add(new HlsMasterPlaylist.HlsUrl(name, line, format, null, null, null));
        }
        return new HlsMasterPlaylist(baseUri, variants, audios, subtitles, muxedAudioFormat, muxedCaptionFormat);
    }

    private static int parseSelectionFlags(String line) {
        return (HlsPlaylistParser.parseBooleanAttribute(line, REGEX_DEFAULT, false) ? 1 : 0) | (HlsPlaylistParser.parseBooleanAttribute(line, REGEX_FORCED, false) ? 2 : 0) | (HlsPlaylistParser.parseBooleanAttribute(line, REGEX_AUTOSELECT, false) ? 4 : 0);
    }

    private static HlsMediaPlaylist parseMediaPlaylist(LineIterator iterator, String baseUri) throws IOException {
        int mediaSequence = 0;
        int targetDurationSecs = 0;
        int version = 1;
        boolean live = true;
        HlsMediaPlaylist.Segment initializationSegment = null;
        ArrayList<HlsMediaPlaylist.Segment> segments = new ArrayList<HlsMediaPlaylist.Segment>();
        double segmentDurationSecs = 0.0;
        int discontinuitySequenceNumber = 0;
        long segmentStartTimeUs = 0L;
        long segmentByteRangeOffset = 0L;
        long segmentByteRangeLength = -1L;
        int segmentMediaSequence = 0;
        boolean isEncrypted = false;
        String encryptionKeyUri = null;
        String encryptionIV = null;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (line.startsWith(TAG_INIT_SEGMENT)) {
                String uri = HlsPlaylistParser.parseStringAttr(line, REGEX_URI);
                String byteRange = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_ATTR_BYTERANGE);
                if (byteRange != null) {
                    String[] splitByteRange = byteRange.split("@");
                    segmentByteRangeLength = Long.parseLong(splitByteRange[0]);
                    if (splitByteRange.length > 1) {
                        segmentByteRangeOffset = Long.parseLong(splitByteRange[1]);
                    }
                }
                initializationSegment = new HlsMediaPlaylist.Segment(uri, segmentByteRangeOffset, segmentByteRangeLength);
                segmentByteRangeOffset = 0L;
                segmentByteRangeLength = -1L;
                continue;
            }
            if (line.startsWith(TAG_TARGET_DURATION)) {
                targetDurationSecs = HlsPlaylistParser.parseIntAttr(line, REGEX_TARGET_DURATION);
                continue;
            }
            if (line.startsWith(TAG_MEDIA_SEQUENCE)) {
                segmentMediaSequence = mediaSequence = HlsPlaylistParser.parseIntAttr(line, REGEX_MEDIA_SEQUENCE);
                continue;
            }
            if (line.startsWith(TAG_VERSION)) {
                version = HlsPlaylistParser.parseIntAttr(line, REGEX_VERSION);
                continue;
            }
            if (line.startsWith(TAG_MEDIA_DURATION)) {
                segmentDurationSecs = HlsPlaylistParser.parseDoubleAttr(line, REGEX_MEDIA_DURATION);
                continue;
            }
            if (line.startsWith(TAG_KEY)) {
                String method = HlsPlaylistParser.parseStringAttr(line, REGEX_METHOD);
                isEncrypted = METHOD_AES128.equals(method);
                if (isEncrypted) {
                    encryptionKeyUri = HlsPlaylistParser.parseStringAttr(line, REGEX_URI);
                    encryptionIV = HlsPlaylistParser.parseOptionalStringAttr(line, REGEX_IV);
                    continue;
                }
                encryptionKeyUri = null;
                encryptionIV = null;
                continue;
            }
            if (line.startsWith(TAG_BYTERANGE)) {
                String byteRange = HlsPlaylistParser.parseStringAttr(line, REGEX_BYTERANGE);
                String[] splitByteRange = byteRange.split("@");
                segmentByteRangeLength = Long.parseLong(splitByteRange[0]);
                if (splitByteRange.length <= 1) continue;
                segmentByteRangeOffset = Long.parseLong(splitByteRange[1]);
                continue;
            }
            if (line.startsWith(TAG_DISCONTINUITY_SEQUENCE)) {
                discontinuitySequenceNumber = Integer.parseInt(line.substring(line.indexOf(58) + 1));
                continue;
            }
            if (line.equals(TAG_DISCONTINUITY)) {
                ++discontinuitySequenceNumber;
                continue;
            }
            if (!line.startsWith("#")) {
                String segmentEncryptionIV = !isEncrypted ? null : (encryptionIV != null ? encryptionIV : Integer.toHexString(segmentMediaSequence));
                ++segmentMediaSequence;
                if (segmentByteRangeLength == -1L) {
                    segmentByteRangeOffset = 0L;
                }
                segments.add(new HlsMediaPlaylist.Segment(line, segmentDurationSecs, discontinuitySequenceNumber, segmentStartTimeUs, isEncrypted, encryptionKeyUri, segmentEncryptionIV, segmentByteRangeOffset, segmentByteRangeLength));
                segmentStartTimeUs += (long)(segmentDurationSecs * 1000000.0);
                segmentDurationSecs = 0.0;
                if (segmentByteRangeLength != -1L) {
                    segmentByteRangeOffset += segmentByteRangeLength;
                }
                segmentByteRangeLength = -1L;
                continue;
            }
            if (!line.equals(TAG_ENDLIST)) continue;
            live = false;
        }
        return new HlsMediaPlaylist(baseUri, mediaSequence, targetDurationSecs, version, live, initializationSegment, Collections.unmodifiableList(segments));
    }

    private static String parseStringAttr(String line, Pattern pattern) throws ParserException {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new ParserException("Couldn't match " + pattern.pattern() + " in " + line);
    }

    private static int parseIntAttr(String line, Pattern pattern) throws ParserException {
        return Integer.parseInt(HlsPlaylistParser.parseStringAttr(line, pattern));
    }

    private static double parseDoubleAttr(String line, Pattern pattern) throws ParserException {
        return Double.parseDouble(HlsPlaylistParser.parseStringAttr(line, pattern));
    }

    private static String parseOptionalStringAttr(String line, Pattern pattern) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean parseBooleanAttribute(String line, Pattern pattern, boolean defaultValue) {
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1).equals(BOOLEAN_TRUE);
        }
        return defaultValue;
    }

    private static Pattern compileBooleanAttrPattern(String attribute) {
        return Pattern.compile(attribute + "=(" + BOOLEAN_FALSE + "|" + BOOLEAN_TRUE + ")");
    }

    private static class LineIterator {
        private final BufferedReader reader;
        private final Queue<String> extraLines;
        private String next;

        public LineIterator(Queue<String> extraLines, BufferedReader reader) {
            this.extraLines = extraLines;
            this.reader = reader;
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            if (!this.extraLines.isEmpty()) {
                this.next = this.extraLines.poll();
                return true;
            }
            while ((this.next = this.reader.readLine()) != null) {
                this.next = this.next.trim();
                if (this.next.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public String next() throws IOException {
            String result = null;
            if (this.hasNext()) {
                result = this.next;
                this.next = null;
            }
            return result;
        }
    }
}

