/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls.playlist;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import java.util.Collections;
import java.util.List;

public final class HlsMasterPlaylist
extends HlsPlaylist {
    public final List<HlsUrl> variants;
    public final List<HlsUrl> audios;
    public final List<HlsUrl> subtitles;
    public final Format muxedAudioFormat;
    public final Format muxedCaptionFormat;

    public HlsMasterPlaylist(String baseUri, List<HlsUrl> variants, List<HlsUrl> audios, List<HlsUrl> subtitles, Format muxedAudioFormat, Format muxedCaptionFormat) {
        super(baseUri, 0);
        this.variants = Collections.unmodifiableList(variants);
        this.audios = Collections.unmodifiableList(audios);
        this.subtitles = Collections.unmodifiableList(subtitles);
        this.muxedAudioFormat = muxedAudioFormat;
        this.muxedCaptionFormat = muxedCaptionFormat;
    }

    public static final class HlsUrl {
        public final String name;
        public final String url;
        public final Format format;
        public final Format videoFormat;
        public final Format audioFormat;
        public final Format[] textFormats;

        public static HlsUrl createMediaPlaylistHlsUrl(String baseUri) {
            Format format = Format.createContainerFormat("0", "application/x-mpegURL", null, null, -1);
            return new HlsUrl(null, baseUri, format, null, null, null);
        }

        public HlsUrl(String name, String url, Format format, Format videoFormat, Format audioFormat, Format[] textFormats) {
            this.name = name;
            this.url = url;
            this.format = format;
            this.videoFormat = videoFormat;
            this.audioFormat = audioFormat;
            this.textFormats = textFormats;
        }
    }
}

