/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.os.Handler;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.DefaultTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsInitializationChunk;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStream;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import java.io.IOException;
import java.util.LinkedList;

final class HlsSampleStreamWrapper
implements Loader.Callback<Chunk>,
SequenceableLoader,
ExtractorOutput,
DefaultTrackOutput.UpstreamFormatChangedListener {
    private static final int PRIMARY_TYPE_NONE = 0;
    private static final int PRIMARY_TYPE_TEXT = 1;
    private static final int PRIMARY_TYPE_AUDIO = 2;
    private static final int PRIMARY_TYPE_VIDEO = 3;
    private final int trackType;
    private final Callback callback;
    private final HlsChunkSource chunkSource;
    private final Allocator allocator;
    private final Format muxedAudioFormat;
    private final Format muxedCaptionFormat;
    private final int minLoadableRetryCount;
    private final Loader loader;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private final HlsChunkSource.HlsChunkHolder nextChunkHolder;
    private final SparseArray<DefaultTrackOutput> sampleQueues;
    private final LinkedList<HlsMediaChunk> mediaChunks;
    private final Runnable maybeFinishPrepareRunnable;
    private final Handler handler;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    private int enabledTrackCount;
    private Format downstreamTrackFormat;
    private int upstreamChunkUid;
    private boolean released;
    private TrackGroupArray trackGroups;
    private int primaryTrackGroupIndex;
    private boolean[] groupEnabledStates;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean loadingFinished;

    public HlsSampleStreamWrapper(int trackType, Callback callback, HlsChunkSource chunkSource, Allocator allocator, long positionUs, Format muxedAudioFormat, Format muxedCaptionFormat, int minLoadableRetryCount, AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher) {
        this.trackType = trackType;
        this.callback = callback;
        this.chunkSource = chunkSource;
        this.allocator = allocator;
        this.muxedAudioFormat = muxedAudioFormat;
        this.muxedCaptionFormat = muxedCaptionFormat;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.loader = new Loader("Loader:HlsSampleStreamWrapper");
        this.nextChunkHolder = new HlsChunkSource.HlsChunkHolder();
        this.sampleQueues = new SparseArray();
        this.mediaChunks = new LinkedList();
        this.maybeFinishPrepareRunnable = new Runnable(){

            @Override
            public void run() {
                HlsSampleStreamWrapper.this.maybeFinishPrepare();
            }
        };
        this.handler = new Handler();
        this.lastSeekPositionUs = positionUs;
        this.pendingResetPositionUs = positionUs;
    }

    public void continuePreparing() {
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        }
    }

    public void prepareSingleTrack(Format format) {
        this.track(0).format(format);
        this.sampleQueuesBuilt = true;
        this.maybeFinishPrepare();
    }

    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
    }

    public long getDurationUs() {
        return this.chunkSource.getDurationUs();
    }

    public boolean isLive() {
        return this.chunkSource.isLive();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public boolean selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, boolean isFirstTrackSelection) {
        Assertions.checkState(this.prepared);
        for (int i = 0; i < selections.length; ++i) {
            if (streams[i] == null || selections[i] != null && mayRetainStreamFlags[i]) continue;
            int group = ((HlsSampleStream)streams[i]).group;
            this.setTrackGroupEnabledState(group, false);
            ((DefaultTrackOutput)this.sampleQueues.valueAt(group)).disable();
            streams[i] = null;
        }
        boolean selectedNewTracks = false;
        for (int i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            TrackSelection selection = selections[i];
            int group = this.trackGroups.indexOf(selection.getTrackGroup());
            this.setTrackGroupEnabledState(group, true);
            if (group == this.primaryTrackGroupIndex) {
                this.chunkSource.selectTracks(selection);
            }
            streams[i] = new HlsSampleStream(this, group);
            streamResetFlags[i] = true;
            selectedNewTracks = true;
        }
        if (isFirstTrackSelection) {
            int sampleQueueCount = this.sampleQueues.size();
            for (int i = 0; i < sampleQueueCount; ++i) {
                if (this.groupEnabledStates[i]) continue;
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).disable();
            }
        }
        if (this.enabledTrackCount == 0) {
            this.chunkSource.reset();
            this.downstreamTrackFormat = null;
            this.mediaChunks.clear();
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            }
        }
        return selectedNewTracks;
    }

    public void seekTo(long positionUs) {
        this.lastSeekPositionUs = positionUs;
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        this.mediaChunks.clear();
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            int sampleQueueCount = this.sampleQueues.size();
            for (int i = 0; i < sampleQueueCount; ++i) {
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).reset(this.groupEnabledStates[i]);
            }
        }
    }

    public long getBufferedPositionUs() {
        HlsMediaChunk lastCompletedMediaChunk;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long bufferedPositionUs = this.lastSeekPositionUs;
        HlsMediaChunk lastMediaChunk = this.mediaChunks.getLast();
        HlsMediaChunk hlsMediaChunk = lastMediaChunk.isLoadCompleted() ? lastMediaChunk : (lastCompletedMediaChunk = this.mediaChunks.size() > 1 ? this.mediaChunks.get(this.mediaChunks.size() - 2) : null);
        if (lastCompletedMediaChunk != null) {
            bufferedPositionUs = Math.max(bufferedPositionUs, lastCompletedMediaChunk.endTimeUs);
        }
        int sampleQueueCount = this.sampleQueues.size();
        for (int i = 0; i < sampleQueueCount; ++i) {
            bufferedPositionUs = Math.max(bufferedPositionUs, ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getLargestQueuedTimestampUs());
        }
        return bufferedPositionUs;
    }

    public void release() {
        int sampleQueueCount = this.sampleQueues.size();
        for (int i = 0; i < sampleQueueCount; ++i) {
            ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).disable();
        }
        this.loader.release();
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
    }

    public long getLargestQueuedTimestampUs() {
        long largestQueuedTimestampUs = Long.MIN_VALUE;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            largestQueuedTimestampUs = Math.max(largestQueuedTimestampUs, ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getLargestQueuedTimestampUs());
        }
        return largestQueuedTimestampUs;
    }

    boolean isReady(int group) {
        return this.loadingFinished || !this.isPendingReset() && !((DefaultTrackOutput)this.sampleQueues.valueAt(group)).isEmpty();
    }

    void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
        this.chunkSource.maybeThrowError();
    }

    int readData(int group, FormatHolder formatHolder, DecoderInputBuffer buffer) {
        if (this.isPendingReset()) {
            return -3;
        }
        while (this.mediaChunks.size() > 1 && this.finishedReadingChunk(this.mediaChunks.getFirst())) {
            this.mediaChunks.removeFirst();
        }
        HlsMediaChunk currentChunk = this.mediaChunks.getFirst();
        Format trackFormat = currentChunk.trackFormat;
        if (!trackFormat.equals(this.downstreamTrackFormat)) {
            this.eventDispatcher.downstreamFormatChanged(this.trackType, trackFormat, currentChunk.trackSelectionReason, currentChunk.trackSelectionData, currentChunk.startTimeUs);
        }
        this.downstreamTrackFormat = trackFormat;
        return ((DefaultTrackOutput)this.sampleQueues.valueAt(group)).readData(formatHolder, buffer, this.loadingFinished, this.lastSeekPositionUs);
    }

    void skipToKeyframeBefore(int group, long timeUs) {
        ((DefaultTrackOutput)this.sampleQueues.valueAt(group)).skipToKeyframeBefore(timeUs);
    }

    private boolean finishedReadingChunk(HlsMediaChunk chunk) {
        int chunkUid = chunk.uid;
        for (int i = 0; i < this.sampleQueues.size(); ++i) {
            if (!this.groupEnabledStates[i] || ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).peekSourceId() != chunkUid) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        if (this.loader.isLoading()) {
            return false;
        }
        this.chunkSource.getNextChunk(this.mediaChunks.isEmpty() ? null : this.mediaChunks.getLast(), this.pendingResetPositionUs != -9223372036854775807L ? this.pendingResetPositionUs : positionUs, this.nextChunkHolder);
        boolean endOfStream = this.nextChunkHolder.endOfStream;
        Chunk loadable = this.nextChunkHolder.chunk;
        long retryInMs = this.nextChunkHolder.retryInMs;
        this.nextChunkHolder.clear();
        if (endOfStream) {
            this.loadingFinished = true;
            return true;
        }
        if (loadable == null) {
            if (retryInMs != -9223372036854775807L) {
                Assertions.checkState(this.chunkSource.isLive());
                this.callback.onContinueLoadingRequiredInMs(this, retryInMs);
            }
            return false;
        }
        if (this.isMediaChunk(loadable)) {
            this.pendingResetPositionUs = -9223372036854775807L;
            HlsMediaChunk mediaChunk = (HlsMediaChunk)loadable;
            mediaChunk.init(this);
            this.mediaChunks.add(mediaChunk);
        } else if (loadable instanceof HlsInitializationChunk) {
            ((HlsInitializationChunk)loadable).init(this);
        }
        long elapsedRealtimeMs = this.loader.startLoading(loadable, this, this.minLoadableRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs);
        return true;
    }

    @Override
    public long getNextLoadPositionUs() {
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        return this.loadingFinished ? Long.MIN_VALUE : this.mediaChunks.getLast().endTimeUs;
    }

    @Override
    public void onLoadCompleted(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.chunkSource.onChunkLoadCompleted(loadable);
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!this.prepared) {
            this.continueLoading(this.lastSeekPositionUs);
        } else {
            this.callback.onContinueLoadingRequested(this);
        }
    }

    @Override
    public void onLoadCanceled(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        if (!released) {
            int sampleQueueCount = this.sampleQueues.size();
            for (int i = 0; i < sampleQueueCount; ++i) {
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).reset(this.groupEnabledStates[i]);
            }
            this.callback.onContinueLoadingRequested(this);
        }
    }

    @Override
    public int onLoadError(Chunk loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        long bytesLoaded = loadable.bytesLoaded();
        boolean isMediaChunk = this.isMediaChunk(loadable);
        boolean cancelable = !isMediaChunk || bytesLoaded == 0L;
        boolean canceled = false;
        if (this.chunkSource.onChunkLoadError(loadable, cancelable, error)) {
            if (isMediaChunk) {
                HlsMediaChunk removed = this.mediaChunks.removeLast();
                Assertions.checkState(removed == loadable);
                if (this.mediaChunks.isEmpty()) {
                    this.pendingResetPositionUs = this.lastSeekPositionUs;
                }
            }
            canceled = true;
        }
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, this.trackType, loadable.trackFormat, loadable.trackSelectionReason, loadable.trackSelectionData, loadable.startTimeUs, loadable.endTimeUs, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, canceled);
        if (canceled) {
            if (!this.prepared) {
                this.continueLoading(this.lastSeekPositionUs);
            } else {
                this.callback.onContinueLoadingRequested(this);
            }
            return 2;
        }
        return 0;
    }

    public void init(int chunkUid, boolean shouldSpliceIn) {
        int i;
        this.upstreamChunkUid = chunkUid;
        for (i = 0; i < this.sampleQueues.size(); ++i) {
            ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).sourceId(chunkUid);
        }
        if (shouldSpliceIn) {
            for (i = 0; i < this.sampleQueues.size(); ++i) {
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).splice();
            }
        }
    }

    @Override
    public DefaultTrackOutput track(int id) {
        if (this.sampleQueues.indexOfKey(id) >= 0) {
            return (DefaultTrackOutput)this.sampleQueues.get(id);
        }
        DefaultTrackOutput trackOutput = new DefaultTrackOutput(this.allocator);
        trackOutput.setUpstreamFormatChangeListener(this);
        trackOutput.sourceId(this.upstreamChunkUid);
        this.sampleQueues.put(id, (Object)trackOutput);
        return trackOutput;
    }

    @Override
    public void endTracks() {
        this.sampleQueuesBuilt = true;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    @Override
    public void seekMap(SeekMap seekMap) {
    }

    @Override
    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    private void maybeFinishPrepare() {
        if (this.released || this.prepared || !this.sampleQueuesBuilt) {
            return;
        }
        int sampleQueueCount = this.sampleQueues.size();
        for (int i = 0; i < sampleQueueCount; ++i) {
            if (((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getUpstreamFormat() != null) continue;
            return;
        }
        this.buildTracks();
        this.prepared = true;
        this.callback.onPrepared();
    }

    private void buildTracks() {
        int primaryExtractorTrackType = 0;
        int primaryExtractorTrackIndex = -1;
        int extractorTrackCount = this.sampleQueues.size();
        for (int i = 0; i < extractorTrackCount; ++i) {
            String sampleMimeType = ((DefaultTrackOutput)this.sampleQueues.valueAt((int)i)).getUpstreamFormat().sampleMimeType;
            int trackType = MimeTypes.isVideo(sampleMimeType) ? 3 : (MimeTypes.isAudio(sampleMimeType) ? 2 : (MimeTypes.isText(sampleMimeType) ? 1 : 0));
            if (trackType > primaryExtractorTrackType) {
                primaryExtractorTrackType = trackType;
                primaryExtractorTrackIndex = i;
                continue;
            }
            if (trackType != primaryExtractorTrackType || primaryExtractorTrackIndex == -1) continue;
            primaryExtractorTrackIndex = -1;
        }
        TrackGroup chunkSourceTrackGroup = this.chunkSource.getTrackGroup();
        int chunkSourceTrackCount = chunkSourceTrackGroup.length;
        this.primaryTrackGroupIndex = -1;
        this.groupEnabledStates = new boolean[extractorTrackCount];
        TrackGroup[] trackGroups = new TrackGroup[extractorTrackCount];
        for (int i = 0; i < extractorTrackCount; ++i) {
            Format sampleFormat = ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getUpstreamFormat();
            if (i == primaryExtractorTrackIndex) {
                Format[] formats = new Format[chunkSourceTrackCount];
                for (int j = 0; j < chunkSourceTrackCount; ++j) {
                    formats[j] = HlsSampleStreamWrapper.deriveFormat(chunkSourceTrackGroup.getFormat(j), sampleFormat);
                }
                trackGroups[i] = new TrackGroup(formats);
                this.primaryTrackGroupIndex = i;
                continue;
            }
            Format trackFormat = null;
            if (primaryExtractorTrackType == 3) {
                if (MimeTypes.isAudio(sampleFormat.sampleMimeType)) {
                    trackFormat = this.muxedAudioFormat;
                } else if ("application/cea-608".equals(sampleFormat.sampleMimeType)) {
                    trackFormat = this.muxedCaptionFormat;
                }
            }
            trackGroups[i] = new TrackGroup(HlsSampleStreamWrapper.deriveFormat(trackFormat, sampleFormat));
        }
        this.trackGroups = new TrackGroupArray(trackGroups);
    }

    private void setTrackGroupEnabledState(int group, boolean enabledState) {
        Assertions.checkState(this.groupEnabledStates[group] != enabledState);
        this.groupEnabledStates[group] = enabledState;
        this.enabledTrackCount += enabledState ? 1 : -1;
    }

    private static Format deriveFormat(Format containerFormat, Format sampleFormat) {
        if (containerFormat == null) {
            return sampleFormat;
        }
        String codecs = null;
        int sampleTrackType = MimeTypes.getTrackType(sampleFormat.sampleMimeType);
        if (sampleTrackType == 1) {
            codecs = HlsSampleStreamWrapper.getAudioCodecs(containerFormat.codecs);
        } else if (sampleTrackType == 2) {
            codecs = HlsSampleStreamWrapper.getVideoCodecs(containerFormat.codecs);
        }
        return sampleFormat.copyWithContainerInfo(containerFormat.id, codecs, containerFormat.bitrate, containerFormat.width, containerFormat.height, containerFormat.selectionFlags, containerFormat.language);
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof HlsMediaChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private static String getAudioCodecs(String codecs) {
        return HlsSampleStreamWrapper.getCodecsOfType(codecs, 1);
    }

    private static String getVideoCodecs(String codecs) {
        return HlsSampleStreamWrapper.getCodecsOfType(codecs, 2);
    }

    private static String getCodecsOfType(String codecs, int trackType) {
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return null;
        }
        String[] codecArray = codecs.split("(\\s*,\\s*)|(\\s*$)");
        StringBuilder builder = new StringBuilder();
        for (String codec : codecArray) {
            if (trackType != MimeTypes.getTrackTypeOfCodec(codec)) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(codec);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public static interface Callback
    extends SequenceableLoader.Callback<HlsSampleStreamWrapper> {
        public void onPrepared();

        public void onContinueLoadingRequiredInMs(HlsSampleStreamWrapper var1, long var2);
    }
}

