/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.hls.HlsMediaPeriod;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.util.Assertions;

public final class HlsMediaSource
implements MediaSource {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    private final Uri manifestUri;
    private final DataSource.Factory dataSourceFactory;
    private final int minLoadableRetryCount;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private MediaSource.Listener sourceListener;

    public HlsMediaSource(Uri manifestUri, DataSource.Factory dataSourceFactory, Handler eventHandler, AdaptiveMediaSourceEventListener eventListener) {
        this(manifestUri, dataSourceFactory, 3, eventHandler, eventListener);
    }

    public HlsMediaSource(Uri manifestUri, DataSource.Factory dataSourceFactory, int minLoadableRetryCount, Handler eventHandler, AdaptiveMediaSourceEventListener eventListener) {
        this.manifestUri = manifestUri;
        this.dataSourceFactory = dataSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = new AdaptiveMediaSourceEventListener.EventDispatcher(eventHandler, eventListener);
    }

    @Override
    public void prepareSource(MediaSource.Listener listener) {
        this.sourceListener = listener;
        listener.onSourceInfoRefreshed(new SinglePeriodTimeline(-9223372036854775807L, false), null);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        Assertions.checkArgument(index == 0);
        return new HlsMediaPeriod(this.manifestUri, this.dataSourceFactory, this.minLoadableRetryCount, this.eventDispatcher, this.sourceListener, allocator, positionUs);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((HlsMediaPeriod)mediaPeriod).release();
    }

    @Override
    public void releaseSource() {
        this.sourceListener = null;
    }
}

