/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.CompositeSequenceableLoader;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.hls.HlsChunkSource;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

final class HlsMediaPeriod
implements MediaPeriod,
Loader.Callback<ParsingLoadable<HlsPlaylist>>,
HlsSampleStreamWrapper.Callback {
    private final Uri manifestUri;
    private final DataSource.Factory dataSourceFactory;
    private final int minLoadableRetryCount;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private final MediaSource.Listener sourceListener;
    private final Allocator allocator;
    private final IdentityHashMap<SampleStream, Integer> streamWrapperIndices;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final HlsPlaylistParser manifestParser;
    private final Handler continueLoadingHandler;
    private final Loader manifestFetcher;
    private final long preparePositionUs;
    private final Runnable continueLoadingRunnable;
    private MediaPeriod.Callback callback;
    private int pendingPrepareCount;
    private HlsPlaylist playlist;
    private boolean seenFirstTrackSelection;
    private long durationUs;
    private boolean isLive;
    private TrackGroupArray trackGroups;
    private HlsSampleStreamWrapper[] sampleStreamWrappers;
    private HlsSampleStreamWrapper[] enabledSampleStreamWrappers;
    private CompositeSequenceableLoader sequenceableLoader;

    public HlsMediaPeriod(Uri manifestUri, DataSource.Factory dataSourceFactory, int minLoadableRetryCount, AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher, MediaSource.Listener sourceListener, Allocator allocator, long positionUs) {
        this.manifestUri = manifestUri;
        this.dataSourceFactory = dataSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventDispatcher = eventDispatcher;
        this.sourceListener = sourceListener;
        this.allocator = allocator;
        this.streamWrapperIndices = new IdentityHashMap();
        this.timestampAdjusterProvider = new TimestampAdjusterProvider();
        this.manifestParser = new HlsPlaylistParser();
        this.continueLoadingHandler = new Handler();
        this.manifestFetcher = new Loader("Loader:ManifestFetcher");
        this.preparePositionUs = positionUs;
        this.continueLoadingRunnable = new Runnable(){

            @Override
            public void run() {
                HlsMediaPeriod.this.callback.onContinueLoadingRequested(HlsMediaPeriod.this);
            }
        };
    }

    public void release() {
        this.continueLoadingHandler.removeCallbacksAndMessages(null);
        this.manifestFetcher.release();
        if (this.sampleStreamWrappers != null) {
            for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
                sampleStreamWrapper.release();
            }
        }
    }

    @Override
    public void prepare(MediaPeriod.Callback callback) {
        this.callback = callback;
        ParsingLoadable<HlsPlaylist> loadable = new ParsingLoadable<HlsPlaylist>(this.dataSourceFactory.createDataSource(), this.manifestUri, 4, this.manifestParser);
        long elapsedRealtimeMs = this.manifestFetcher.startLoading(loadable, this, this.minLoadableRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, elapsedRealtimeMs);
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        if (this.sampleStreamWrappers == null) {
            this.manifestFetcher.maybeThrowError();
        } else {
            for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
                sampleStreamWrapper.maybeThrowPrepareError();
            }
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    @Override
    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        int[] streamChildIndices = new int[selections.length];
        int[] selectionChildIndices = new int[selections.length];
        block0: for (int i2 = 0; i2 < selections.length; ++i2) {
            streamChildIndices[i2] = streams[i2] == null ? -1 : this.streamWrapperIndices.get(streams[i2]);
            selectionChildIndices[i2] = -1;
            if (selections[i2] == null) continue;
            TrackGroup trackGroup = selections[i2].getTrackGroup();
            for (int j = 0; j < this.sampleStreamWrappers.length; ++j) {
                if (this.sampleStreamWrappers[j].getTrackGroups().indexOf(trackGroup) == -1) continue;
                selectionChildIndices[i2] = j;
                continue block0;
            }
        }
        boolean selectedNewTracks = false;
        this.streamWrapperIndices.clear();
        SampleStream[] newStreams = new SampleStream[selections.length];
        SampleStream[] childStreams = new SampleStream[selections.length];
        TrackSelection[] childSelections = new TrackSelection[selections.length];
        ArrayList<HlsSampleStreamWrapper> enabledSampleStreamWrapperList = new ArrayList<HlsSampleStreamWrapper>(this.sampleStreamWrappers.length);
        for (i = 0; i < this.sampleStreamWrappers.length; ++i) {
            for (int j = 0; j < selections.length; ++j) {
                childStreams[j] = streamChildIndices[j] == i ? streams[j] : null;
                childSelections[j] = selectionChildIndices[j] == i ? selections[j] : null;
            }
            selectedNewTracks |= this.sampleStreamWrappers[i].selectTracks(childSelections, mayRetainStreamFlags, childStreams, streamResetFlags, !this.seenFirstTrackSelection);
            boolean wrapperEnabled = false;
            for (int j = 0; j < selections.length; ++j) {
                if (selectionChildIndices[j] == i) {
                    Assertions.checkState(childStreams[j] != null);
                    newStreams[j] = childStreams[j];
                    wrapperEnabled = true;
                    this.streamWrapperIndices.put(childStreams[j], i);
                    continue;
                }
                if (streamChildIndices[j] != i) continue;
                Assertions.checkState(childStreams[j] == null);
            }
            if (!wrapperEnabled) continue;
            enabledSampleStreamWrapperList.add(this.sampleStreamWrappers[i]);
        }
        System.arraycopy(newStreams, 0, streams, 0, newStreams.length);
        this.enabledSampleStreamWrappers = new HlsSampleStreamWrapper[enabledSampleStreamWrapperList.size()];
        enabledSampleStreamWrapperList.toArray(this.enabledSampleStreamWrappers);
        this.sequenceableLoader = new CompositeSequenceableLoader(this.enabledSampleStreamWrappers);
        if (this.seenFirstTrackSelection && selectedNewTracks) {
            this.seekToUs(positionUs);
            for (i = 0; i < selections.length; ++i) {
                if (streams[i] == null) continue;
                streamResetFlags[i] = true;
            }
        }
        this.seenFirstTrackSelection = true;
        return positionUs;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        return this.sequenceableLoader.continueLoading(positionUs);
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.sequenceableLoader.getNextLoadPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    @Override
    public long getBufferedPositionUs() {
        long bufferedPositionUs = Long.MAX_VALUE;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.enabledSampleStreamWrappers) {
            long rendererBufferedPositionUs = sampleStreamWrapper.getBufferedPositionUs();
            if (rendererBufferedPositionUs == Long.MIN_VALUE) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, rendererBufferedPositionUs);
        }
        return bufferedPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : bufferedPositionUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        positionUs = this.isLive ? 0L : positionUs;
        this.timestampAdjusterProvider.reset();
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.enabledSampleStreamWrappers) {
            sampleStreamWrapper.seekTo(positionUs);
        }
        return positionUs;
    }

    @Override
    public void onLoadCompleted(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.playlist = loadable.getResult();
        this.buildAndPrepareSampleStreamWrappers();
    }

    @Override
    public void onLoadCanceled(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    @Override
    public int onLoadError(ParsingLoadable<HlsPlaylist> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        boolean isFatal = error instanceof ParserException;
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
        return isFatal ? 3 : 0;
    }

    @Override
    public void onPrepared() {
        if (--this.pendingPrepareCount > 0) {
            return;
        }
        this.durationUs = this.sampleStreamWrappers[0].getDurationUs();
        this.isLive = this.sampleStreamWrappers[0].isLive();
        int totalTrackGroupCount = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            totalTrackGroupCount += sampleStreamWrapper.getTrackGroups().length;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[totalTrackGroupCount];
        int trackGroupIndex = 0;
        for (HlsSampleStreamWrapper sampleStreamWrapper : this.sampleStreamWrappers) {
            int wrapperTrackGroupCount = sampleStreamWrapper.getTrackGroups().length;
            for (int j = 0; j < wrapperTrackGroupCount; ++j) {
                trackGroupArray[trackGroupIndex++] = sampleStreamWrapper.getTrackGroups().get(j);
            }
        }
        this.trackGroups = new TrackGroupArray(trackGroupArray);
        this.callback.onPrepared(this);
        SinglePeriodTimeline timeline = new SinglePeriodTimeline(this.durationUs, this.durationUs, 0L, 0L, !this.isLive, this.isLive);
        this.sourceListener.onSourceInfoRefreshed(timeline, this.playlist);
    }

    @Override
    public void onContinueLoadingRequiredInMs(HlsSampleStreamWrapper sampleStreamWrapper, long delayMs) {
        this.continueLoadingHandler.postDelayed(this.continueLoadingRunnable, delayMs);
    }

    @Override
    public void onContinueLoadingRequested(HlsSampleStreamWrapper sampleStreamWrapper) {
        if (this.trackGroups == null) {
            return;
        }
        this.callback.onContinueLoadingRequested(this);
    }

    private void buildAndPrepareSampleStreamWrappers() {
        int i;
        HlsSampleStreamWrapper sampleStreamWrapper;
        String baseUri = this.playlist.baseUri;
        if (this.playlist instanceof HlsMediaPlaylist) {
            HlsMasterPlaylist.HlsUrl[] variants = new HlsMasterPlaylist.HlsUrl[]{HlsMasterPlaylist.HlsUrl.createMediaPlaylistHlsUrl(this.playlist.baseUri)};
            this.sampleStreamWrappers = new HlsSampleStreamWrapper[]{this.buildSampleStreamWrapper(0, baseUri, variants, null, null)};
            this.pendingPrepareCount = 1;
            this.sampleStreamWrappers[0].continuePreparing();
            return;
        }
        HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)this.playlist;
        ArrayList<HlsMasterPlaylist.HlsUrl> selectedVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>(masterPlaylist.variants);
        ArrayList<HlsMasterPlaylist.HlsUrl> definiteVideoVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        ArrayList<HlsMasterPlaylist.HlsUrl> definiteAudioOnlyVariants = new ArrayList<HlsMasterPlaylist.HlsUrl>();
        for (int i2 = 0; i2 < selectedVariants.size(); ++i2) {
            HlsMasterPlaylist.HlsUrl variant = (HlsMasterPlaylist.HlsUrl)selectedVariants.get(i2);
            if (variant.format.height > 0 || HlsMediaPeriod.variantHasExplicitCodecWithPrefix(variant, "avc")) {
                definiteVideoVariants.add(variant);
                continue;
            }
            if (!HlsMediaPeriod.variantHasExplicitCodecWithPrefix(variant, "mp4a")) continue;
            definiteAudioOnlyVariants.add(variant);
        }
        if (!definiteVideoVariants.isEmpty()) {
            selectedVariants = definiteVideoVariants;
        } else if (definiteAudioOnlyVariants.size() < selectedVariants.size()) {
            selectedVariants.removeAll(definiteAudioOnlyVariants);
        }
        List<HlsMasterPlaylist.HlsUrl> audioVariants = masterPlaylist.audios;
        List<HlsMasterPlaylist.HlsUrl> subtitleVariants = masterPlaylist.subtitles;
        this.sampleStreamWrappers = new HlsSampleStreamWrapper[(selectedVariants.isEmpty() ? 0 : 1) + audioVariants.size() + subtitleVariants.size()];
        int currentWrapperIndex = 0;
        this.pendingPrepareCount = this.sampleStreamWrappers.length;
        if (!selectedVariants.isEmpty()) {
            HlsMasterPlaylist.HlsUrl[] variants = new HlsMasterPlaylist.HlsUrl[selectedVariants.size()];
            selectedVariants.toArray(variants);
            sampleStreamWrapper = this.buildSampleStreamWrapper(0, baseUri, variants, masterPlaylist.muxedAudioFormat, masterPlaylist.muxedCaptionFormat);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
            sampleStreamWrapper.continuePreparing();
        }
        for (i = 0; i < audioVariants.size(); ++i) {
            sampleStreamWrapper = this.buildSampleStreamWrapper(1, baseUri, new HlsMasterPlaylist.HlsUrl[]{audioVariants.get(i)}, null, null);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper;
            sampleStreamWrapper.continuePreparing();
        }
        for (i = 0; i < subtitleVariants.size(); ++i) {
            HlsMasterPlaylist.HlsUrl url = subtitleVariants.get(i);
            HlsSampleStreamWrapper sampleStreamWrapper2 = this.buildSampleStreamWrapper(3, baseUri, new HlsMasterPlaylist.HlsUrl[]{url}, null, null);
            sampleStreamWrapper2.prepareSingleTrack(url.format);
            this.sampleStreamWrappers[currentWrapperIndex++] = sampleStreamWrapper2;
        }
    }

    private HlsSampleStreamWrapper buildSampleStreamWrapper(int trackType, String baseUri, HlsMasterPlaylist.HlsUrl[] variants, Format muxedAudioFormat, Format muxedCaptionFormat) {
        DataSource dataSource = this.dataSourceFactory.createDataSource();
        HlsChunkSource defaultChunkSource = new HlsChunkSource(baseUri, variants, dataSource, this.timestampAdjusterProvider);
        return new HlsSampleStreamWrapper(trackType, this, defaultChunkSource, this.allocator, this.preparePositionUs, muxedAudioFormat, muxedCaptionFormat, this.minLoadableRetryCount, this.eventDispatcher);
    }

    private static boolean variantHasExplicitCodecWithPrefix(HlsMasterPlaylist.HlsUrl variant, String prefix) {
        String[] codecArray;
        String codecs = variant.format.codecs;
        if (TextUtils.isEmpty((CharSequence)codecs)) {
            return false;
        }
        for (String codec : codecArray = codecs.split("(\\s*,\\s*)|(\\s*$)")) {
            if (!codec.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

