/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.TimestampAdjuster;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.hls.Aes128DataSource;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

final class HlsMediaChunk
extends MediaChunk {
    private static final AtomicInteger UID_SOURCE = new AtomicInteger();
    public final int uid;
    public final int discontinuitySequenceNumber;
    public final Extractor extractor;
    private final boolean isEncrypted;
    private final boolean extractorNeedsInit;
    private final boolean shouldSpliceIn;
    private final boolean isMasterTimestampSource;
    private final TimestampAdjuster timestampAdjuster;
    private int bytesLoaded;
    private HlsSampleStreamWrapper extractorOutput;
    private long adjustedEndTimeUs;
    private volatile boolean loadCanceled;
    private volatile boolean loadCompleted;

    public HlsMediaChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long startTimeUs, long endTimeUs, int chunkIndex, int discontinuitySequenceNumber, boolean isMasterTimestampSource, TimestampAdjuster timestampAdjuster, Extractor extractor, boolean extractorNeedsInit, boolean shouldSpliceIn, byte[] encryptionKey, byte[] encryptionIv) {
        super(HlsMediaChunk.buildDataSource(dataSource, encryptionKey, encryptionIv), dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkIndex);
        this.discontinuitySequenceNumber = discontinuitySequenceNumber;
        this.isMasterTimestampSource = isMasterTimestampSource;
        this.timestampAdjuster = timestampAdjuster;
        this.extractor = extractor;
        this.extractorNeedsInit = extractorNeedsInit;
        this.shouldSpliceIn = shouldSpliceIn;
        this.adjustedEndTimeUs = startTimeUs;
        this.isEncrypted = this.dataSource instanceof Aes128DataSource;
        this.uid = UID_SOURCE.getAndIncrement();
    }

    public void init(HlsSampleStreamWrapper output) {
        this.extractorOutput = output;
        output.init(this.uid, this.shouldSpliceIn);
        if (this.extractorNeedsInit) {
            this.extractor.init(output);
        }
    }

    public long getAdjustedStartTimeUs() {
        return this.adjustedEndTimeUs - this.getDurationUs();
    }

    public long getAdjustedEndTimeUs() {
        return this.adjustedEndTimeUs;
    }

    @Override
    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        boolean skipLoadedBytes;
        DataSpec loadDataSpec;
        if (this.isEncrypted) {
            loadDataSpec = this.dataSpec;
            skipLoadedBytes = this.bytesLoaded != 0;
        } else {
            loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
            skipLoadedBytes = false;
        }
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            if (skipLoadedBytes) {
                input.skipFully(this.bytesLoaded);
            }
            try {
                int result = 0;
                if (!this.isMasterTimestampSource && this.timestampAdjuster != null) {
                    this.timestampAdjuster.waitUntilInitialized();
                }
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read(input, null);
                }
                long adjustedEndTimeUs = this.extractorOutput.getLargestQueuedTimestampUs();
                if (adjustedEndTimeUs != Long.MIN_VALUE) {
                    this.adjustedEndTimeUs = adjustedEndTimeUs;
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
        this.loadCompleted = true;
    }

    private static DataSource buildDataSource(DataSource dataSource, byte[] encryptionKey, byte[] encryptionIv) {
        if (encryptionKey == null || encryptionIv == null) {
            return dataSource;
        }
        return new Aes128DataSource(dataSource, encryptionKey, encryptionIv);
    }
}

