/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.hls.HlsSampleStreamWrapper;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class HlsInitializationChunk
extends Chunk {
    public final Format format;
    public final Extractor extractor;
    private int bytesLoaded;
    private volatile boolean loadCanceled;

    public HlsInitializationChunk(DataSource dataSource, DataSpec dataSpec, int trackSelectionReason, Object trackSelectionData, Extractor extractor, Format format) {
        super(dataSource, dataSpec, 0, null, trackSelectionReason, trackSelectionData, -9223372036854775807L, -9223372036854775807L);
        this.extractor = extractor;
        this.format = format;
    }

    public void init(HlsSampleStreamWrapper output) {
        this.extractor.init(output);
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        DataSpec loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractor.read(input, null);
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }
}

