/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.hls;

import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.TimestampAdjuster;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.ts.Ac3Extractor;
import com.google.android.exoplayer2.extractor.ts.AdtsExtractor;
import com.google.android.exoplayer2.extractor.ts.DefaultStreamReaderFactory;
import com.google.android.exoplayer2.extractor.ts.TsExtractor;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkedTrackBlacklistUtil;
import com.google.android.exoplayer2.source.chunk.DataChunk;
import com.google.android.exoplayer2.source.hls.HlsInitializationChunk;
import com.google.android.exoplayer2.source.hls.HlsMediaChunk;
import com.google.android.exoplayer2.source.hls.TimestampAdjusterProvider;
import com.google.android.exoplayer2.source.hls.WebvttExtractor;
import com.google.android.exoplayer2.source.hls.playlist.HlsMasterPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsMediaPlaylist;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParser;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;

class HlsChunkSource {
    public static final long DEFAULT_PLAYLIST_BLACKLIST_MS = 60000L;
    private static final double LIVE_VARIANT_SWITCH_SAFETY_EXTRA_SECS = 2.0;
    private static final String AAC_FILE_EXTENSION = ".aac";
    private static final String AC3_FILE_EXTENSION = ".ac3";
    private static final String EC3_FILE_EXTENSION = ".ec3";
    private static final String MP3_FILE_EXTENSION = ".mp3";
    private static final String MP4_FILE_EXTENSION = ".mp4";
    private static final String VTT_FILE_EXTENSION = ".vtt";
    private static final String WEBVTT_FILE_EXTENSION = ".webvtt";
    private final String baseUri;
    private final DataSource dataSource;
    private final HlsPlaylistParser playlistParser;
    private final TimestampAdjusterProvider timestampAdjusterProvider;
    private final HlsMasterPlaylist.HlsUrl[] variants;
    private final HlsMediaPlaylist[] variantPlaylists;
    private final TrackGroup trackGroup;
    private final long[] variantLastPlaylistLoadTimesMs;
    private byte[] scratchSpace;
    private boolean live;
    private long durationUs;
    private IOException fatalError;
    private HlsInitializationChunk lastLoadedInitializationChunk;
    private Uri encryptionKeyUri;
    private byte[] encryptionKey;
    private String encryptionIvString;
    private byte[] encryptionIv;
    private TrackSelection trackSelection;

    public HlsChunkSource(String baseUri, HlsMasterPlaylist.HlsUrl[] variants, DataSource dataSource, TimestampAdjusterProvider timestampAdjusterProvider) {
        this.baseUri = baseUri;
        this.variants = variants;
        this.dataSource = dataSource;
        this.timestampAdjusterProvider = timestampAdjusterProvider;
        this.playlistParser = new HlsPlaylistParser();
        this.variantPlaylists = new HlsMediaPlaylist[variants.length];
        this.variantLastPlaylistLoadTimesMs = new long[variants.length];
        Format[] variantFormats = new Format[variants.length];
        int[] initialTrackSelection = new int[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variantFormats[i] = variants[i].format;
            initialTrackSelection[i] = i;
        }
        this.trackGroup = new TrackGroup(variantFormats);
        this.trackSelection = new InitializationTrackSelection(this.trackGroup, initialTrackSelection);
    }

    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
    }

    public boolean isLive() {
        return this.live;
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public TrackGroup getTrackGroup() {
        return this.trackGroup;
    }

    public void selectTracks(TrackSelection trackSelection) {
        this.trackSelection = trackSelection;
    }

    public void reset() {
        this.fatalError = null;
    }

    public void getNextChunk(HlsMediaChunk previous, long playbackPositionUs, HlsChunkHolder out) {
        Extractor extractor;
        int chunkMediaSequence;
        int oldVariantIndex = previous == null ? -1 : this.trackGroup.indexOf(previous.trackFormat);
        long bufferedDurationUs = previous == null ? 0L : Math.max(0L, previous.getAdjustedStartTimeUs() - playbackPositionUs);
        this.trackSelection.updateSelectedTrack(bufferedDurationUs);
        int newVariantIndex = this.trackSelection.getSelectedIndexInTrackGroup();
        boolean switchingVariant = oldVariantIndex != newVariantIndex;
        HlsMediaPlaylist mediaPlaylist = this.variantPlaylists[newVariantIndex];
        if (mediaPlaylist == null) {
            out.chunk = this.newMediaPlaylistChunk(newVariantIndex, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData());
            return;
        }
        if (this.live) {
            if (previous == null) {
                chunkMediaSequence = Math.max(0, mediaPlaylist.segments.size() - 3) + mediaPlaylist.mediaSequence;
            } else {
                chunkMediaSequence = this.getLiveNextChunkSequenceNumber(previous.chunkIndex, oldVariantIndex, newVariantIndex);
                if (chunkMediaSequence < mediaPlaylist.mediaSequence) {
                    newVariantIndex = oldVariantIndex;
                    mediaPlaylist = this.variantPlaylists[newVariantIndex];
                    chunkMediaSequence = this.getLiveNextChunkSequenceNumber(previous.chunkIndex, oldVariantIndex, newVariantIndex);
                    if (chunkMediaSequence < mediaPlaylist.mediaSequence) {
                        this.fatalError = new BehindLiveWindowException();
                        return;
                    }
                }
            }
        } else {
            chunkMediaSequence = previous == null ? Util.binarySearchFloor(mediaPlaylist.segments, Long.valueOf(playbackPositionUs), true, true) + mediaPlaylist.mediaSequence : (switchingVariant ? Util.binarySearchFloor(mediaPlaylist.segments, Long.valueOf(previous.startTimeUs), true, true) + mediaPlaylist.mediaSequence : previous.getNextChunkIndex());
        }
        int chunkIndex = chunkMediaSequence - mediaPlaylist.mediaSequence;
        if (chunkIndex >= mediaPlaylist.segments.size()) {
            if (!mediaPlaylist.live) {
                out.endOfStream = true;
            } else {
                long msToRerequestLiveMediaPlaylist = this.msToRerequestLiveMediaPlaylist(newVariantIndex);
                if (msToRerequestLiveMediaPlaylist <= 0L) {
                    out.chunk = this.newMediaPlaylistChunk(newVariantIndex, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData());
                } else {
                    out.retryInMs = msToRerequestLiveMediaPlaylist + 10L;
                }
            }
            return;
        }
        HlsMediaPlaylist.Segment segment = mediaPlaylist.segments.get(chunkIndex);
        if (segment.isEncrypted) {
            Uri keyUri = UriUtil.resolveToUri(mediaPlaylist.baseUri, segment.encryptionKeyUri);
            if (!keyUri.equals((Object)this.encryptionKeyUri)) {
                out.chunk = this.newEncryptionKeyChunk(keyUri, segment.encryptionIV, newVariantIndex, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData());
                return;
            }
            if (!Util.areEqual(segment.encryptionIV, this.encryptionIvString)) {
                this.setEncryptionData(keyUri, segment.encryptionIV, this.encryptionKey);
            }
        } else {
            this.clearEncryptionData();
        }
        long startTimeUs = this.live ? (previous == null ? 0L : (switchingVariant ? previous.getAdjustedStartTimeUs() : previous.getAdjustedEndTimeUs())) : segment.startTimeUs;
        long endTimeUs = startTimeUs + (long)(segment.durationSecs * 1000000.0);
        Format format = this.variants[newVariantIndex].format;
        Uri chunkUri = UriUtil.resolveToUri(mediaPlaylist.baseUri, segment.url);
        boolean useInitializedExtractor = this.lastLoadedInitializationChunk != null && this.lastLoadedInitializationChunk.format == format;
        boolean needNewExtractor = previous == null || previous.discontinuitySequenceNumber != segment.discontinuitySequenceNumber || format != previous.trackFormat;
        boolean extractorNeedsInit = true;
        boolean isTimestampMaster = false;
        TimestampAdjuster timestampAdjuster = null;
        String lastPathSegment = chunkUri.getLastPathSegment();
        if (lastPathSegment.endsWith(AAC_FILE_EXTENSION)) {
            extractor = new AdtsExtractor(startTimeUs);
        } else if (lastPathSegment.endsWith(AC3_FILE_EXTENSION) || lastPathSegment.endsWith(EC3_FILE_EXTENSION)) {
            extractor = new Ac3Extractor(startTimeUs);
        } else if (lastPathSegment.endsWith(MP3_FILE_EXTENSION)) {
            extractor = new Mp3Extractor(startTimeUs);
        } else if (lastPathSegment.endsWith(WEBVTT_FILE_EXTENSION) || lastPathSegment.endsWith(VTT_FILE_EXTENSION)) {
            timestampAdjuster = this.timestampAdjusterProvider.getAdjuster(segment.discontinuitySequenceNumber, startTimeUs);
            extractor = new WebvttExtractor(format.language, timestampAdjuster);
        } else if (lastPathSegment.endsWith(MP4_FILE_EXTENSION)) {
            isTimestampMaster = true;
            if (needNewExtractor) {
                if (useInitializedExtractor) {
                    extractor = this.lastLoadedInitializationChunk.extractor;
                } else {
                    timestampAdjuster = this.timestampAdjusterProvider.getAdjuster(segment.discontinuitySequenceNumber, startTimeUs);
                    extractor = new FragmentedMp4Extractor(0, timestampAdjuster);
                }
            } else {
                extractor = previous.extractor;
            }
        } else if (needNewExtractor) {
            isTimestampMaster = true;
            if (useInitializedExtractor) {
                extractor = this.lastLoadedInitializationChunk.extractor;
            } else {
                timestampAdjuster = this.timestampAdjusterProvider.getAdjuster(segment.discontinuitySequenceNumber, startTimeUs);
                int esReaderFactoryFlags = 0;
                String codecs = this.variants[newVariantIndex].format.codecs;
                if (!TextUtils.isEmpty((CharSequence)codecs)) {
                    if (!"audio/mp4a-latm".equals(MimeTypes.getAudioMediaMimeType(codecs))) {
                        esReaderFactoryFlags |= 2;
                    }
                    if (!"video/avc".equals(MimeTypes.getVideoMediaMimeType(codecs))) {
                        esReaderFactoryFlags |= 4;
                    }
                }
                extractor = new TsExtractor(timestampAdjuster, new DefaultStreamReaderFactory(esReaderFactoryFlags), true);
            }
        } else {
            extractor = previous.extractor;
            extractorNeedsInit = false;
        }
        if (needNewExtractor && mediaPlaylist.initializationSegment != null && !useInitializedExtractor) {
            out.chunk = this.buildInitializationChunk(mediaPlaylist, extractor, format);
            return;
        }
        this.lastLoadedInitializationChunk = null;
        DataSpec dataSpec = new DataSpec(chunkUri, segment.byterangeOffset, segment.byterangeLength, null);
        out.chunk = new HlsMediaChunk(this.dataSource, dataSpec, format, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), startTimeUs, endTimeUs, chunkMediaSequence, segment.discontinuitySequenceNumber, isTimestampMaster, timestampAdjuster, extractor, extractorNeedsInit, switchingVariant, this.encryptionKey, this.encryptionIv);
    }

    private int getLiveNextChunkSequenceNumber(int previousChunkIndex, int oldVariantIndex, int newVariantIndex) {
        if (oldVariantIndex == newVariantIndex) {
            return previousChunkIndex + 1;
        }
        HlsMediaPlaylist oldMediaPlaylist = this.variantPlaylists[oldVariantIndex];
        HlsMediaPlaylist newMediaPlaylist = this.variantPlaylists[newVariantIndex];
        double offsetToLiveInstantSecs = 0.0;
        for (int i = previousChunkIndex - oldMediaPlaylist.mediaSequence; i < oldMediaPlaylist.segments.size(); ++i) {
            offsetToLiveInstantSecs += oldMediaPlaylist.segments.get((int)i).durationSecs;
        }
        long currentTimeMs = SystemClock.elapsedRealtime();
        offsetToLiveInstantSecs += (double)(currentTimeMs - this.variantLastPlaylistLoadTimesMs[oldVariantIndex]) / 1000.0;
        offsetToLiveInstantSecs += 2.0;
        if ((offsetToLiveInstantSecs -= (double)(currentTimeMs - this.variantLastPlaylistLoadTimesMs[newVariantIndex]) / 1000.0) < 0.0) {
            return newMediaPlaylist.mediaSequence + newMediaPlaylist.segments.size() + 1;
        }
        for (int i = newMediaPlaylist.segments.size() - 1; i >= 0; --i) {
            if (!((offsetToLiveInstantSecs -= newMediaPlaylist.segments.get((int)i).durationSecs) < 0.0)) continue;
            return newMediaPlaylist.mediaSequence + i;
        }
        return newMediaPlaylist.mediaSequence - 1;
    }

    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof HlsInitializationChunk) {
            this.lastLoadedInitializationChunk = (HlsInitializationChunk)chunk;
        } else if (chunk instanceof MediaPlaylistChunk) {
            MediaPlaylistChunk mediaPlaylistChunk = (MediaPlaylistChunk)chunk;
            this.scratchSpace = mediaPlaylistChunk.getDataHolder();
            this.setMediaPlaylist(mediaPlaylistChunk.variantIndex, mediaPlaylistChunk.getResult());
        } else if (chunk instanceof EncryptionKeyChunk) {
            EncryptionKeyChunk encryptionKeyChunk = (EncryptionKeyChunk)chunk;
            this.scratchSpace = encryptionKeyChunk.getDataHolder();
            this.setEncryptionData(encryptionKeyChunk.dataSpec.uri, encryptionKeyChunk.iv, encryptionKeyChunk.getResult());
        }
    }

    public boolean onChunkLoadError(Chunk chunk, boolean cancelable, IOException e) {
        return cancelable && ChunkedTrackBlacklistUtil.maybeBlacklistTrack(this.trackSelection, this.trackSelection.indexOf(this.trackGroup.indexOf(chunk.trackFormat)), e);
    }

    private HlsInitializationChunk buildInitializationChunk(HlsMediaPlaylist mediaPlaylist, Extractor extractor, Format format) {
        HlsMediaPlaylist.Segment initSegment = mediaPlaylist.initializationSegment;
        Uri initSegmentUri = UriUtil.resolveToUri(mediaPlaylist.baseUri, initSegment.url);
        DataSpec initDataSpec = new DataSpec(initSegmentUri, initSegment.byterangeOffset, initSegment.byterangeLength, null);
        return new HlsInitializationChunk(this.dataSource, initDataSpec, this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), extractor, format);
    }

    private long msToRerequestLiveMediaPlaylist(int variantIndex) {
        HlsMediaPlaylist mediaPlaylist = this.variantPlaylists[variantIndex];
        long timeSinceLastMediaPlaylistLoadMs = SystemClock.elapsedRealtime() - this.variantLastPlaylistLoadTimesMs[variantIndex];
        return (long)(mediaPlaylist.targetDurationSecs * 1000 / 2) - timeSinceLastMediaPlaylistLoadMs;
    }

    private MediaPlaylistChunk newMediaPlaylistChunk(int variantIndex, int trackSelectionReason, Object trackSelectionData) {
        Uri mediaPlaylistUri = UriUtil.resolveToUri(this.baseUri, this.variants[variantIndex].url);
        DataSpec dataSpec = new DataSpec(mediaPlaylistUri, 0L, -1L, null, 1);
        return new MediaPlaylistChunk(this.dataSource, dataSpec, this.variants[variantIndex].format, trackSelectionReason, trackSelectionData, this.scratchSpace, this.playlistParser, variantIndex, mediaPlaylistUri);
    }

    private EncryptionKeyChunk newEncryptionKeyChunk(Uri keyUri, String iv, int variantIndex, int trackSelectionReason, Object trackSelectionData) {
        DataSpec dataSpec = new DataSpec(keyUri, 0L, -1L, null, 1);
        return new EncryptionKeyChunk(this.dataSource, dataSpec, this.variants[variantIndex].format, trackSelectionReason, trackSelectionData, this.scratchSpace, iv);
    }

    private void setEncryptionData(Uri keyUri, String iv, byte[] secretKey) {
        String trimmedIv = iv.toLowerCase(Locale.getDefault()).startsWith("0x") ? iv.substring(2) : iv;
        byte[] ivData = new BigInteger(trimmedIv, 16).toByteArray();
        byte[] ivDataWithPadding = new byte[16];
        int offset = ivData.length > 16 ? ivData.length - 16 : 0;
        System.arraycopy(ivData, offset, ivDataWithPadding, ivDataWithPadding.length - ivData.length + offset, ivData.length - offset);
        this.encryptionKeyUri = keyUri;
        this.encryptionKey = secretKey;
        this.encryptionIvString = iv;
        this.encryptionIv = ivDataWithPadding;
    }

    private void clearEncryptionData() {
        this.encryptionKeyUri = null;
        this.encryptionKey = null;
        this.encryptionIvString = null;
        this.encryptionIv = null;
    }

    private void setMediaPlaylist(int variantIndex, HlsMediaPlaylist mediaPlaylist) {
        this.variantLastPlaylistLoadTimesMs[variantIndex] = SystemClock.elapsedRealtime();
        this.variantPlaylists[variantIndex] = mediaPlaylist;
        this.live |= mediaPlaylist.live;
        this.durationUs = this.live ? -9223372036854775807L : mediaPlaylist.durationUs;
    }

    private static final class EncryptionKeyChunk
    extends DataChunk {
        public final String iv;
        private byte[] result;

        public EncryptionKeyChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, Object trackSelectionData, byte[] scratchSpace, String iv) {
            super(dataSource, dataSpec, 3, trackFormat, trackSelectionReason, trackSelectionData, scratchSpace);
            this.iv = iv;
        }

        @Override
        protected void consume(byte[] data, int limit) throws IOException {
            this.result = Arrays.copyOf(data, limit);
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    private static final class MediaPlaylistChunk
    extends DataChunk {
        public final int variantIndex;
        private final HlsPlaylistParser playlistParser;
        private final Uri playlistUri;
        private HlsMediaPlaylist result;

        public MediaPlaylistChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, Object trackSelectionData, byte[] scratchSpace, HlsPlaylistParser playlistParser, int variantIndex, Uri playlistUri) {
            super(dataSource, dataSpec, 4, trackFormat, trackSelectionReason, trackSelectionData, scratchSpace);
            this.variantIndex = variantIndex;
            this.playlistParser = playlistParser;
            this.playlistUri = playlistUri;
        }

        @Override
        protected void consume(byte[] data, int limit) throws IOException {
            this.result = (HlsMediaPlaylist)this.playlistParser.parse(this.playlistUri, new ByteArrayInputStream(data, 0, limit));
        }

        public HlsMediaPlaylist getResult() {
            return this.result;
        }
    }

    private static final class InitializationTrackSelection
    extends BaseTrackSelection {
        private int selectedIndex;

        public InitializationTrackSelection(TrackGroup group, int[] tracks) {
            super(group, tracks);
            this.selectedIndex = this.indexOf(group.getFormat(0));
        }

        @Override
        public void updateSelectedTrack(long bufferedDurationUs) {
            long nowMs = SystemClock.elapsedRealtime();
            if (!this.isBlacklisted(this.selectedIndex, nowMs)) {
                return;
            }
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.isBlacklisted(i, nowMs)) continue;
                this.selectedIndex = i;
                return;
            }
            throw new IllegalStateException();
        }

        @Override
        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        @Override
        public int getSelectionReason() {
            return 0;
        }

        @Override
        public Object getSelectionData() {
            return null;
        }
    }

    public static final class HlsChunkHolder {
        public Chunk chunk;
        public boolean endOfStream;
        public long retryInMs;

        public HlsChunkHolder() {
            this.clear();
        }

        public void clear() {
            this.chunk = null;
            this.endOfStream = false;
            this.retryInMs = -9223372036854775807L;
        }
    }
}

