/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.google.android.exoplayer2.util.Util;
import java.util.List;

public abstract class SegmentBase {
    final RangedUri initialization;
    final long timescale;
    final long presentationTimeOffset;

    public SegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset) {
        this.initialization = initialization;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
    }

    public RangedUri getInitialization(Representation representation) {
        return this.initialization;
    }

    public long getPresentationTimeOffsetUs() {
        return Util.scaleLargeTimestamp(this.presentationTimeOffset, 1000000L, this.timescale);
    }

    public static class SegmentTimelineElement {
        final long startTime;
        final long duration;

        public SegmentTimelineElement(long startTime, long duration) {
            this.startTime = startTime;
            this.duration = duration;
        }
    }

    public static class SegmentTemplate
    extends MultiSegmentBase {
        final UrlTemplate initializationTemplate;
        final UrlTemplate mediaTemplate;
        private final String baseUrl;

        public SegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentTimelineElement> segmentTimeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate, String baseUrl) {
            super(initialization, timescale, presentationTimeOffset, startNumber, duration, segmentTimeline);
            this.initializationTemplate = initializationTemplate;
            this.mediaTemplate = mediaTemplate;
            this.baseUrl = baseUrl;
        }

        @Override
        public RangedUri getInitialization(Representation representation) {
            if (this.initializationTemplate != null) {
                String urlString = this.initializationTemplate.buildUri(representation.format.id, 0, representation.format.bitrate, 0L);
                return new RangedUri(this.baseUrl, urlString, 0L, -1L);
            }
            return super.getInitialization(representation);
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, int sequenceNumber) {
            long time = this.segmentTimeline != null ? ((SegmentTimelineElement)this.segmentTimeline.get((int)(sequenceNumber - this.startNumber))).startTime : (long)(sequenceNumber - this.startNumber) * this.duration;
            String uriString = this.mediaTemplate.buildUri(representation.format.id, sequenceNumber, representation.format.bitrate, time);
            return new RangedUri(this.baseUrl, uriString, 0L, -1L);
        }

        @Override
        public int getLastSegmentNum(long periodDurationUs) {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.size() + this.startNumber - 1;
            }
            if (periodDurationUs == -9223372036854775807L) {
                return -1;
            }
            long durationUs = this.duration * 1000000L / this.timescale;
            return this.startNumber + (int)Util.ceilDivide(periodDurationUs, durationUs) - 1;
        }
    }

    public static class SegmentList
    extends MultiSegmentBase {
        final List<RangedUri> mediaSegments;

        public SegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentTimelineElement> segmentTimeline, List<RangedUri> mediaSegments) {
            super(initialization, timescale, presentationTimeOffset, startNumber, duration, segmentTimeline);
            this.mediaSegments = mediaSegments;
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, int sequenceNumber) {
            return this.mediaSegments.get(sequenceNumber - this.startNumber);
        }

        @Override
        public int getLastSegmentNum(long periodDurationUs) {
            return this.startNumber + this.mediaSegments.size() - 1;
        }

        @Override
        public boolean isExplicit() {
            return true;
        }
    }

    public static abstract class MultiSegmentBase
    extends SegmentBase {
        final int startNumber;
        final long duration;
        final List<SegmentTimelineElement> segmentTimeline;

        public MultiSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentTimelineElement> segmentTimeline) {
            super(initialization, timescale, presentationTimeOffset);
            this.startNumber = startNumber;
            this.duration = duration;
            this.segmentTimeline = segmentTimeline;
        }

        public int getSegmentNum(long timeUs, long periodDurationUs) {
            int firstSegmentNum;
            int lowIndex = firstSegmentNum = this.getFirstSegmentNum();
            int highIndex = this.getLastSegmentNum(periodDurationUs);
            if (this.segmentTimeline == null) {
                long durationUs = this.duration * 1000000L / this.timescale;
                int segmentNum = this.startNumber + (int)(timeUs / durationUs);
                return segmentNum < lowIndex ? lowIndex : (highIndex != -1 && segmentNum > highIndex ? highIndex : segmentNum);
            }
            while (lowIndex <= highIndex) {
                int midIndex = (lowIndex + highIndex) / 2;
                long midTimeUs = this.getSegmentTimeUs(midIndex);
                if (midTimeUs < timeUs) {
                    lowIndex = midIndex + 1;
                    continue;
                }
                if (midTimeUs > timeUs) {
                    highIndex = midIndex - 1;
                    continue;
                }
                return midIndex;
            }
            return lowIndex == firstSegmentNum ? lowIndex : highIndex;
        }

        public final long getSegmentDurationUs(int sequenceNumber, long periodDurationUs) {
            if (this.segmentTimeline != null) {
                long duration = this.segmentTimeline.get((int)(sequenceNumber - this.startNumber)).duration;
                return duration * 1000000L / this.timescale;
            }
            return sequenceNumber == this.getLastSegmentNum(periodDurationUs) ? periodDurationUs - this.getSegmentTimeUs(sequenceNumber) : this.duration * 1000000L / this.timescale;
        }

        public final long getSegmentTimeUs(int sequenceNumber) {
            long unscaledSegmentTime = this.segmentTimeline != null ? this.segmentTimeline.get((int)(sequenceNumber - this.startNumber)).startTime - this.presentationTimeOffset : (long)(sequenceNumber - this.startNumber) * this.duration;
            return Util.scaleLargeTimestamp(unscaledSegmentTime, 1000000L, this.timescale);
        }

        public abstract RangedUri getSegmentUrl(Representation var1, int var2);

        public int getFirstSegmentNum() {
            return this.startNumber;
        }

        public abstract int getLastSegmentNum(long var1);

        public boolean isExplicit() {
            return this.segmentTimeline != null;
        }
    }

    public static class SingleSegmentBase
    extends SegmentBase {
        public final String uri;
        final long indexStart;
        final long indexLength;

        public SingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, String uri, long indexStart, long indexLength) {
            super(initialization, timescale, presentationTimeOffset);
            this.uri = uri;
            this.indexStart = indexStart;
            this.indexLength = indexLength;
        }

        public SingleSegmentBase(String uri) {
            this(null, 1L, 0L, uri, 0L, 0L);
        }

        public RangedUri getIndex() {
            return this.indexLength <= 0L ? null : new RangedUri(this.uri, null, this.indexStart, this.indexLength);
        }
    }
}

