/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.SegmentBase;
import com.google.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.UriUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.XmlPullParserUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DashManifestParser
extends DefaultHandler
implements ParsingLoadable.Parser<DashManifest> {
    private static final String TAG = "MpdParser";
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("(\\d+)(?:/(\\d+))?");
    private final String contentId;
    private final XmlPullParserFactory xmlParserFactory;

    public DashManifestParser() {
        this(null);
    }

    public DashManifestParser(String contentId) {
        this.contentId = contentId;
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    @Override
    public DashManifest parse(Uri uri, InputStream inputStream) throws IOException {
        try {
            XmlPullParser xpp = this.xmlParserFactory.newPullParser();
            xpp.setInput(inputStream, null);
            int eventType = xpp.next();
            if (eventType != 2 || !"MPD".equals(xpp.getName())) {
                throw new ParserException("inputStream does not contain a valid media presentation description");
            }
            return this.parseMediaPresentationDescription(xpp, uri.toString());
        }
        catch (ParseException | XmlPullParserException e) {
            throw new ParserException(e);
        }
    }

    protected DashManifest parseMediaPresentationDescription(XmlPullParser xpp, String baseUrl) throws XmlPullParserException, IOException, ParseException {
        long availabilityStartTime = DashManifestParser.parseDateTime(xpp, "availabilityStartTime", -9223372036854775807L);
        long durationMs = DashManifestParser.parseDuration(xpp, "mediaPresentationDuration", -9223372036854775807L);
        long minBufferTimeMs = DashManifestParser.parseDuration(xpp, "minBufferTime", -9223372036854775807L);
        String typeString = xpp.getAttributeValue(null, "type");
        boolean dynamic = typeString != null && typeString.equals("dynamic");
        long minUpdateTimeMs = dynamic ? DashManifestParser.parseDuration(xpp, "minimumUpdatePeriod", -9223372036854775807L) : -9223372036854775807L;
        long timeShiftBufferDepthMs = dynamic ? DashManifestParser.parseDuration(xpp, "timeShiftBufferDepth", -9223372036854775807L) : -9223372036854775807L;
        long suggestedPresentationDelayMs = dynamic ? DashManifestParser.parseDuration(xpp, "suggestedPresentationDelay", -9223372036854775807L) : -9223372036854775807L;
        UtcTimingElement utcTiming = null;
        Uri location = null;
        ArrayList<Period> periods = new ArrayList<Period>();
        long nextPeriodStartMs = dynamic ? -9223372036854775807L : 0L;
        boolean seenEarlyAccessPeriod = false;
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "UTCTiming")) {
                utcTiming = this.parseUtcTiming(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "Location")) {
                location = Uri.parse((String)xpp.nextText());
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp, "Period") || seenEarlyAccessPeriod) continue;
            Pair<Period, Long> periodWithDurationMs = this.parsePeriod(xpp, baseUrl, nextPeriodStartMs);
            Period period = (Period)periodWithDurationMs.first;
            if (period.startMs == -9223372036854775807L) {
                if (dynamic) {
                    seenEarlyAccessPeriod = true;
                    continue;
                }
                throw new ParserException("Unable to determine start of period " + periods.size());
            }
            long periodDurationMs = (Long)periodWithDurationMs.second;
            nextPeriodStartMs = periodDurationMs == -9223372036854775807L ? -9223372036854775807L : period.startMs + periodDurationMs;
            periods.add(period);
        } while (!XmlPullParserUtil.isEndTag(xpp, "MPD"));
        if (durationMs == -9223372036854775807L) {
            if (nextPeriodStartMs != -9223372036854775807L) {
                durationMs = nextPeriodStartMs;
            } else if (!dynamic) {
                throw new ParserException("Unable to determine duration of static manifest.");
            }
        }
        if (periods.isEmpty()) {
            throw new ParserException("No periods found.");
        }
        return this.buildMediaPresentationDescription(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, utcTiming, location, periods);
    }

    protected DashManifest buildMediaPresentationDescription(long availabilityStartTime, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdateTimeMs, long timeShiftBufferDepthMs, long suggestedPresentationDelayMs, UtcTimingElement utcTiming, Uri location, List<Period> periods) {
        return new DashManifest(availabilityStartTime, durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, utcTiming, location, periods);
    }

    protected UtcTimingElement parseUtcTiming(XmlPullParser xpp) {
        String schemeIdUri = xpp.getAttributeValue(null, "schemeIdUri");
        String value = xpp.getAttributeValue(null, "value");
        return this.buildUtcTimingElement(schemeIdUri, value);
    }

    protected UtcTimingElement buildUtcTimingElement(String schemeIdUri, String value) {
        return new UtcTimingElement(schemeIdUri, value);
    }

    protected Pair<Period, Long> parsePeriod(XmlPullParser xpp, String baseUrl, long defaultStartMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        long startMs = DashManifestParser.parseDuration(xpp, "start", defaultStartMs);
        long durationMs = DashManifestParser.parseDuration(xpp, "duration", -9223372036854775807L);
        SegmentBase segmentBase = null;
        ArrayList<AdaptationSet> adaptationSets = new ArrayList<AdaptationSet>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "AdaptationSet")) {
                adaptationSets.add(this.parseAdaptationSet(xpp, baseUrl, segmentBase));
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, null);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, null);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, null);
        } while (!XmlPullParserUtil.isEndTag(xpp, "Period"));
        return Pair.create((Object)this.buildPeriod(id, startMs, adaptationSets), (Object)durationMs);
    }

    protected Period buildPeriod(String id, long startMs, List<AdaptationSet> adaptationSets) {
        return new Period(id, startMs, adaptationSets);
    }

    protected AdaptationSet parseAdaptationSet(XmlPullParser xpp, String baseUrl, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        int id = DashManifestParser.parseInt(xpp, "id", -1);
        int contentType = this.parseContentType(xpp);
        String mimeType = xpp.getAttributeValue(null, "mimeType");
        String codecs = xpp.getAttributeValue(null, "codecs");
        int width = DashManifestParser.parseInt(xpp, "width", -1);
        int height = DashManifestParser.parseInt(xpp, "height", -1);
        float frameRate = DashManifestParser.parseFrameRate(xpp, -1.0f);
        int audioChannels = -1;
        int audioSamplingRate = DashManifestParser.parseInt(xpp, "audioSamplingRate", -1);
        String language = xpp.getAttributeValue(null, "lang");
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = new ArrayList<DrmInitData.SchemeData>();
        ArrayList<RepresentationInfo> representationInfos = new ArrayList<RepresentationInfo>();
        boolean seenFirstBaseUrl = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "ContentProtection")) {
                DrmInitData.SchemeData contentProtection = this.parseContentProtection(xpp);
                if (contentProtection == null) continue;
                drmSchemeDatas.add(contentProtection);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "ContentComponent")) {
                language = DashManifestParser.checkLanguageConsistency(language, xpp.getAttributeValue(null, "lang"));
                contentType = DashManifestParser.checkContentTypeConsistency(contentType, this.parseContentType(xpp));
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "Representation")) {
                RepresentationInfo representationInfo = this.parseRepresentation(xpp, baseUrl, mimeType, codecs, width, height, frameRate, audioChannels, audioSamplingRate, language, segmentBase);
                contentType = DashManifestParser.checkContentTypeConsistency(contentType, this.getContentType(representationInfo.format));
                representationInfos.add(representationInfo);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp)) continue;
            this.parseAdaptationSetChild(xpp);
        } while (!XmlPullParserUtil.isEndTag(xpp, "AdaptationSet"));
        ArrayList<Representation> representations = new ArrayList<Representation>(representationInfos.size());
        for (int i = 0; i < representationInfos.size(); ++i) {
            representations.add(this.buildRepresentation((RepresentationInfo)representationInfos.get(i), this.contentId, drmSchemeDatas));
        }
        return this.buildAdaptationSet(id, contentType, representations);
    }

    protected AdaptationSet buildAdaptationSet(int id, int contentType, List<Representation> representations) {
        return new AdaptationSet(id, contentType, representations);
    }

    protected int parseContentType(XmlPullParser xpp) {
        String contentType = xpp.getAttributeValue(null, "contentType");
        return TextUtils.isEmpty((CharSequence)contentType) ? -1 : ("audio".equals(contentType) ? 1 : ("video".equals(contentType) ? 2 : ("text".equals(contentType) ? 3 : -1)));
    }

    protected int getContentType(Format format) {
        String sampleMimeType = format.sampleMimeType;
        if (TextUtils.isEmpty((CharSequence)sampleMimeType)) {
            return -1;
        }
        if (MimeTypes.isVideo(sampleMimeType)) {
            return 2;
        }
        if (MimeTypes.isAudio(sampleMimeType)) {
            return 1;
        }
        if (DashManifestParser.mimeTypeIsRawText(sampleMimeType) || "application/x-rawcc".equals(format.containerMimeType)) {
            return 3;
        }
        return -1;
    }

    protected DrmInitData.SchemeData parseContentProtection(XmlPullParser xpp) throws XmlPullParserException, IOException {
        byte[] data = null;
        UUID uuid = null;
        boolean seenPsshElement = false;
        boolean requiresSecureDecoder = false;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "cenc:pssh") && xpp.next() == 4) {
                seenPsshElement = true;
                data = Base64.decode((String)xpp.getText(), (int)0);
                uuid = PsshAtomUtil.parseUuid(data);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp, "widevine:license")) continue;
            String robustnessLevel = xpp.getAttributeValue(null, "robustness_level");
            boolean bl = requiresSecureDecoder = robustnessLevel != null && robustnessLevel.startsWith("HW");
        } while (!XmlPullParserUtil.isEndTag(xpp, "ContentProtection"));
        if (!seenPsshElement) {
            return null;
        }
        if (uuid != null) {
            return new DrmInitData.SchemeData(uuid, "video/mp4", data, requiresSecureDecoder);
        }
        Log.w((String)TAG, (String)"Skipped unsupported ContentProtection element");
        return null;
    }

    protected void parseAdaptationSetChild(XmlPullParser xpp) throws XmlPullParserException, IOException {
    }

    protected RepresentationInfo parseRepresentation(XmlPullParser xpp, String baseUrl, String adaptationSetMimeType, String adaptationSetCodecs, int adaptationSetWidth, int adaptationSetHeight, float adaptationSetFrameRate, int adaptationSetAudioChannels, int adaptationSetAudioSamplingRate, String adaptationSetLanguage, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        int bandwidth = DashManifestParser.parseInt(xpp, "bandwidth", -1);
        String mimeType = DashManifestParser.parseString(xpp, "mimeType", adaptationSetMimeType);
        String codecs = DashManifestParser.parseString(xpp, "codecs", adaptationSetCodecs);
        int width = DashManifestParser.parseInt(xpp, "width", adaptationSetWidth);
        int height = DashManifestParser.parseInt(xpp, "height", adaptationSetHeight);
        float frameRate = DashManifestParser.parseFrameRate(xpp, adaptationSetFrameRate);
        int audioChannels = adaptationSetAudioChannels;
        int audioSamplingRate = DashManifestParser.parseInt(xpp, "audioSamplingRate", adaptationSetAudioSamplingRate);
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = new ArrayList<DrmInitData.SchemeData>();
        boolean seenFirstBaseUrl = false;
        do {
            DrmInitData.SchemeData contentProtection;
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "BaseURL")) {
                if (seenFirstBaseUrl) continue;
                baseUrl = DashManifestParser.parseBaseUrl(xpp, baseUrl);
                seenFirstBaseUrl = true;
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "AudioChannelConfiguration")) {
                audioChannels = this.parseAudioChannelConfiguration(xpp);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentTemplate")) {
                segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp, "ContentProtection") || (contentProtection = this.parseContentProtection(xpp)) == null) continue;
            drmSchemeDatas.add(contentProtection);
        } while (!XmlPullParserUtil.isEndTag(xpp, "Representation"));
        Format format = this.buildFormat(id, mimeType, width, height, frameRate, audioChannels, audioSamplingRate, bandwidth, adaptationSetLanguage, codecs);
        segmentBase = segmentBase != null ? segmentBase : new SegmentBase.SingleSegmentBase(baseUrl);
        return new RepresentationInfo(format, segmentBase, drmSchemeDatas);
    }

    protected Format buildFormat(String id, String containerMimeType, int width, int height, float frameRate, int audioChannels, int audioSamplingRate, int bitrate, String language, String codecs) {
        String sampleMimeType = DashManifestParser.getSampleMimeType(containerMimeType, codecs);
        if (sampleMimeType != null) {
            if (MimeTypes.isVideo(sampleMimeType)) {
                return Format.createVideoContainerFormat(id, containerMimeType, sampleMimeType, codecs, bitrate, width, height, frameRate, null);
            }
            if (MimeTypes.isAudio(sampleMimeType)) {
                return Format.createAudioContainerFormat(id, containerMimeType, sampleMimeType, codecs, bitrate, audioChannels, audioSamplingRate, null, 0, language);
            }
            if (DashManifestParser.mimeTypeIsRawText(sampleMimeType)) {
                return Format.createTextContainerFormat(id, containerMimeType, sampleMimeType, codecs, bitrate, 0, language);
            }
            return Format.createContainerFormat(id, containerMimeType, codecs, sampleMimeType, bitrate);
        }
        return Format.createContainerFormat(id, containerMimeType, codecs, sampleMimeType, bitrate);
    }

    protected Representation buildRepresentation(RepresentationInfo representationInfo, String contentId, ArrayList<DrmInitData.SchemeData> extraDrmSchemeDatas) {
        Format format = representationInfo.format;
        ArrayList<DrmInitData.SchemeData> drmSchemeDatas = representationInfo.drmSchemeDatas;
        drmSchemeDatas.addAll(extraDrmSchemeDatas);
        if (!drmSchemeDatas.isEmpty()) {
            format = format.copyWithDrmInitData(new DrmInitData(drmSchemeDatas));
        }
        return Representation.newInstance(contentId, -1L, format, representationInfo.segmentBase);
    }

    protected SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xpp, String baseUrl, SegmentBase.SingleSegmentBase parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long indexStart = parent != null ? parent.indexStart : 0L;
        long indexLength = parent != null ? parent.indexLength : 0L;
        String indexRangeText = xpp.getAttributeValue(null, "indexRange");
        if (indexRangeText != null) {
            String[] indexRange = indexRangeText.split("-");
            indexStart = Long.parseLong(indexRange[0]);
            indexLength = Long.parseLong(indexRange[1]) - indexStart + 1L;
        }
        RangedUri initialization = parent != null ? parent.initialization : null;
        do {
            xpp.next();
            if (!XmlPullParserUtil.isStartTag(xpp, "Initialization")) continue;
            initialization = this.parseInitialization(xpp, baseUrl);
        } while (!XmlPullParserUtil.isEndTag(xpp, "SegmentBase"));
        return this.buildSingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    protected SegmentBase.SingleSegmentBase buildSingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, String baseUrl, long indexStart, long indexLength) {
        return new SegmentBase.SingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    protected SegmentBase.SegmentList parseSegmentList(XmlPullParser xpp, String baseUrl, SegmentBase.SegmentList parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", parent != null ? parent.duration : -9223372036854775807L);
        int startNumber = DashManifestParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 1);
        RangedUri initialization = null;
        List timeline = null;
        ArrayList<RangedUri> segments = null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (XmlPullParserUtil.isStartTag(xpp, "SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp, "SegmentURL")) continue;
            if (segments == null) {
                segments = new ArrayList<RangedUri>();
            }
            segments.add(this.parseSegmentUrl(xpp, baseUrl));
        } while (!XmlPullParserUtil.isEndTag(xpp, "SegmentList"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
            segments = segments != null ? segments : parent.mediaSegments;
        }
        return this.buildSegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentList buildSegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, List<RangedUri> segments) {
        return new SegmentBase.SegmentList(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, segments);
    }

    protected SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xpp, String baseUrl, SegmentBase.SegmentTemplate parent) throws XmlPullParserException, IOException {
        long timescale = DashManifestParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = DashManifestParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = DashManifestParser.parseLong(xpp, "duration", parent != null ? parent.duration : -9223372036854775807L);
        int startNumber = DashManifestParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 1);
        UrlTemplate mediaTemplate = this.parseUrlTemplate(xpp, "media", parent != null ? parent.mediaTemplate : null);
        UrlTemplate initializationTemplate = this.parseUrlTemplate(xpp, "initialization", parent != null ? parent.initializationTemplate : null);
        RangedUri initialization = null;
        List timeline = null;
        do {
            xpp.next();
            if (XmlPullParserUtil.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (!XmlPullParserUtil.isStartTag(xpp, "SegmentTimeline")) continue;
            timeline = this.parseSegmentTimeline(xpp);
        } while (!XmlPullParserUtil.isEndTag(xpp, "SegmentTemplate"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
        }
        return this.buildSegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    protected SegmentBase.SegmentTemplate buildSegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, int startNumber, long duration, List<SegmentBase.SegmentTimelineElement> timeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate, String baseUrl) {
        return new SegmentBase.SegmentTemplate(initialization, timescale, presentationTimeOffset, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    protected List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xpp) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> segmentTimeline = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long elapsedTime = 0L;
        do {
            xpp.next();
            if (!XmlPullParserUtil.isStartTag(xpp, "S")) continue;
            elapsedTime = DashManifestParser.parseLong(xpp, "t", elapsedTime);
            long duration = DashManifestParser.parseLong(xpp, "d", -9223372036854775807L);
            int count = 1 + DashManifestParser.parseInt(xpp, "r", 0);
            for (int i = 0; i < count; ++i) {
                segmentTimeline.add(this.buildSegmentTimelineElement(elapsedTime, duration));
                elapsedTime += duration;
            }
        } while (!XmlPullParserUtil.isEndTag(xpp, "SegmentTimeline"));
        return segmentTimeline;
    }

    protected SegmentBase.SegmentTimelineElement buildSegmentTimelineElement(long elapsedTime, long duration) {
        return new SegmentBase.SegmentTimelineElement(elapsedTime, duration);
    }

    protected UrlTemplate parseUrlTemplate(XmlPullParser xpp, String name, UrlTemplate defaultValue) {
        String valueString = xpp.getAttributeValue(null, name);
        if (valueString != null) {
            return UrlTemplate.compile(valueString);
        }
        return defaultValue;
    }

    protected RangedUri parseInitialization(XmlPullParser xpp, String baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "sourceURL", "range");
    }

    protected RangedUri parseSegmentUrl(XmlPullParser xpp, String baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "media", "mediaRange");
    }

    protected RangedUri parseRangedUrl(XmlPullParser xpp, String baseUrl, String urlAttribute, String rangeAttribute) {
        String urlText = xpp.getAttributeValue(null, urlAttribute);
        long rangeStart = 0L;
        long rangeLength = -1L;
        String rangeText = xpp.getAttributeValue(null, rangeAttribute);
        if (rangeText != null) {
            String[] rangeTextArray = rangeText.split("-");
            rangeStart = Long.parseLong(rangeTextArray[0]);
            if (rangeTextArray.length == 2) {
                rangeLength = Long.parseLong(rangeTextArray[1]) - rangeStart + 1L;
            }
        }
        return this.buildRangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected RangedUri buildRangedUri(String baseUrl, String urlText, long rangeStart, long rangeLength) {
        return new RangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected int parseAudioChannelConfiguration(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeIdUri = DashManifestParser.parseString(xpp, "schemeIdUri", null);
        int audioChannels = "urn:mpeg:dash:23003:3:audio_channel_configuration:2011".equals(schemeIdUri) ? DashManifestParser.parseInt(xpp, "value", -1) : -1;
        do {
            xpp.next();
        } while (!XmlPullParserUtil.isEndTag(xpp, "AudioChannelConfiguration"));
        return audioChannels;
    }

    private static String getSampleMimeType(String containerMimeType, String codecs) {
        if (MimeTypes.isAudio(containerMimeType)) {
            return MimeTypes.getAudioMediaMimeType(codecs);
        }
        if (MimeTypes.isVideo(containerMimeType)) {
            return MimeTypes.getVideoMediaMimeType(codecs);
        }
        if ("application/x-rawcc".equals(containerMimeType)) {
            if (codecs != null) {
                if (codecs.contains("cea708")) {
                    return "application/cea-708";
                }
                if (codecs.contains("eia608") || codecs.contains("cea608")) {
                    return "application/cea-608";
                }
            }
            return null;
        }
        if (DashManifestParser.mimeTypeIsRawText(containerMimeType)) {
            return containerMimeType;
        }
        if ("application/mp4".equals(containerMimeType)) {
            if ("stpp".equals(codecs)) {
                return "application/ttml+xml";
            }
            if ("wvtt".equals(codecs)) {
                return "application/x-mp4vtt";
            }
        }
        return null;
    }

    private static boolean mimeTypeIsRawText(String mimeType) {
        return MimeTypes.isText(mimeType) || "application/ttml+xml".equals(mimeType);
    }

    private static String checkLanguageConsistency(String firstLanguage, String secondLanguage) {
        if (firstLanguage == null) {
            return secondLanguage;
        }
        if (secondLanguage == null) {
            return firstLanguage;
        }
        Assertions.checkState(firstLanguage.equals(secondLanguage));
        return firstLanguage;
    }

    private static int checkContentTypeConsistency(int firstType, int secondType) {
        if (firstType == -1) {
            return secondType;
        }
        if (secondType == -1) {
            return firstType;
        }
        Assertions.checkState(firstType == secondType);
        return firstType;
    }

    protected static float parseFrameRate(XmlPullParser xpp, float defaultValue) {
        Matcher frameRateMatcher;
        float frameRate = defaultValue;
        String frameRateAttribute = xpp.getAttributeValue(null, "frameRate");
        if (frameRateAttribute != null && (frameRateMatcher = FRAME_RATE_PATTERN.matcher(frameRateAttribute)).matches()) {
            int numerator = Integer.parseInt(frameRateMatcher.group(1));
            String denominatorString = frameRateMatcher.group(2);
            frameRate = !TextUtils.isEmpty((CharSequence)denominatorString) ? (float)numerator / (float)Integer.parseInt(denominatorString) : (float)numerator;
        }
        return frameRate;
    }

    protected static long parseDuration(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDuration(value);
    }

    protected static long parseDateTime(XmlPullParser xpp, String name, long defaultValue) throws ParseException {
        String value = xpp.getAttributeValue(null, name);
        if (value == null) {
            return defaultValue;
        }
        return Util.parseXsDateTime(value);
    }

    protected static String parseBaseUrl(XmlPullParser xpp, String parentBaseUrl) throws XmlPullParserException, IOException {
        xpp.next();
        return UriUtil.resolve(parentBaseUrl, xpp.getText());
    }

    protected static int parseInt(XmlPullParser xpp, String name, int defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected static long parseLong(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected static String parseString(XmlPullParser xpp, String name, String defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : value;
    }

    private static final class RepresentationInfo {
        public final Format format;
        public final SegmentBase segmentBase;
        public final ArrayList<DrmInitData.SchemeData> drmSchemeDatas;

        public RepresentationInfo(Format format, SegmentBase segmentBase, ArrayList<DrmInitData.SchemeData> drmSchemeDatas) {
            this.format = format;
            this.segmentBase = segmentBase;
            this.drmSchemeDatas = drmSchemeDatas;
        }
    }
}

