/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import java.util.Collections;
import java.util.List;

public class DashManifest {
    public final long availabilityStartTime;
    public final long duration;
    public final long minBufferTime;
    public final boolean dynamic;
    public final long minUpdatePeriod;
    public final long timeShiftBufferDepth;
    public final long suggestedPresentationDelay;
    public final UtcTimingElement utcTiming;
    public final Uri location;
    private final List<Period> periods;

    public DashManifest(long availabilityStartTime, long duration, long minBufferTime, boolean dynamic, long minUpdatePeriod, long timeShiftBufferDepth, long suggestedPresentationDelay, UtcTimingElement utcTiming, Uri location, List<Period> periods) {
        this.availabilityStartTime = availabilityStartTime;
        this.duration = duration;
        this.minBufferTime = minBufferTime;
        this.dynamic = dynamic;
        this.minUpdatePeriod = minUpdatePeriod;
        this.timeShiftBufferDepth = timeShiftBufferDepth;
        this.suggestedPresentationDelay = suggestedPresentationDelay;
        this.utcTiming = utcTiming;
        this.location = location;
        this.periods = periods == null ? Collections.emptyList() : periods;
    }

    public final int getPeriodCount() {
        return this.periods.size();
    }

    public final Period getPeriod(int index) {
        return this.periods.get(index);
    }

    public final long getPeriodDurationMs(int index) {
        return index == this.periods.size() - 1 ? (this.duration == -9223372036854775807L ? -9223372036854775807L : this.duration - this.periods.get((int)index).startMs) : this.periods.get((int)(index + 1)).startMs - this.periods.get((int)index).startMs;
    }

    public final long getPeriodDurationUs(int index) {
        return C.msToUs(this.getPeriodDurationMs(index));
    }
}

