/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.os.SystemClock;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.mkv.MatroskaExtractor;
import com.google.android.exoplayer2.extractor.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer2.extractor.rawcc.RawCcExtractor;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer2.source.chunk.ChunkHolder;
import com.google.android.exoplayer2.source.chunk.ChunkedTrackBlacklistUtil;
import com.google.android.exoplayer2.source.chunk.ContainerMediaChunk;
import com.google.android.exoplayer2.source.chunk.InitializationChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.SingleSampleMediaChunk;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.List;

public class DefaultDashChunkSource
implements DashChunkSource {
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final int adaptationSetIndex;
    private final TrackSelection trackSelection;
    private final RepresentationHolder[] representationHolders;
    private final DataSource dataSource;
    private final long elapsedRealtimeOffsetMs;
    private DashManifest manifest;
    private int periodIndex;
    private IOException fatalError;
    private boolean missingLastSegment;

    public DefaultDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, int periodIndex, int adaptationSetIndex, TrackSelection trackSelection, DataSource dataSource, long elapsedRealtimeOffsetMs) {
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.manifest = manifest;
        this.adaptationSetIndex = adaptationSetIndex;
        this.trackSelection = trackSelection;
        this.dataSource = dataSource;
        this.periodIndex = periodIndex;
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        long periodDurationUs = manifest.getPeriodDurationUs(periodIndex);
        List<Representation> representations = this.getRepresentations();
        this.representationHolders = new RepresentationHolder[trackSelection.length()];
        for (int i = 0; i < this.representationHolders.length; ++i) {
            Representation representation = representations.get(trackSelection.getIndexInTrackGroup(i));
            this.representationHolders[i] = new RepresentationHolder(periodDurationUs, representation);
        }
    }

    @Override
    public void updateManifest(DashManifest newManifest, int newPeriodIndex) {
        try {
            this.manifest = newManifest;
            this.periodIndex = newPeriodIndex;
            long periodDurationUs = this.manifest.getPeriodDurationUs(this.periodIndex);
            List<Representation> representations = this.getRepresentations();
            for (int i = 0; i < this.representationHolders.length; ++i) {
                Representation representation = representations.get(this.trackSelection.getIndexInTrackGroup(i));
                this.representationHolders[i].updateRepresentation(periodDurationUs, representation);
            }
        }
        catch (BehindLiveWindowException e) {
            this.fatalError = e;
        }
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    @Override
    public int getPreferredQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        if (this.fatalError != null || this.trackSelection.length() < 2) {
            return queue.size();
        }
        return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
    }

    @Override
    public final void getNextChunk(MediaChunk previous, long playbackPositionUs, ChunkHolder out) {
        Chunk nextMediaChunk;
        int segmentNum;
        boolean indexUnbounded;
        if (this.fatalError != null) {
            return;
        }
        long bufferedDurationUs = previous != null ? previous.endTimeUs - playbackPositionUs : 0L;
        this.trackSelection.updateSelectedTrack(bufferedDurationUs);
        RepresentationHolder representationHolder = this.representationHolders[this.trackSelection.getSelectedIndex()];
        Representation selectedRepresentation = representationHolder.representation;
        DashSegmentIndex segmentIndex = representationHolder.segmentIndex;
        RangedUri pendingInitializationUri = null;
        RangedUri pendingIndexUri = null;
        Format sampleFormat = representationHolder.sampleFormat;
        if (sampleFormat == null) {
            pendingInitializationUri = selectedRepresentation.getInitializationUri();
        }
        if (segmentIndex == null) {
            pendingIndexUri = selectedRepresentation.getIndexUri();
        }
        if (pendingInitializationUri != null || pendingIndexUri != null) {
            Chunk initializationChunk;
            out.chunk = initializationChunk = this.newInitializationChunk(representationHolder, this.dataSource, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), pendingInitializationUri, pendingIndexUri);
            return;
        }
        long nowUs = this.getNowUnixTimeUs();
        int firstAvailableSegmentNum = representationHolder.getFirstSegmentNum();
        int lastAvailableSegmentNum = representationHolder.getLastSegmentNum();
        boolean bl = indexUnbounded = lastAvailableSegmentNum == -1;
        if (indexUnbounded) {
            long liveEdgeTimeUs = nowUs - this.manifest.availabilityStartTime * 1000L;
            long periodStartUs = this.manifest.getPeriod((int)this.periodIndex).startMs * 1000L;
            long liveEdgeTimeInPeriodUs = liveEdgeTimeUs - periodStartUs;
            if (this.manifest.timeShiftBufferDepth != -9223372036854775807L) {
                long bufferDepthUs = this.manifest.timeShiftBufferDepth * 1000L;
                firstAvailableSegmentNum = Math.max(firstAvailableSegmentNum, representationHolder.getSegmentNum(liveEdgeTimeInPeriodUs - bufferDepthUs));
            }
            lastAvailableSegmentNum = representationHolder.getSegmentNum(liveEdgeTimeInPeriodUs) - 1;
        }
        if (previous == null) {
            segmentNum = Util.constrainValue(representationHolder.getSegmentNum(playbackPositionUs), firstAvailableSegmentNum, lastAvailableSegmentNum);
        } else {
            segmentNum = previous.getNextChunkIndex();
            if (segmentNum < firstAvailableSegmentNum) {
                this.fatalError = new BehindLiveWindowException();
                return;
            }
        }
        if (segmentNum > lastAvailableSegmentNum || this.missingLastSegment && segmentNum >= lastAvailableSegmentNum) {
            out.endOfStream = !this.manifest.dynamic || this.periodIndex < this.manifest.getPeriodCount() - 1;
            return;
        }
        out.chunk = nextMediaChunk = this.newMediaChunk(representationHolder, this.dataSource, this.trackSelection.getSelectedFormat(), this.trackSelection.getSelectionReason(), this.trackSelection.getSelectionData(), sampleFormat, segmentNum);
    }

    @Override
    public void onChunkLoadCompleted(Chunk chunk) {
        if (chunk instanceof InitializationChunk) {
            SeekMap seekMap;
            InitializationChunk initializationChunk = (InitializationChunk)chunk;
            RepresentationHolder representationHolder = this.representationHolders[this.trackSelection.indexOf(initializationChunk.trackFormat)];
            Format sampleFormat = initializationChunk.getSampleFormat();
            if (sampleFormat != null) {
                representationHolder.setSampleFormat(sampleFormat);
            }
            if (representationHolder.segmentIndex == null && (seekMap = initializationChunk.getSeekMap()) != null) {
                representationHolder.segmentIndex = new DashWrappingSegmentIndex((ChunkIndex)seekMap, initializationChunk.dataSpec.uri.toString());
            }
        }
    }

    @Override
    public boolean onChunkLoadError(Chunk chunk, boolean cancelable, Exception e) {
        RepresentationHolder representationHolder;
        int lastAvailableSegmentNum;
        if (!cancelable) {
            return false;
        }
        if (!this.manifest.dynamic && chunk instanceof MediaChunk && e instanceof HttpDataSource.InvalidResponseCodeException && ((HttpDataSource.InvalidResponseCodeException)e).responseCode == 404 && ((MediaChunk)chunk).chunkIndex >= (lastAvailableSegmentNum = (representationHolder = this.representationHolders[this.trackSelection.indexOf(chunk.trackFormat)]).getLastSegmentNum())) {
            this.missingLastSegment = true;
            return true;
        }
        return ChunkedTrackBlacklistUtil.maybeBlacklistTrack(this.trackSelection, this.trackSelection.indexOf(chunk.trackFormat), e);
    }

    private List<Representation> getRepresentations() {
        return this.manifest.getPeriod((int)this.periodIndex).adaptationSets.get((int)this.adaptationSetIndex).representations;
    }

    private long getNowUnixTimeUs() {
        if (this.elapsedRealtimeOffsetMs != 0L) {
            return (SystemClock.elapsedRealtime() + this.elapsedRealtimeOffsetMs) * 1000L;
        }
        return System.currentTimeMillis() * 1000L;
    }

    private Chunk newInitializationChunk(RepresentationHolder representationHolder, DataSource dataSource, Format trackFormat, int trackSelectionReason, Object trackSelectionData, RangedUri initializationUri, RangedUri indexUri) {
        RangedUri requestUri;
        if (initializationUri != null) {
            requestUri = initializationUri.attemptMerge(indexUri);
            if (requestUri == null) {
                requestUri = initializationUri;
            }
        } else {
            requestUri = indexUri;
        }
        DataSpec dataSpec = new DataSpec(requestUri.getUri(), requestUri.start, requestUri.length, representationHolder.representation.getCacheKey());
        return new InitializationChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, representationHolder.extractorWrapper);
    }

    private Chunk newMediaChunk(RepresentationHolder representationHolder, DataSource dataSource, Format trackFormat, int trackSelectionReason, Object trackSelectionData, Format sampleFormat, int segmentNum) {
        Representation representation = representationHolder.representation;
        long startTimeUs = representationHolder.getSegmentStartTimeUs(segmentNum);
        long endTimeUs = representationHolder.getSegmentEndTimeUs(segmentNum);
        RangedUri segmentUri = representationHolder.getSegmentUrl(segmentNum);
        DataSpec dataSpec = new DataSpec(segmentUri.getUri(), segmentUri.start, segmentUri.length, representation.getCacheKey());
        if (representationHolder.extractorWrapper == null) {
            return new SingleSampleMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, segmentNum, trackFormat);
        }
        long sampleOffsetUs = -representation.presentationTimeOffsetUs;
        return new ContainerMediaChunk(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, segmentNum, sampleOffsetUs, representationHolder.extractorWrapper, sampleFormat);
    }

    protected static final class RepresentationHolder {
        public final ChunkExtractorWrapper extractorWrapper;
        public Representation representation;
        public DashSegmentIndex segmentIndex;
        public Format sampleFormat;
        private long periodDurationUs;
        private int segmentNumShift;

        public RepresentationHolder(long periodDurationUs, Representation representation) {
            this.periodDurationUs = periodDurationUs;
            this.representation = representation;
            String containerMimeType = representation.format.containerMimeType;
            if (RepresentationHolder.mimeTypeIsRawText(containerMimeType)) {
                this.extractorWrapper = null;
            } else {
                Extractor extractor;
                boolean resendFormatOnInit = false;
                if ("application/x-rawcc".equals(containerMimeType)) {
                    extractor = new RawCcExtractor();
                    resendFormatOnInit = true;
                } else {
                    extractor = RepresentationHolder.mimeTypeIsWebm(containerMimeType) ? new MatroskaExtractor() : new FragmentedMp4Extractor();
                }
                this.extractorWrapper = new ChunkExtractorWrapper(extractor, representation.format, true, resendFormatOnInit);
            }
            this.segmentIndex = representation.getIndex();
        }

        public void setSampleFormat(Format sampleFormat) {
            this.sampleFormat = sampleFormat;
        }

        public void updateRepresentation(long newPeriodDurationUs, Representation newRepresentation) throws BehindLiveWindowException {
            int newIndexFirstSegmentNum;
            long newIndexStartTimeUs;
            DashSegmentIndex oldIndex = this.representation.getIndex();
            DashSegmentIndex newIndex = newRepresentation.getIndex();
            this.periodDurationUs = newPeriodDurationUs;
            this.representation = newRepresentation;
            if (oldIndex == null) {
                return;
            }
            this.segmentIndex = newIndex;
            if (!oldIndex.isExplicit()) {
                return;
            }
            int oldIndexLastSegmentNum = oldIndex.getLastSegmentNum(this.periodDurationUs);
            long oldIndexEndTimeUs = oldIndex.getTimeUs(oldIndexLastSegmentNum) + oldIndex.getDurationUs(oldIndexLastSegmentNum, this.periodDurationUs);
            if (oldIndexEndTimeUs == (newIndexStartTimeUs = newIndex.getTimeUs(newIndexFirstSegmentNum = newIndex.getFirstSegmentNum()))) {
                this.segmentNumShift += oldIndex.getLastSegmentNum(this.periodDurationUs) + 1 - newIndexFirstSegmentNum;
            } else {
                if (oldIndexEndTimeUs < newIndexStartTimeUs) {
                    throw new BehindLiveWindowException();
                }
                this.segmentNumShift += oldIndex.getSegmentNum(newIndexStartTimeUs, this.periodDurationUs) - newIndexFirstSegmentNum;
            }
        }

        public int getFirstSegmentNum() {
            return this.segmentIndex.getFirstSegmentNum() + this.segmentNumShift;
        }

        public int getLastSegmentNum() {
            int lastSegmentNum = this.segmentIndex.getLastSegmentNum(this.periodDurationUs);
            if (lastSegmentNum == -1) {
                return -1;
            }
            return lastSegmentNum + this.segmentNumShift;
        }

        public long getSegmentStartTimeUs(int segmentNum) {
            return this.segmentIndex.getTimeUs(segmentNum - this.segmentNumShift);
        }

        public long getSegmentEndTimeUs(int segmentNum) {
            return this.getSegmentStartTimeUs(segmentNum) + this.segmentIndex.getDurationUs(segmentNum - this.segmentNumShift, this.periodDurationUs);
        }

        public int getSegmentNum(long positionUs) {
            return this.segmentIndex.getSegmentNum(positionUs, this.periodDurationUs) + this.segmentNumShift;
        }

        public RangedUri getSegmentUrl(int segmentNum) {
            return this.segmentIndex.getSegmentUrl(segmentNum - this.segmentNumShift);
        }

        private static boolean mimeTypeIsWebm(String mimeType) {
            return mimeType.startsWith("video/webm") || mimeType.startsWith("audio/webm") || mimeType.startsWith("application/webm");
        }

        private static boolean mimeTypeIsRawText(String mimeType) {
            return MimeTypes.isText(mimeType) || "application/ttml+xml".equals(mimeType);
        }
    }

    public static final class Factory
    implements DashChunkSource.Factory {
        private final DataSource.Factory dataSourceFactory;

        public Factory(DataSource.Factory dataSourceFactory) {
            this.dataSourceFactory = dataSourceFactory;
        }

        @Override
        public DashChunkSource createDashChunkSource(LoaderErrorThrower manifestLoaderErrorThrower, DashManifest manifest, int periodIndex, int adaptationSetIndex, TrackSelection trackSelection, long elapsedRealtimeOffsetMs) {
            DataSource dataSource = this.dataSourceFactory.createDataSource();
            return new DefaultDashChunkSource(manifestLoaderErrorThrower, manifest, periodIndex, adaptationSetIndex, trackSelection, dataSource, elapsedRealtimeOffsetMs);
        }
    }
}

