/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.AdaptiveMediaSourceEventListener;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaPeriod;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public final class DashMediaSource
implements MediaSource {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_PREFER_MANIFEST_MS = -1L;
    public static final long DEFAULT_LIVE_PRESENTATION_DELAY_FIXED_MS = 30000L;
    private static final int NOTIFY_MANIFEST_INTERVAL_MS = 5000;
    private static final long MIN_LIVE_DEFAULT_START_POSITION_US = 5000000L;
    private static final String TAG = "DashMediaSource";
    private final DataSource.Factory manifestDataSourceFactory;
    private final DashChunkSource.Factory chunkSourceFactory;
    private final int minLoadableRetryCount;
    private final long livePresentationDelayMs;
    private final AdaptiveMediaSourceEventListener.EventDispatcher eventDispatcher;
    private final DashManifestParser manifestParser;
    private final ManifestCallback manifestCallback;
    private final Object manifestUriLock;
    private final SparseArray<DashMediaPeriod> periodsById;
    private final Runnable refreshManifestRunnable;
    private final Runnable simulateManifestRefreshRunnable;
    private MediaSource.Listener sourceListener;
    private DataSource dataSource;
    private Loader loader;
    private Uri manifestUri;
    private long manifestLoadStartTimestamp;
    private long manifestLoadEndTimestamp;
    private DashManifest manifest;
    private Handler handler;
    private long elapsedRealtimeOffsetMs;
    private int firstPeriodId;

    public DashMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, DashChunkSource.Factory chunkSourceFactory, Handler eventHandler, AdaptiveMediaSourceEventListener eventListener) {
        this(manifestUri, manifestDataSourceFactory, chunkSourceFactory, 3, -1L, eventHandler, eventListener);
    }

    public DashMediaSource(Uri manifestUri, DataSource.Factory manifestDataSourceFactory, DashChunkSource.Factory chunkSourceFactory, int minLoadableRetryCount, long livePresentationDelayMs, Handler eventHandler, AdaptiveMediaSourceEventListener eventListener) {
        this.manifestUri = manifestUri;
        this.manifestDataSourceFactory = manifestDataSourceFactory;
        this.chunkSourceFactory = chunkSourceFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.livePresentationDelayMs = livePresentationDelayMs;
        this.eventDispatcher = new AdaptiveMediaSourceEventListener.EventDispatcher(eventHandler, eventListener);
        this.manifestParser = new DashManifestParser(this.generateContentId());
        this.manifestCallback = new ManifestCallback();
        this.manifestUriLock = new Object();
        this.periodsById = new SparseArray();
        this.refreshManifestRunnable = new Runnable(){

            @Override
            public void run() {
                DashMediaSource.this.startLoadingManifest();
            }
        };
        this.simulateManifestRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                DashMediaSource.this.processManifest();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceManifestUri(Uri manifestUri) {
        Object object = this.manifestUriLock;
        synchronized (object) {
            this.manifestUri = manifestUri;
        }
    }

    @Override
    public void prepareSource(MediaSource.Listener listener) {
        this.sourceListener = listener;
        this.dataSource = this.manifestDataSourceFactory.createDataSource();
        this.loader = new Loader("Loader:DashMediaSource");
        this.handler = new Handler();
        this.startLoadingManifest();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.loader.maybeThrowError();
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        DashMediaPeriod mediaPeriod = new DashMediaPeriod(this.firstPeriodId + index, this.manifest, index, this.chunkSourceFactory, this.minLoadableRetryCount, this.eventDispatcher, this.elapsedRealtimeOffsetMs, this.loader, allocator);
        this.periodsById.put(mediaPeriod.id, (Object)mediaPeriod);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        DashMediaPeriod dashMediaPeriod = (DashMediaPeriod)mediaPeriod;
        dashMediaPeriod.release();
        this.periodsById.remove(dashMediaPeriod.id);
    }

    @Override
    public void releaseSource() {
        this.dataSource = null;
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
        this.manifestLoadStartTimestamp = 0L;
        this.manifestLoadEndTimestamp = 0L;
        this.manifest = null;
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        this.elapsedRealtimeOffsetMs = 0L;
        this.periodsById.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onManifestLoadCompleted(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        int removedPeriodCount;
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        DashManifest newManifest = loadable.getResult();
        int periodCount = this.manifest == null ? 0 : this.manifest.getPeriodCount();
        long newFirstPeriodStartTimeMs = newManifest.getPeriod((int)0).startMs;
        for (removedPeriodCount = 0; removedPeriodCount < periodCount && this.manifest.getPeriod((int)removedPeriodCount).startMs < newFirstPeriodStartTimeMs; ++removedPeriodCount) {
        }
        if (periodCount - removedPeriodCount > newManifest.getPeriodCount()) {
            Log.w((String)TAG, (String)"Out of sync manifest");
            this.scheduleManifestRefresh();
            return;
        }
        this.manifest = newManifest;
        this.manifestLoadStartTimestamp = elapsedRealtimeMs - loadDurationMs;
        this.manifestLoadEndTimestamp = elapsedRealtimeMs;
        if (this.manifest.location != null) {
            Object object = this.manifestUriLock;
            synchronized (object) {
                if (loadable.dataSpec.uri == this.manifestUri) {
                    this.manifestUri = this.manifest.location;
                }
            }
        }
        if (periodCount == 0) {
            if (this.manifest.utcTiming != null) {
                this.resolveUtcTimingElement(this.manifest.utcTiming);
            } else {
                this.processManifestAndScheduleRefresh();
            }
        } else {
            this.firstPeriodId += removedPeriodCount;
            this.processManifestAndScheduleRefresh();
        }
    }

    int onManifestLoadError(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        boolean isFatal = error instanceof ParserException;
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, isFatal);
        return isFatal ? 3 : 0;
    }

    void onUtcTimestampLoadCompleted(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.eventDispatcher.loadCompleted(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
        this.onUtcTimestampResolved(loadable.getResult() - elapsedRealtimeMs);
    }

    int onUtcTimestampLoadError(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        this.eventDispatcher.loadError(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded(), error, true);
        this.onUtcTimestampResolutionError(error);
        return 2;
    }

    void onLoadCanceled(ParsingLoadable<?> loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.eventDispatcher.loadCanceled(loadable.dataSpec, loadable.type, elapsedRealtimeMs, loadDurationMs, loadable.bytesLoaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingManifest() {
        Uri manifestUri;
        Object object = this.manifestUriLock;
        synchronized (object) {
            manifestUri = this.manifestUri;
        }
        this.startLoading(new ParsingLoadable<DashManifest>(this.dataSource, manifestUri, 4, this.manifestParser), this.manifestCallback, this.minLoadableRetryCount);
    }

    private void resolveUtcTimingElement(UtcTimingElement timingElement) {
        String scheme = timingElement.schemeIdUri;
        if (Util.areEqual(scheme, "urn:mpeg:dash:utc:direct:2012")) {
            this.resolveUtcTimingElementDirect(timingElement);
        } else if (Util.areEqual(scheme, "urn:mpeg:dash:utc:http-iso:2014")) {
            this.resolveUtcTimingElementHttp(timingElement, new Iso8601Parser());
        } else if (Util.areEqual(scheme, "urn:mpeg:dash:utc:http-xsdate:2012") || Util.areEqual(scheme, "urn:mpeg:dash:utc:http-xsdate:2014")) {
            this.resolveUtcTimingElementHttp(timingElement, new XsDateTimeParser());
        } else {
            this.onUtcTimestampResolutionError(new IOException("Unsupported UTC timing scheme"));
        }
    }

    private void resolveUtcTimingElementDirect(UtcTimingElement timingElement) {
        try {
            long utcTimestamp = Util.parseXsDateTime(timingElement.value);
            this.onUtcTimestampResolved(utcTimestamp - this.manifestLoadEndTimestamp);
        }
        catch (ParseException e) {
            this.onUtcTimestampResolutionError(new ParserException(e));
        }
    }

    private void resolveUtcTimingElementHttp(UtcTimingElement timingElement, ParsingLoadable.Parser<Long> parser) {
        this.startLoading(new ParsingLoadable<Long>(this.dataSource, Uri.parse((String)timingElement.value), 5, parser), new UtcTimestampCallback(), 1);
    }

    private void onUtcTimestampResolved(long elapsedRealtimeOffsetMs) {
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.processManifestAndScheduleRefresh();
    }

    private void onUtcTimestampResolutionError(IOException error) {
        Log.e((String)TAG, (String)"Failed to resolve UtcTiming element.", (Throwable)error);
        this.processManifestAndScheduleRefresh();
    }

    private void processManifestAndScheduleRefresh() {
        this.processManifest();
        this.scheduleManifestRefresh();
    }

    private void processManifest() {
        int periodIndex;
        for (int i = 0; i < this.periodsById.size(); ++i) {
            int id = this.periodsById.keyAt(i);
            if (id < this.firstPeriodId) continue;
            ((DashMediaPeriod)this.periodsById.valueAt(i)).updateManifest(this.manifest, id - this.firstPeriodId);
        }
        this.handler.removeCallbacks(this.simulateManifestRefreshRunnable);
        int lastPeriodIndex = this.manifest.getPeriodCount() - 1;
        PeriodSeekInfo firstPeriodSeekInfo = PeriodSeekInfo.createPeriodSeekInfo(this.manifest.getPeriod(0), this.manifest.getPeriodDurationUs(0));
        PeriodSeekInfo lastPeriodSeekInfo = PeriodSeekInfo.createPeriodSeekInfo(this.manifest.getPeriod(lastPeriodIndex), this.manifest.getPeriodDurationUs(lastPeriodIndex));
        long currentStartTimeUs = firstPeriodSeekInfo.availableStartTimeUs;
        long currentEndTimeUs = lastPeriodSeekInfo.availableEndTimeUs;
        if (this.manifest.dynamic && !lastPeriodSeekInfo.isIndexExplicit) {
            long liveStreamDurationUs = this.getNowUnixTimeUs() - C.msToUs(this.manifest.availabilityStartTime);
            long liveStreamEndPositionInLastPeriodUs = liveStreamDurationUs - C.msToUs(this.manifest.getPeriod((int)lastPeriodIndex).startMs);
            currentEndTimeUs = Math.min(liveStreamEndPositionInLastPeriodUs, currentEndTimeUs);
            if (this.manifest.timeShiftBufferDepth != -9223372036854775807L) {
                long offsetInPeriodUs;
                long timeShiftBufferDepthUs = C.msToUs(this.manifest.timeShiftBufferDepth);
                periodIndex = lastPeriodIndex;
                for (offsetInPeriodUs = currentEndTimeUs - timeShiftBufferDepthUs; offsetInPeriodUs < 0L && periodIndex > 0; offsetInPeriodUs += this.manifest.getPeriodDurationUs(--periodIndex)) {
                }
                currentStartTimeUs = periodIndex == 0 ? Math.max(currentStartTimeUs, offsetInPeriodUs) : this.manifest.getPeriodDurationUs(0);
            }
            this.handler.postDelayed(this.simulateManifestRefreshRunnable, 5000L);
        }
        long windowDurationUs = currentEndTimeUs - currentStartTimeUs;
        for (int i = 0; i < this.manifest.getPeriodCount() - 1; ++i) {
            windowDurationUs += this.manifest.getPeriodDurationUs(i);
        }
        long windowDefaultStartPositionUs = 0L;
        if (this.manifest.dynamic) {
            long defaultStartPositionInPeriodUs;
            long defaultStartPositionUs;
            long presentationDelayForManifestMs = this.livePresentationDelayMs;
            if (presentationDelayForManifestMs == -1L) {
                long l = presentationDelayForManifestMs = this.manifest.suggestedPresentationDelay != -9223372036854775807L ? this.manifest.suggestedPresentationDelay : 30000L;
            }
            if ((defaultStartPositionUs = windowDurationUs - C.msToUs(presentationDelayForManifestMs)) < 5000000L) {
                defaultStartPositionUs = Math.min(5000000L, windowDurationUs / 2L);
            }
            periodIndex = 0;
            long periodDurationUs = this.manifest.getPeriodDurationUs(periodIndex);
            for (defaultStartPositionInPeriodUs = currentStartTimeUs + defaultStartPositionUs; periodIndex < this.manifest.getPeriodCount() - 1 && defaultStartPositionInPeriodUs >= periodDurationUs; defaultStartPositionInPeriodUs -= periodDurationUs) {
                periodDurationUs = this.manifest.getPeriodDurationUs(++periodIndex);
            }
            Period period = this.manifest.getPeriod(periodIndex);
            int videoAdaptationSetIndex = period.getAdaptationSetIndex(2);
            if (videoAdaptationSetIndex != -1) {
                DashSegmentIndex index = period.adaptationSets.get((int)videoAdaptationSetIndex).representations.get(0).getIndex();
                int segmentNum = index.getSegmentNum(defaultStartPositionInPeriodUs, periodDurationUs);
                windowDefaultStartPositionUs = defaultStartPositionUs - defaultStartPositionInPeriodUs + index.getTimeUs(segmentNum);
            } else {
                windowDefaultStartPositionUs = defaultStartPositionUs;
            }
        }
        long windowStartTimeMs = this.manifest.availabilityStartTime + this.manifest.getPeriod((int)0).startMs + C.usToMs(currentStartTimeUs);
        DashTimeline timeline = new DashTimeline(this.manifest.availabilityStartTime, windowStartTimeMs, this.firstPeriodId, currentStartTimeUs, windowDurationUs, windowDefaultStartPositionUs, this.manifest);
        this.sourceListener.onSourceInfoRefreshed(timeline, this.manifest);
    }

    private void scheduleManifestRefresh() {
        if (!this.manifest.dynamic) {
            return;
        }
        long minUpdatePeriod = this.manifest.minUpdatePeriod;
        if (minUpdatePeriod == 0L) {
            minUpdatePeriod = 5000L;
        }
        long nextLoadTimestamp = this.manifestLoadStartTimestamp + minUpdatePeriod;
        long delayUntilNextLoad = Math.max(0L, nextLoadTimestamp - SystemClock.elapsedRealtime());
        this.handler.postDelayed(this.refreshManifestRunnable, delayUntilNextLoad);
    }

    private <T> void startLoading(ParsingLoadable<T> loadable, Loader.Callback<ParsingLoadable<T>> callback, int minRetryCount) {
        long elapsedRealtimeMs = this.loader.startLoading(loadable, callback, minRetryCount);
        this.eventDispatcher.loadStarted(loadable.dataSpec, loadable.type, elapsedRealtimeMs);
    }

    private long getNowUnixTimeUs() {
        if (this.elapsedRealtimeOffsetMs != 0L) {
            return C.msToUs(SystemClock.elapsedRealtime() + this.elapsedRealtimeOffsetMs);
        }
        return C.msToUs(System.currentTimeMillis());
    }

    private String generateContentId() {
        return Util.sha1(this.manifestUri.toString());
    }

    private static final class Iso8601Parser
    implements ParsingLoadable.Parser<Long> {
        private Iso8601Parser() {
        }

        @Override
        public Long parse(Uri uri, InputStream inputStream) throws IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.parse(firstLine).getTime();
            }
            catch (ParseException e) {
                throw new ParserException(e);
            }
        }
    }

    private static final class XsDateTimeParser
    implements ParsingLoadable.Parser<Long> {
        private XsDateTimeParser() {
        }

        @Override
        public Long parse(Uri uri, InputStream inputStream) throws IOException {
            String firstLine = new BufferedReader(new InputStreamReader(inputStream)).readLine();
            try {
                return Util.parseXsDateTime(firstLine);
            }
            catch (ParseException e) {
                throw new ParserException(e);
            }
        }
    }

    private final class UtcTimestampCallback
    implements Loader.Callback<ParsingLoadable<Long>> {
        private UtcTimestampCallback() {
        }

        @Override
        public void onLoadCompleted(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            DashMediaSource.this.onUtcTimestampLoadCompleted(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        @Override
        public void onLoadCanceled(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DashMediaSource.this.onLoadCanceled(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        @Override
        public int onLoadError(ParsingLoadable<Long> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
            return DashMediaSource.this.onUtcTimestampLoadError(loadable, elapsedRealtimeMs, loadDurationMs, error);
        }
    }

    private final class ManifestCallback
    implements Loader.Callback<ParsingLoadable<DashManifest>> {
        private ManifestCallback() {
        }

        @Override
        public void onLoadCompleted(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs) {
            DashMediaSource.this.onManifestLoadCompleted(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        @Override
        public void onLoadCanceled(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
            DashMediaSource.this.onLoadCanceled(loadable, elapsedRealtimeMs, loadDurationMs);
        }

        @Override
        public int onLoadError(ParsingLoadable<DashManifest> loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
            return DashMediaSource.this.onManifestLoadError(loadable, elapsedRealtimeMs, loadDurationMs, error);
        }
    }

    private static final class DashTimeline
    extends Timeline {
        private final long presentationStartTimeMs;
        private final long windowStartTimeMs;
        private final int firstPeriodId;
        private final long offsetInFirstPeriodUs;
        private final long windowDurationUs;
        private final long windowDefaultStartPositionUs;
        private final DashManifest manifest;

        public DashTimeline(long presentationStartTimeMs, long windowStartTimeMs, int firstPeriodId, long offsetInFirstPeriodUs, long windowDurationUs, long windowDefaultStartPositionUs, DashManifest manifest) {
            this.presentationStartTimeMs = presentationStartTimeMs;
            this.windowStartTimeMs = windowStartTimeMs;
            this.firstPeriodId = firstPeriodId;
            this.offsetInFirstPeriodUs = offsetInFirstPeriodUs;
            this.windowDurationUs = windowDurationUs;
            this.windowDefaultStartPositionUs = windowDefaultStartPositionUs;
            this.manifest = manifest;
        }

        @Override
        public int getPeriodCount() {
            return this.manifest.getPeriodCount();
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIdentifiers) {
            Assertions.checkIndex(periodIndex, 0, this.manifest.getPeriodCount());
            String id = setIdentifiers ? this.manifest.getPeriod((int)periodIndex).id : null;
            Integer uid = setIdentifiers ? Integer.valueOf(this.firstPeriodId + Assertions.checkIndex(periodIndex, 0, this.manifest.getPeriodCount())) : null;
            return period.set(id, uid, 0, this.manifest.getPeriodDurationUs(periodIndex), C.msToUs(this.manifest.getPeriod((int)periodIndex).startMs - this.manifest.getPeriod((int)0).startMs) - this.offsetInFirstPeriodUs);
        }

        @Override
        public int getWindowCount() {
            return 1;
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, boolean setIdentifier) {
            Assertions.checkIndex(windowIndex, 0, 1);
            return window.set(null, this.presentationStartTimeMs, this.windowStartTimeMs, true, this.manifest.dynamic, this.windowDefaultStartPositionUs, this.windowDurationUs, 0, this.manifest.getPeriodCount() - 1, this.offsetInFirstPeriodUs);
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            if (!(uid instanceof Integer)) {
                return -1;
            }
            int periodId = (Integer)uid;
            return periodId < this.firstPeriodId || periodId >= this.firstPeriodId + this.getPeriodCount() ? -1 : periodId - this.firstPeriodId;
        }
    }

    private static final class PeriodSeekInfo {
        public final boolean isIndexExplicit;
        public final long availableStartTimeUs;
        public final long availableEndTimeUs;

        public static PeriodSeekInfo createPeriodSeekInfo(Period period, long durationUs) {
            int adaptationSetCount = period.adaptationSets.size();
            long availableStartTimeUs = 0L;
            long availableEndTimeUs = Long.MAX_VALUE;
            boolean isIndexExplicit = false;
            for (int i = 0; i < adaptationSetCount; ++i) {
                DashSegmentIndex index = period.adaptationSets.get((int)i).representations.get(0).getIndex();
                if (index == null) {
                    return new PeriodSeekInfo(true, 0L, durationUs);
                }
                int firstSegmentNum = index.getFirstSegmentNum();
                int lastSegmentNum = index.getLastSegmentNum(durationUs);
                isIndexExplicit |= index.isExplicit();
                long adaptationSetAvailableStartTimeUs = index.getTimeUs(firstSegmentNum);
                availableStartTimeUs = Math.max(availableStartTimeUs, adaptationSetAvailableStartTimeUs);
                if (lastSegmentNum == -1) continue;
                long adaptationSetAvailableEndTimeUs = index.getTimeUs(lastSegmentNum) + index.getDurationUs(lastSegmentNum, durationUs);
                availableEndTimeUs = Math.min(availableEndTimeUs, adaptationSetAvailableEndTimeUs);
            }
            return new PeriodSeekInfo(isIndexExplicit, availableStartTimeUs, availableEndTimeUs);
        }

        private PeriodSeekInfo(boolean isIndexExplicit, long availableStartTimeUs, long availableEndTimeUs) {
            this.isIndexExplicit = isIndexExplicit;
            this.availableStartTimeUs = availableStartTimeUs;
            this.availableEndTimeUs = availableEndTimeUs;
        }
    }
}

