/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.DefaultTrackOutput;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunk;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class SingleSampleMediaChunk
extends BaseMediaChunk {
    private final Format sampleFormat;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;
    private volatile boolean loadCompleted;

    public SingleSampleMediaChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, Object trackSelectionData, long startTimeUs, long endTimeUs, int chunkIndex, Format sampleFormat) {
        super(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, chunkIndex);
        this.sampleFormat = sampleFormat;
    }

    @Override
    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        DataSpec loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            long length = this.dataSource.open(loadDataSpec);
            if (length != -1L) {
                length += (long)this.bytesLoaded;
            }
            DefaultExtractorInput extractorInput = new DefaultExtractorInput(this.dataSource, this.bytesLoaded, length);
            DefaultTrackOutput trackOutput = this.getTrackOutput();
            trackOutput.formatWithOffset(this.sampleFormat, 0L);
            int result = 0;
            while (result != -1) {
                this.bytesLoaded += result;
                result = trackOutput.sampleData(extractorInput, Integer.MAX_VALUE, true);
            }
            int sampleSize = this.bytesLoaded;
            trackOutput.sampleMetadata(this.startTimeUs, 1, sampleSize, 0, null);
        }
        finally {
            this.dataSource.close();
        }
        this.loadCompleted = true;
    }
}

