/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.ChunkExtractorWrapper;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class InitializationChunk
extends Chunk
implements ChunkExtractorWrapper.SingleTrackMetadataOutput,
TrackOutput {
    private final ChunkExtractorWrapper extractorWrapper;
    private Format sampleFormat;
    private SeekMap seekMap;
    private volatile int bytesLoaded;
    private volatile boolean loadCanceled;

    public InitializationChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, Object trackSelectionData, ChunkExtractorWrapper extractorWrapper) {
        super(dataSource, dataSpec, 2, trackFormat, trackSelectionReason, trackSelectionData, -9223372036854775807L, -9223372036854775807L);
        this.extractorWrapper = extractorWrapper;
    }

    @Override
    public long bytesLoaded() {
        return this.bytesLoaded;
    }

    public Format getSampleFormat() {
        return this.sampleFormat;
    }

    public SeekMap getSeekMap() {
        return this.seekMap;
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
    }

    @Override
    public void format(Format format) {
        this.sampleFormat = format;
    }

    @Override
    public int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        throw new IllegalStateException("Unexpected sample data in initialization chunk");
    }

    @Override
    public void sampleData(ParsableByteArray data, int length) {
        throw new IllegalStateException("Unexpected sample data in initialization chunk");
    }

    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
        throw new IllegalStateException("Unexpected sample data in initialization chunk");
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException, InterruptedException {
        DataSpec loadDataSpec = Util.getRemainderDataSpec(this.dataSpec, this.bytesLoaded);
        try {
            DefaultExtractorInput input = new DefaultExtractorInput(this.dataSource, loadDataSpec.absoluteStreamPosition, this.dataSource.open(loadDataSpec));
            if (this.bytesLoaded == 0) {
                this.extractorWrapper.init(this, this);
            }
            try {
                int result = 0;
                while (result == 0 && !this.loadCanceled) {
                    result = this.extractorWrapper.read(input);
                }
            }
            finally {
                this.bytesLoaded = (int)(input.getPosition() - this.dataSpec.absoluteStreamPosition);
            }
        }
        finally {
            this.dataSource.close();
        }
    }
}

