/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import java.io.IOException;
import java.util.Arrays;

public abstract class DataChunk
extends Chunk {
    private static final int READ_GRANULARITY = 16384;
    private byte[] data;
    private int limit;
    private volatile boolean loadCanceled;

    public DataChunk(DataSource dataSource, DataSpec dataSpec, int type, Format trackFormat, int trackSelectionReason, Object trackSelectionData, byte[] data) {
        super(dataSource, dataSpec, type, trackFormat, trackSelectionReason, trackSelectionData, -9223372036854775807L, -9223372036854775807L);
        this.data = data;
    }

    public byte[] getDataHolder() {
        return this.data;
    }

    @Override
    public long bytesLoaded() {
        return this.limit;
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    @Override
    public final void load() throws IOException, InterruptedException {
        try {
            this.dataSource.open(this.dataSpec);
            this.limit = 0;
            int bytesRead = 0;
            while (bytesRead != -1 && !this.loadCanceled) {
                this.maybeExpandData();
                bytesRead = this.dataSource.read(this.data, this.limit, 16384);
                if (bytesRead == -1) continue;
                this.limit += bytesRead;
            }
            if (!this.loadCanceled) {
                this.consume(this.data, this.limit);
            }
        }
        finally {
            this.dataSource.close();
        }
    }

    protected abstract void consume(byte[] var1, int var2) throws IOException;

    private void maybeExpandData() {
        if (this.data == null) {
            this.data = new byte[16384];
        } else if (this.data.length < this.limit + 16384) {
            this.data = Arrays.copyOf(this.data, this.data.length + 16384);
        }
    }
}

