/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import android.util.Log;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.HttpDataSource;

public final class ChunkedTrackBlacklistUtil {
    public static final long DEFAULT_TRACK_BLACKLIST_MS = 60000L;
    private static final String TAG = "ChunkedTrackBlacklist";

    public static boolean maybeBlacklistTrack(TrackSelection trackSelection, int trackSelectionIndex, Exception e) {
        return ChunkedTrackBlacklistUtil.maybeBlacklistTrack(trackSelection, trackSelectionIndex, e, 60000L);
    }

    public static boolean maybeBlacklistTrack(TrackSelection trackSelection, int trackSelectionIndex, Exception e, long blacklistDurationMs) {
        if (trackSelection.length() == 1) {
            return false;
        }
        if (e instanceof HttpDataSource.InvalidResponseCodeException) {
            HttpDataSource.InvalidResponseCodeException responseCodeException = (HttpDataSource.InvalidResponseCodeException)e;
            int responseCode = responseCodeException.responseCode;
            if (responseCode == 404 || responseCode == 410) {
                boolean blacklisted = trackSelection.blacklist(trackSelectionIndex, blacklistDurationMs);
                if (blacklisted) {
                    Log.w((String)TAG, (String)("Blacklisted: duration=" + blacklistDurationMs + ", responseCode=" + responseCode + ", format=" + trackSelection.getFormat(trackSelectionIndex)));
                } else {
                    Log.w((String)TAG, (String)("Blacklisting failed (cannot blacklist last enabled track): responseCode=" + responseCode + ", format=" + trackSelection.getFormat(trackSelectionIndex)));
                }
                return blacklisted;
            }
        }
        return false;
    }

    private ChunkedTrackBlacklistUtil() {
    }
}

