/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;

public final class ChunkExtractorWrapper
implements ExtractorOutput,
TrackOutput {
    private final Extractor extractor;
    private final Format manifestFormat;
    private final boolean preferManifestDrmInitData;
    private final boolean resendFormatOnInit;
    private boolean extractorInitialized;
    private SingleTrackMetadataOutput metadataOutput;
    private TrackOutput trackOutput;
    private Format sentFormat;
    private boolean seenTrack;
    private int seenTrackId;

    public ChunkExtractorWrapper(Extractor extractor, Format manifestFormat, boolean preferManifestDrmInitData, boolean resendFormatOnInit) {
        this.extractor = extractor;
        this.manifestFormat = manifestFormat;
        this.preferManifestDrmInitData = preferManifestDrmInitData;
        this.resendFormatOnInit = resendFormatOnInit;
    }

    public void init(SingleTrackMetadataOutput metadataOutput, TrackOutput trackOutput) {
        this.metadataOutput = metadataOutput;
        this.trackOutput = trackOutput;
        if (!this.extractorInitialized) {
            this.extractor.init(this);
            this.extractorInitialized = true;
        } else {
            this.extractor.seek(0L);
            if (this.resendFormatOnInit && this.sentFormat != null) {
                trackOutput.format(this.sentFormat);
            }
        }
    }

    public int read(ExtractorInput input) throws IOException, InterruptedException {
        int result = this.extractor.read(input, null);
        Assertions.checkState(result != 1);
        return result;
    }

    @Override
    public TrackOutput track(int id) {
        Assertions.checkState(!this.seenTrack || this.seenTrackId == id);
        this.seenTrack = true;
        this.seenTrackId = id;
        return this;
    }

    @Override
    public void endTracks() {
        Assertions.checkState(this.seenTrack);
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.metadataOutput.seekMap(seekMap);
    }

    @Override
    public void format(Format format) {
        this.sentFormat = format.copyWithManifestFormatInfo(this.manifestFormat, this.preferManifestDrmInitData);
        this.trackOutput.format(this.sentFormat);
    }

    @Override
    public int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
        return this.trackOutput.sampleData(input, length, allowEndOfInput);
    }

    @Override
    public void sampleData(ParsableByteArray data, int length) {
        this.trackOutput.sampleData(data, length);
    }

    @Override
    public void sampleMetadata(long timeUs, int flags, int size, int offset, byte[] encryptionKey) {
        this.trackOutput.sampleMetadata(timeUs, flags, size, offset, encryptionKey);
    }

    public static interface SingleTrackMetadataOutput {
        public void seekMap(SeekMap var1);
    }
}

