/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SingleSampleMediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

final class SingleSampleMediaPeriod
implements MediaPeriod,
Loader.Callback<SourceLoadable> {
    private static final int INITIAL_SAMPLE_SIZE = 1024;
    private final Uri uri;
    private final DataSource.Factory dataSourceFactory;
    private final int minLoadableRetryCount;
    private final Handler eventHandler;
    private final SingleSampleMediaSource.EventListener eventListener;
    private final int eventSourceId;
    private final TrackGroupArray tracks;
    private final ArrayList<SampleStreamImpl> sampleStreams;
    final Loader loader;
    final Format format;
    boolean loadingFinished;
    byte[] sampleData;
    int sampleSize;

    public SingleSampleMediaPeriod(Uri uri, DataSource.Factory dataSourceFactory, Format format, int minLoadableRetryCount, Handler eventHandler, SingleSampleMediaSource.EventListener eventListener, int eventSourceId) {
        this.uri = uri;
        this.dataSourceFactory = dataSourceFactory;
        this.format = format;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.eventSourceId = eventSourceId;
        this.tracks = new TrackGroupArray(new TrackGroup(format));
        this.sampleStreams = new ArrayList();
        this.loader = new Loader("Loader:SingleSampleMediaPeriod");
    }

    public void release() {
        this.loader.release();
    }

    @Override
    public void prepare(MediaPeriod.Callback callback) {
        callback.onPrepared(this);
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.loader.maybeThrowError();
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.tracks;
    }

    @Override
    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        for (int i = 0; i < selections.length; ++i) {
            if (!(streams[i] == null || selections[i] != null && mayRetainStreamFlags[i])) {
                this.sampleStreams.remove(streams[i]);
                streams[i] = null;
            }
            if (streams[i] != null || selections[i] == null) continue;
            SampleStreamImpl stream = new SampleStreamImpl();
            this.sampleStreams.add(stream);
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        return positionUs;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        if (this.loadingFinished || this.loader.isLoading()) {
            return false;
        }
        this.loader.startLoading(new SourceLoadable(this.uri, this.dataSourceFactory.createDataSource()), this, this.minLoadableRetryCount);
        return true;
    }

    @Override
    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.loadingFinished || this.loader.isLoading() ? Long.MIN_VALUE : 0L;
    }

    @Override
    public long getBufferedPositionUs() {
        return this.loadingFinished ? Long.MIN_VALUE : 0L;
    }

    @Override
    public long seekToUs(long positionUs) {
        for (int i = 0; i < this.sampleStreams.size(); ++i) {
            this.sampleStreams.get(i).seekToUs(positionUs);
        }
        return positionUs;
    }

    @Override
    public void onLoadCompleted(SourceLoadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.sampleSize = loadable.sampleSize;
        this.sampleData = loadable.sampleData;
        this.loadingFinished = true;
    }

    @Override
    public void onLoadCanceled(SourceLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
    }

    @Override
    public int onLoadError(SourceLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        this.notifyLoadError(error);
        return 0;
    }

    private void notifyLoadError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    SingleSampleMediaPeriod.this.eventListener.onLoadError(SingleSampleMediaPeriod.this.eventSourceId, e);
                }
            });
        }
    }

    static final class SourceLoadable
    implements Loader.Loadable {
        private final Uri uri;
        private final DataSource dataSource;
        private int sampleSize;
        private byte[] sampleData;

        public SourceLoadable(Uri uri, DataSource dataSource) {
            this.uri = uri;
            this.dataSource = dataSource;
        }

        @Override
        public void cancelLoad() {
        }

        @Override
        public boolean isLoadCanceled() {
            return false;
        }

        @Override
        public void load() throws IOException, InterruptedException {
            this.sampleSize = 0;
            try {
                this.dataSource.open(new DataSpec(this.uri));
                int result = 0;
                while (result != -1) {
                    this.sampleSize += result;
                    if (this.sampleData == null) {
                        this.sampleData = new byte[1024];
                    } else if (this.sampleSize == this.sampleData.length) {
                        this.sampleData = Arrays.copyOf(this.sampleData, this.sampleData.length * 2);
                    }
                    result = this.dataSource.read(this.sampleData, this.sampleSize, this.sampleData.length - this.sampleSize);
                }
            }
            finally {
                this.dataSource.close();
            }
        }
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private static final int STREAM_STATE_SEND_FORMAT = 0;
        private static final int STREAM_STATE_SEND_SAMPLE = 1;
        private static final int STREAM_STATE_END_OF_STREAM = 2;
        private int streamState;

        private SampleStreamImpl() {
        }

        public void seekToUs(long positionUs) {
            if (this.streamState == 2) {
                this.streamState = 1;
            }
        }

        @Override
        public boolean isReady() {
            return SingleSampleMediaPeriod.this.loadingFinished;
        }

        @Override
        public void maybeThrowError() throws IOException {
            SingleSampleMediaPeriod.this.loader.maybeThrowError();
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer) {
            if (this.streamState == 2) {
                buffer.addFlag(4);
                return -4;
            }
            if (this.streamState == 0) {
                formatHolder.format = SingleSampleMediaPeriod.this.format;
                this.streamState = 1;
                return -5;
            }
            Assertions.checkState(this.streamState == 1);
            if (!SingleSampleMediaPeriod.this.loadingFinished) {
                return -3;
            }
            buffer.timeUs = 0L;
            buffer.addFlag(1);
            buffer.ensureSpaceForWrite(SingleSampleMediaPeriod.this.sampleSize);
            buffer.data.put(SingleSampleMediaPeriod.this.sampleData, 0, SingleSampleMediaPeriod.this.sampleSize);
            this.streamState = 2;
            return -4;
        }

        @Override
        public void skipToKeyframeBefore(long timeUs) {
        }
    }
}

