/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaPeriod;
import com.google.android.exoplayer2.upstream.Allocator;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public final class MergingMediaSource
implements MediaSource {
    private static final int PERIOD_COUNT_UNSET = -1;
    private final MediaSource[] mediaSources;
    private final ArrayList<MediaSource> pendingTimelineSources;
    private final Timeline.Window window;
    private MediaSource.Listener listener;
    private Timeline primaryTimeline;
    private Object primaryManifest;
    private int periodCount;
    private IllegalMergeException mergeError;

    public MergingMediaSource(MediaSource ... mediaSources) {
        this.mediaSources = mediaSources;
        this.pendingTimelineSources = new ArrayList<MediaSource>(Arrays.asList(mediaSources));
        this.window = new Timeline.Window();
        this.periodCount = -1;
    }

    @Override
    public void prepareSource(MediaSource.Listener listener) {
        this.listener = listener;
        int i = 0;
        while (i < this.mediaSources.length) {
            final int sourceIndex = i++;
            this.mediaSources[sourceIndex].prepareSource(new MediaSource.Listener(){

                @Override
                public void onSourceInfoRefreshed(Timeline timeline, Object manifest) {
                    MergingMediaSource.this.handleSourceInfoRefreshed(sourceIndex, timeline, manifest);
                }
            });
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        if (this.mergeError != null) {
            throw this.mergeError;
        }
        for (MediaSource mediaSource : this.mediaSources) {
            mediaSource.maybeThrowSourceInfoRefreshError();
        }
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        MediaPeriod[] periods = new MediaPeriod[this.mediaSources.length];
        for (int i = 0; i < periods.length; ++i) {
            periods[i] = this.mediaSources[i].createPeriod(index, allocator, positionUs);
        }
        return new MergingMediaPeriod(periods);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MergingMediaPeriod mergingPeriod = (MergingMediaPeriod)mediaPeriod;
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.mediaSources[i].releasePeriod(mergingPeriod.periods[i]);
        }
    }

    @Override
    public void releaseSource() {
        for (MediaSource mediaSource : this.mediaSources) {
            mediaSource.releaseSource();
        }
    }

    private void handleSourceInfoRefreshed(int sourceIndex, Timeline timeline, Object manifest) {
        if (this.mergeError == null) {
            this.mergeError = this.checkTimelineMerges(timeline);
        }
        if (this.mergeError != null) {
            return;
        }
        this.pendingTimelineSources.remove(this.mediaSources[sourceIndex]);
        if (sourceIndex == 0) {
            this.primaryTimeline = timeline;
            this.primaryManifest = manifest;
        }
        if (this.pendingTimelineSources.isEmpty()) {
            this.listener.onSourceInfoRefreshed(this.primaryTimeline, this.primaryManifest);
        }
    }

    private IllegalMergeException checkTimelineMerges(Timeline timeline) {
        int windowCount = timeline.getWindowCount();
        for (int i = 0; i < windowCount; ++i) {
            if (!timeline.getWindow((int)i, (Timeline.Window)this.window, (boolean)false).isDynamic) continue;
            return new IllegalMergeException(0);
        }
        if (this.periodCount == -1) {
            this.periodCount = timeline.getPeriodCount();
        } else if (timeline.getPeriodCount() != this.periodCount) {
            return new IllegalMergeException(1);
        }
        return null;
    }

    public static final class IllegalMergeException
    extends IOException {
        public static final int REASON_WINDOWS_ARE_DYNAMIC = 0;
        public static final int REASON_PERIOD_COUNT_MISMATCH = 1;
        public final int reason;

        public IllegalMergeException(int reason) {
            this.reason = reason;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }
}

