/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.source.CompositeSequenceableLoader;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;

final class MergingMediaPeriod
implements MediaPeriod,
MediaPeriod.Callback {
    public final MediaPeriod[] periods;
    private final IdentityHashMap<SampleStream, Integer> streamPeriodIndices;
    private MediaPeriod.Callback callback;
    private int pendingChildPrepareCount;
    private TrackGroupArray trackGroups;
    private MediaPeriod[] enabledPeriods;
    private SequenceableLoader sequenceableLoader;

    public MergingMediaPeriod(MediaPeriod ... periods) {
        this.periods = periods;
        this.streamPeriodIndices = new IdentityHashMap();
    }

    @Override
    public void prepare(MediaPeriod.Callback callback) {
        this.callback = callback;
        this.pendingChildPrepareCount = this.periods.length;
        for (MediaPeriod period : this.periods) {
            period.prepare(this);
        }
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        for (MediaPeriod period : this.periods) {
            period.maybeThrowPrepareError();
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    @Override
    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamChildIndices = new int[selections.length];
        int[] selectionChildIndices = new int[selections.length];
        block0: for (int i = 0; i < selections.length; ++i) {
            streamChildIndices[i] = streams[i] == null ? -1 : this.streamPeriodIndices.get(streams[i]);
            selectionChildIndices[i] = -1;
            if (selections[i] == null) continue;
            TrackGroup trackGroup = selections[i].getTrackGroup();
            for (int j = 0; j < this.periods.length; ++j) {
                if (this.periods[j].getTrackGroups().indexOf(trackGroup) == -1) continue;
                selectionChildIndices[i] = j;
                continue block0;
            }
        }
        this.streamPeriodIndices.clear();
        SampleStream[] newStreams = new SampleStream[selections.length];
        SampleStream[] childStreams = new SampleStream[selections.length];
        TrackSelection[] childSelections = new TrackSelection[selections.length];
        ArrayList<MediaPeriod> enabledPeriodsList = new ArrayList<MediaPeriod>(this.periods.length);
        for (int i = 0; i < this.periods.length; ++i) {
            for (int j = 0; j < selections.length; ++j) {
                childStreams[j] = streamChildIndices[j] == i ? streams[j] : null;
                childSelections[j] = selectionChildIndices[j] == i ? selections[j] : null;
            }
            long selectPositionUs = this.periods[i].selectTracks(childSelections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs);
            if (i == 0) {
                positionUs = selectPositionUs;
            } else if (selectPositionUs != positionUs) {
                throw new IllegalStateException("Children enabled at different positions");
            }
            boolean periodEnabled = false;
            for (int j = 0; j < selections.length; ++j) {
                if (selectionChildIndices[j] == i) {
                    Assertions.checkState(childStreams[j] != null);
                    newStreams[j] = childStreams[j];
                    periodEnabled = true;
                    this.streamPeriodIndices.put(childStreams[j], i);
                    continue;
                }
                if (streamChildIndices[j] != i) continue;
                Assertions.checkState(childStreams[j] == null);
            }
            if (!periodEnabled) continue;
            enabledPeriodsList.add(this.periods[i]);
        }
        System.arraycopy(newStreams, 0, streams, 0, newStreams.length);
        this.enabledPeriods = new MediaPeriod[enabledPeriodsList.size()];
        enabledPeriodsList.toArray(this.enabledPeriods);
        this.sequenceableLoader = new CompositeSequenceableLoader(this.enabledPeriods);
        return positionUs;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        return this.sequenceableLoader.continueLoading(positionUs);
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.sequenceableLoader.getNextLoadPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        int i;
        long positionUs = this.periods[0].readDiscontinuity();
        for (i = 1; i < this.periods.length; ++i) {
            if (this.periods[i].readDiscontinuity() == -9223372036854775807L) continue;
            throw new IllegalStateException("Child reported discontinuity");
        }
        if (positionUs != -9223372036854775807L) {
            for (i = 0; i < this.enabledPeriods.length; ++i) {
                if (this.enabledPeriods[i] == this.periods[0] || this.enabledPeriods[i].seekToUs(positionUs) == positionUs) continue;
                throw new IllegalStateException("Children seeked to different positions");
            }
        }
        return positionUs;
    }

    @Override
    public long getBufferedPositionUs() {
        long bufferedPositionUs = Long.MAX_VALUE;
        for (MediaPeriod period : this.enabledPeriods) {
            long rendererBufferedPositionUs = period.getBufferedPositionUs();
            if (rendererBufferedPositionUs == Long.MIN_VALUE) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, rendererBufferedPositionUs);
        }
        return bufferedPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : bufferedPositionUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        positionUs = this.enabledPeriods[0].seekToUs(positionUs);
        for (int i = 1; i < this.enabledPeriods.length; ++i) {
            if (this.enabledPeriods[i].seekToUs(positionUs) == positionUs) continue;
            throw new IllegalStateException("Children seeked to different positions");
        }
        return positionUs;
    }

    @Override
    public void onPrepared(MediaPeriod ignored) {
        if (--this.pendingChildPrepareCount > 0) {
            return;
        }
        int totalTrackGroupCount = 0;
        for (MediaPeriod period : this.periods) {
            totalTrackGroupCount += period.getTrackGroups().length;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[totalTrackGroupCount];
        int trackGroupIndex = 0;
        for (MediaPeriod period : this.periods) {
            TrackGroupArray periodTrackGroups = period.getTrackGroups();
            int periodTrackGroupCount = periodTrackGroups.length;
            for (int j = 0; j < periodTrackGroupCount; ++j) {
                trackGroupArray[trackGroupIndex++] = periodTrackGroups.get(j);
            }
        }
        this.trackGroups = new TrackGroupArray(trackGroupArray);
        this.callback.onPrepared(this);
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod ignored) {
        if (this.trackGroups == null) {
            return;
        }
        this.callback.onContinueLoadingRequested(this);
    }
}

