/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;

public final class LoopingMediaSource
implements MediaSource {
    private static final String TAG = "LoopingMediaSource";
    private final MediaSource childSource;
    private final int loopCount;
    private int childPeriodCount;

    public LoopingMediaSource(MediaSource childSource) {
        this(childSource, Integer.MAX_VALUE);
    }

    public LoopingMediaSource(MediaSource childSource, int loopCount) {
        Assertions.checkArgument(loopCount > 0);
        this.childSource = childSource;
        this.loopCount = loopCount;
    }

    @Override
    public void prepareSource(final MediaSource.Listener listener) {
        this.childSource.prepareSource(new MediaSource.Listener(){

            @Override
            public void onSourceInfoRefreshed(Timeline timeline, Object manifest) {
                LoopingMediaSource.this.childPeriodCount = timeline.getPeriodCount();
                listener.onSourceInfoRefreshed(new LoopingTimeline(timeline, LoopingMediaSource.this.loopCount), manifest);
            }
        });
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        this.childSource.maybeThrowSourceInfoRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        return this.childSource.createPeriod(index % this.childPeriodCount, allocator, positionUs);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        this.childSource.releasePeriod(mediaPeriod);
    }

    @Override
    public void releaseSource() {
        this.childSource.releaseSource();
    }

    private static final class LoopingTimeline
    extends Timeline {
        private final Timeline childTimeline;
        private final int childPeriodCount;
        private final int childWindowCount;
        private final int loopCount;

        public LoopingTimeline(Timeline childTimeline, int loopCount) {
            this.childTimeline = childTimeline;
            this.childPeriodCount = childTimeline.getPeriodCount();
            this.childWindowCount = childTimeline.getWindowCount();
            int maxLoopCount = Integer.MAX_VALUE / this.childPeriodCount;
            if (loopCount > maxLoopCount) {
                if (loopCount != Integer.MAX_VALUE) {
                    Log.w((String)LoopingMediaSource.TAG, (String)("Capped loops to avoid overflow: " + loopCount + " -> " + maxLoopCount));
                }
                this.loopCount = maxLoopCount;
            } else {
                this.loopCount = loopCount;
            }
        }

        @Override
        public int getWindowCount() {
            return this.childWindowCount * this.loopCount;
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, boolean setIds) {
            this.childTimeline.getWindow(windowIndex % this.childWindowCount, window, setIds);
            int periodIndexOffset = windowIndex / this.childWindowCount * this.childPeriodCount;
            window.firstPeriodIndex += periodIndexOffset;
            window.lastPeriodIndex += periodIndexOffset;
            return window;
        }

        @Override
        public int getPeriodCount() {
            return this.childPeriodCount * this.loopCount;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            this.childTimeline.getPeriod(periodIndex % this.childPeriodCount, period, setIds);
            int loopCount = periodIndex / this.childPeriodCount;
            period.windowIndex += loopCount * this.childWindowCount;
            if (setIds) {
                period.uid = Pair.create((Object)loopCount, (Object)period.uid);
            }
            return period;
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            if (!(uid instanceof Pair)) {
                return -1;
            }
            Pair loopCountAndChildUid = (Pair)uid;
            if (!(loopCountAndChildUid.first instanceof Integer)) {
                return -1;
            }
            int loopCount = (Integer)loopCountAndChildUid.first;
            int periodIndexOffset = loopCount * this.childPeriodCount;
            return this.childTimeline.getIndexOfPeriod(loopCountAndChildUid.second) + periodIndexOffset;
        }
    }
}

