/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaPeriod;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class ExtractorMediaSource
implements MediaSource,
MediaSource.Listener {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_ON_DEMAND = 3;
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_LIVE = 6;
    public static final int MIN_RETRY_COUNT_DEFAULT_FOR_MEDIA = -1;
    private final Uri uri;
    private final DataSource.Factory dataSourceFactory;
    private final ExtractorsFactory extractorsFactory;
    private final int minLoadableRetryCount;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final Timeline.Period period;
    private MediaSource.Listener sourceListener;
    private Timeline timeline;
    private boolean timelineHasDuration;

    public ExtractorMediaSource(Uri uri, DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory, Handler eventHandler, EventListener eventListener) {
        this(uri, dataSourceFactory, extractorsFactory, -1, eventHandler, eventListener);
    }

    public ExtractorMediaSource(Uri uri, DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory, int minLoadableRetryCount, Handler eventHandler, EventListener eventListener) {
        this.uri = uri;
        this.dataSourceFactory = dataSourceFactory;
        this.extractorsFactory = extractorsFactory;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.period = new Timeline.Period();
    }

    @Override
    public void prepareSource(MediaSource.Listener listener) {
        this.sourceListener = listener;
        this.timeline = new SinglePeriodTimeline(-9223372036854775807L, false);
        listener.onSourceInfoRefreshed(this.timeline, null);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        Assertions.checkArgument(index == 0);
        return new ExtractorMediaPeriod(this.uri, this.dataSourceFactory.createDataSource(), this.extractorsFactory.createExtractors(), this.minLoadableRetryCount, this.eventHandler, this.eventListener, this, allocator);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((ExtractorMediaPeriod)mediaPeriod).release();
    }

    @Override
    public void releaseSource() {
        this.sourceListener = null;
    }

    @Override
    public void onSourceInfoRefreshed(Timeline newTimeline, Object manifest) {
        boolean newTimelineHasDuration;
        long newTimelineDurationUs = newTimeline.getPeriod(0, this.period).getDurationUs();
        boolean bl = newTimelineHasDuration = newTimelineDurationUs != -9223372036854775807L;
        if (this.timelineHasDuration && !newTimelineHasDuration) {
            return;
        }
        this.timeline = newTimeline;
        this.timelineHasDuration = newTimelineHasDuration;
        this.sourceListener.onSourceInfoRefreshed(this.timeline, null);
    }

    public static final class UnrecognizedInputFormatException
    extends ParserException {
        public UnrecognizedInputFormatException(Extractor[] extractors) {
            super("None of the available extractors (" + Util.getCommaDelimitedSimpleClassNames(extractors) + ") could read the stream.");
        }
    }

    public static interface EventListener {
        public void onLoadError(IOException var1);
    }
}

