/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import android.util.SparseArray;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.DefaultTrackOutput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;

final class ExtractorMediaPeriod
implements MediaPeriod,
ExtractorOutput,
Loader.Callback<ExtractingLoadable>,
DefaultTrackOutput.UpstreamFormatChangedListener {
    private static final long DEFAULT_LAST_SAMPLE_DURATION_US = 10000L;
    private final Uri uri;
    private final DataSource dataSource;
    private final int minLoadableRetryCount;
    private final Handler eventHandler;
    private final ExtractorMediaSource.EventListener eventListener;
    private final MediaSource.Listener sourceListener;
    private final Allocator allocator;
    private final Loader loader;
    private final ExtractorHolder extractorHolder;
    private final ConditionVariable loadCondition;
    private final Runnable maybeFinishPrepareRunnable;
    private final Runnable onContinueLoadingRequestedRunnable;
    private final Handler handler;
    private final SparseArray<DefaultTrackOutput> sampleQueues;
    private MediaPeriod.Callback callback;
    private SeekMap seekMap;
    private boolean tracksBuilt;
    private boolean prepared;
    private boolean seenFirstTrackSelection;
    private boolean notifyReset;
    private int enabledTrackCount;
    private TrackGroupArray tracks;
    private long durationUs;
    private boolean[] trackEnabledStates;
    private long length;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private int extractedSamplesCountAtStartOfLoad;
    private boolean loadingFinished;
    private boolean released;

    public ExtractorMediaPeriod(Uri uri, DataSource dataSource, Extractor[] extractors, int minLoadableRetryCount, Handler eventHandler, ExtractorMediaSource.EventListener eventListener, MediaSource.Listener sourceListener, Allocator allocator) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.minLoadableRetryCount = minLoadableRetryCount;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.sourceListener = sourceListener;
        this.allocator = allocator;
        this.loader = new Loader("Loader:ExtractorMediaPeriod");
        this.extractorHolder = new ExtractorHolder(extractors, this);
        this.loadCondition = new ConditionVariable();
        this.maybeFinishPrepareRunnable = new Runnable(){

            @Override
            public void run() {
                ExtractorMediaPeriod.this.maybeFinishPrepare();
            }
        };
        this.onContinueLoadingRequestedRunnable = new Runnable(){

            @Override
            public void run() {
                if (!ExtractorMediaPeriod.this.released) {
                    ExtractorMediaPeriod.this.callback.onContinueLoadingRequested(ExtractorMediaPeriod.this);
                }
            }
        };
        this.handler = new Handler();
        this.pendingResetPositionUs = -9223372036854775807L;
        this.sampleQueues = new SparseArray();
        this.length = -1L;
    }

    public void release() {
        final ExtractorHolder extractorHolder = this.extractorHolder;
        this.loader.release(new Runnable(){

            @Override
            public void run() {
                extractorHolder.release();
                int trackCount = ExtractorMediaPeriod.this.sampleQueues.size();
                for (int i = 0; i < trackCount; ++i) {
                    ((DefaultTrackOutput)ExtractorMediaPeriod.this.sampleQueues.valueAt(i)).disable();
                }
            }
        });
        this.handler.removeCallbacksAndMessages(null);
        this.released = true;
    }

    @Override
    public void prepare(MediaPeriod.Callback callback) {
        this.callback = callback;
        this.loadCondition.open();
        this.startLoading();
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.tracks;
    }

    @Override
    public long selectTracks(TrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        Assertions.checkState(this.prepared);
        for (int i2 = 0; i2 < selections.length; ++i2) {
            if (streams[i2] == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            int track = ((SampleStreamImpl)streams[i2]).track;
            Assertions.checkState(this.trackEnabledStates[track]);
            --this.enabledTrackCount;
            this.trackEnabledStates[track] = false;
            ((DefaultTrackOutput)this.sampleQueues.valueAt(track)).disable();
            streams[i2] = null;
        }
        boolean selectedNewTracks = false;
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            TrackSelection selection = selections[i];
            Assertions.checkState(selection.length() == 1);
            Assertions.checkState(selection.getIndexInTrackGroup(0) == 0);
            int track = this.tracks.indexOf(selection.getTrackGroup());
            Assertions.checkState(!this.trackEnabledStates[track]);
            ++this.enabledTrackCount;
            this.trackEnabledStates[track] = true;
            streams[i] = new SampleStreamImpl(track);
            streamResetFlags[i] = true;
            selectedNewTracks = true;
        }
        if (!this.seenFirstTrackSelection) {
            int trackCount = this.sampleQueues.size();
            for (int i3 = 0; i3 < trackCount; ++i3) {
                if (this.trackEnabledStates[i3]) continue;
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i3)).disable();
            }
        }
        if (this.enabledTrackCount == 0) {
            this.notifyReset = false;
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            }
        } else if (this.seenFirstTrackSelection ? selectedNewTracks : positionUs != 0L) {
            positionUs = this.seekToUs(positionUs);
            for (i = 0; i < streams.length; ++i) {
                if (streams[i] == null) continue;
                streamResetFlags[i] = true;
            }
        }
        this.seenFirstTrackSelection = true;
        return positionUs;
    }

    @Override
    public boolean continueLoading(long playbackPositionUs) {
        if (this.loadingFinished) {
            return false;
        }
        boolean continuedLoading = this.loadCondition.open();
        if (!this.loader.isLoading()) {
            this.startLoading();
            continuedLoading = true;
        }
        return continuedLoading;
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.getBufferedPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        if (this.notifyReset) {
            this.notifyReset = false;
            return this.lastSeekPositionUs;
        }
        return -9223372036854775807L;
    }

    @Override
    public long getBufferedPositionUs() {
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long largestQueuedTimestampUs = this.getLargestQueuedTimestampUs();
        return largestQueuedTimestampUs == Long.MIN_VALUE ? this.lastSeekPositionUs : largestQueuedTimestampUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        int i;
        this.lastSeekPositionUs = positionUs = this.seekMap.isSeekable() ? positionUs : 0L;
        int trackCount = this.sampleQueues.size();
        boolean seekInsideBuffer = !this.isPendingReset();
        for (i = 0; seekInsideBuffer && i < trackCount; ++i) {
            if (!this.trackEnabledStates[i]) continue;
            seekInsideBuffer = ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).skipToKeyframeBefore(positionUs);
        }
        if (!seekInsideBuffer) {
            this.pendingResetPositionUs = positionUs;
            this.loadingFinished = false;
            if (this.loader.isLoading()) {
                this.loader.cancelLoading();
            } else {
                for (i = 0; i < trackCount; ++i) {
                    ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).reset(this.trackEnabledStates[i]);
                }
            }
        }
        this.notifyReset = false;
        return positionUs;
    }

    boolean isReady(int track) {
        return this.loadingFinished || !this.isPendingReset() && !((DefaultTrackOutput)this.sampleQueues.valueAt(track)).isEmpty();
    }

    void maybeThrowError() throws IOException {
        this.loader.maybeThrowError();
    }

    int readData(int track, FormatHolder formatHolder, DecoderInputBuffer buffer) {
        if (this.notifyReset || this.isPendingReset()) {
            return -3;
        }
        return ((DefaultTrackOutput)this.sampleQueues.valueAt(track)).readData(formatHolder, buffer, this.loadingFinished, this.lastSeekPositionUs);
    }

    @Override
    public void onLoadCompleted(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
        this.copyLengthFromLoader(loadable);
        this.loadingFinished = true;
        if (this.durationUs == -9223372036854775807L) {
            long largestQueuedTimestampUs = this.getLargestQueuedTimestampUs();
            this.durationUs = largestQueuedTimestampUs == Long.MIN_VALUE ? 0L : largestQueuedTimestampUs + 10000L;
            this.sourceListener.onSourceInfoRefreshed(new SinglePeriodTimeline(this.durationUs, this.seekMap.isSeekable()), null);
        }
    }

    @Override
    public void onLoadCanceled(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        this.copyLengthFromLoader(loadable);
        if (!released && this.enabledTrackCount > 0) {
            int trackCount = this.sampleQueues.size();
            for (int i = 0; i < trackCount; ++i) {
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).reset(this.trackEnabledStates[i]);
            }
            this.callback.onContinueLoadingRequested(this);
        }
    }

    @Override
    public int onLoadError(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error) {
        this.copyLengthFromLoader(loadable);
        this.notifyLoadError(error);
        if (this.isLoadableExceptionFatal(error)) {
            return 3;
        }
        int extractedSamplesCount = this.getExtractedSamplesCount();
        boolean madeProgress = extractedSamplesCount > this.extractedSamplesCountAtStartOfLoad;
        this.configureRetry(loadable);
        this.extractedSamplesCountAtStartOfLoad = this.getExtractedSamplesCount();
        return madeProgress ? 1 : 0;
    }

    @Override
    public TrackOutput track(int id) {
        DefaultTrackOutput trackOutput = (DefaultTrackOutput)this.sampleQueues.get(id);
        if (trackOutput == null) {
            trackOutput = new DefaultTrackOutput(this.allocator);
            trackOutput.setUpstreamFormatChangeListener(this);
            this.sampleQueues.put(id, (Object)trackOutput);
        }
        return trackOutput;
    }

    @Override
    public void endTracks() {
        this.tracksBuilt = true;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    @Override
    public void seekMap(SeekMap seekMap) {
        this.seekMap = seekMap;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    @Override
    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    private void maybeFinishPrepare() {
        if (this.released || this.prepared || this.seekMap == null || !this.tracksBuilt) {
            return;
        }
        int trackCount = this.sampleQueues.size();
        for (int i = 0; i < trackCount; ++i) {
            if (((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getUpstreamFormat() != null) continue;
            return;
        }
        this.loadCondition.close();
        TrackGroup[] trackArray = new TrackGroup[trackCount];
        this.trackEnabledStates = new boolean[trackCount];
        this.durationUs = this.seekMap.getDurationUs();
        for (int i = 0; i < trackCount; ++i) {
            trackArray[i] = new TrackGroup(((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getUpstreamFormat());
        }
        this.tracks = new TrackGroupArray(trackArray);
        this.prepared = true;
        this.sourceListener.onSourceInfoRefreshed(new SinglePeriodTimeline(this.durationUs, this.seekMap.isSeekable()), null);
        this.callback.onPrepared(this);
    }

    private void copyLengthFromLoader(ExtractingLoadable loadable) {
        if (this.length == -1L) {
            this.length = loadable.length;
        }
    }

    private void startLoading() {
        ExtractingLoadable loadable = new ExtractingLoadable(this.uri, this.dataSource, this.extractorHolder, this.loadCondition);
        if (this.prepared) {
            Assertions.checkState(this.isPendingReset());
            if (this.durationUs != -9223372036854775807L && this.pendingResetPositionUs >= this.durationUs) {
                this.loadingFinished = true;
                this.pendingResetPositionUs = -9223372036854775807L;
                return;
            }
            loadable.setLoadPosition(this.seekMap.getPosition(this.pendingResetPositionUs));
            this.pendingResetPositionUs = -9223372036854775807L;
        }
        this.extractedSamplesCountAtStartOfLoad = this.getExtractedSamplesCount();
        int minRetryCount = this.minLoadableRetryCount;
        if (minRetryCount == -1) {
            minRetryCount = !this.prepared || this.length != -1L || this.seekMap != null && this.seekMap.getDurationUs() != -9223372036854775807L ? 3 : 6;
        }
        this.loader.startLoading(loadable, this, minRetryCount);
    }

    private void configureRetry(ExtractingLoadable loadable) {
        if (this.length == -1L && (this.seekMap == null || this.seekMap.getDurationUs() == -9223372036854775807L)) {
            this.lastSeekPositionUs = 0L;
            this.notifyReset = this.prepared;
            int trackCount = this.sampleQueues.size();
            for (int i = 0; i < trackCount; ++i) {
                ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).reset(!this.prepared || this.trackEnabledStates[i]);
            }
            loadable.setLoadPosition(0L);
        }
    }

    private int getExtractedSamplesCount() {
        int extractedSamplesCount = 0;
        int trackCount = this.sampleQueues.size();
        for (int i = 0; i < trackCount; ++i) {
            extractedSamplesCount += ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getWriteIndex();
        }
        return extractedSamplesCount;
    }

    private long getLargestQueuedTimestampUs() {
        long largestQueuedTimestampUs = Long.MIN_VALUE;
        int trackCount = this.sampleQueues.size();
        for (int i = 0; i < trackCount; ++i) {
            largestQueuedTimestampUs = Math.max(largestQueuedTimestampUs, ((DefaultTrackOutput)this.sampleQueues.valueAt(i)).getLargestQueuedTimestampUs());
        }
        return largestQueuedTimestampUs;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    private boolean isLoadableExceptionFatal(IOException e) {
        return e instanceof ExtractorMediaSource.UnrecognizedInputFormatException;
    }

    private void notifyLoadError(final IOException error) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ExtractorMediaPeriod.this.eventListener.onLoadError(error);
                }
            });
        }
    }

    private static final class ExtractorHolder {
        private final Extractor[] extractors;
        private final ExtractorOutput extractorOutput;
        private Extractor extractor;

        public ExtractorHolder(Extractor[] extractors, ExtractorOutput extractorOutput) {
            this.extractors = extractors;
            this.extractorOutput = extractorOutput;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Extractor selectExtractor(ExtractorInput input) throws IOException, InterruptedException {
            if (this.extractor != null) {
                return this.extractor;
            }
            for (Extractor extractor : this.extractors) {
                try {
                    if (!extractor.sniff(input)) continue;
                    this.extractor = extractor;
                    break;
                }
                catch (EOFException eOFException) {
                }
                finally {
                    input.resetPeekPosition();
                }
            }
            if (this.extractor == null) {
                throw new ExtractorMediaSource.UnrecognizedInputFormatException(this.extractors);
            }
            this.extractor.init(this.extractorOutput);
            return this.extractor;
        }

        public void release() {
            if (this.extractor != null) {
                this.extractor.release();
                this.extractor = null;
            }
        }
    }

    final class ExtractingLoadable
    implements Loader.Loadable {
        private static final int CONTINUE_LOADING_CHECK_INTERVAL_BYTES = 0x100000;
        private final Uri uri;
        private final DataSource dataSource;
        private final ExtractorHolder extractorHolder;
        private final ConditionVariable loadCondition;
        private final PositionHolder positionHolder;
        private volatile boolean loadCanceled;
        private boolean pendingExtractorSeek;
        private long length;

        public ExtractingLoadable(Uri uri, DataSource dataSource, ExtractorHolder extractorHolder, ConditionVariable loadCondition) {
            this.uri = Assertions.checkNotNull(uri);
            this.dataSource = Assertions.checkNotNull(dataSource);
            this.extractorHolder = Assertions.checkNotNull(extractorHolder);
            this.loadCondition = loadCondition;
            this.positionHolder = new PositionHolder();
            this.pendingExtractorSeek = true;
            this.length = -1L;
        }

        public void setLoadPosition(long position) {
            this.positionHolder.position = position;
            this.pendingExtractorSeek = true;
        }

        @Override
        public void cancelLoad() {
            this.loadCanceled = true;
        }

        @Override
        public boolean isLoadCanceled() {
            return this.loadCanceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException, InterruptedException {
            int result = 0;
            while (result == 0 && !this.loadCanceled) {
                ExtractorInput input = null;
                try {
                    long position = this.positionHolder.position;
                    this.length = this.dataSource.open(new DataSpec(this.uri, position, -1L, Util.sha1(this.uri.toString())));
                    if (this.length != -1L) {
                        this.length += position;
                    }
                    input = new DefaultExtractorInput(this.dataSource, position, this.length);
                    Extractor extractor = this.extractorHolder.selectExtractor(input);
                    if (this.pendingExtractorSeek) {
                        extractor.seek(position);
                        this.pendingExtractorSeek = false;
                    }
                    while (result == 0 && !this.loadCanceled) {
                        this.loadCondition.block();
                        result = extractor.read(input, this.positionHolder);
                        if (input.getPosition() <= position + 0x100000L) continue;
                        position = input.getPosition();
                        this.loadCondition.close();
                        ExtractorMediaPeriod.this.handler.post(ExtractorMediaPeriod.this.onContinueLoadingRequestedRunnable);
                    }
                }
                finally {
                    if (result == 1) {
                        result = 0;
                    } else if (input != null) {
                        this.positionHolder.position = input.getPosition();
                    }
                    this.dataSource.close();
                }
            }
        }
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private final int track;

        public SampleStreamImpl(int track) {
            this.track = track;
        }

        @Override
        public boolean isReady() {
            return ExtractorMediaPeriod.this.isReady(this.track);
        }

        @Override
        public void maybeThrowError() throws IOException {
            ExtractorMediaPeriod.this.maybeThrowError();
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer) {
            return ExtractorMediaPeriod.this.readData(this.track, formatHolder, buffer);
        }

        @Override
        public void skipToKeyframeBefore(long timeUs) {
            ((DefaultTrackOutput)ExtractorMediaPeriod.this.sampleQueues.valueAt(this.track)).skipToKeyframeBefore(timeUs);
        }
    }
}

