/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.util.Pair;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ConcatenatingMediaSource
implements MediaSource {
    private final MediaSource[] mediaSources;
    private final Timeline[] timelines;
    private final Object[] manifests;
    private final Map<MediaPeriod, Integer> sourceIndexByMediaPeriod;
    private final boolean[] duplicateFlags;
    private MediaSource.Listener listener;
    private ConcatenatedTimeline timeline;

    public ConcatenatingMediaSource(MediaSource ... mediaSources) {
        this.mediaSources = mediaSources;
        this.timelines = new Timeline[mediaSources.length];
        this.manifests = new Object[mediaSources.length];
        this.sourceIndexByMediaPeriod = new HashMap<MediaPeriod, Integer>();
        this.duplicateFlags = ConcatenatingMediaSource.buildDuplicateFlags(mediaSources);
    }

    @Override
    public void prepareSource(MediaSource.Listener listener) {
        this.listener = listener;
        for (int i = 0; i < this.mediaSources.length; ++i) {
            if (this.duplicateFlags[i]) continue;
            final int index = i;
            this.mediaSources[i].prepareSource(new MediaSource.Listener(){

                @Override
                public void onSourceInfoRefreshed(Timeline timeline, Object manifest) {
                    ConcatenatingMediaSource.this.handleSourceInfoRefreshed(index, timeline, manifest);
                }
            });
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        for (int i = 0; i < this.mediaSources.length; ++i) {
            if (this.duplicateFlags[i]) continue;
            this.mediaSources[i].maybeThrowSourceInfoRefreshError();
        }
    }

    @Override
    public MediaPeriod createPeriod(int index, Allocator allocator, long positionUs) {
        int sourceIndex = this.timeline.getSourceIndexForPeriod(index);
        int periodIndexInSource = index - this.timeline.getFirstPeriodIndexInSource(sourceIndex);
        MediaPeriod mediaPeriod = this.mediaSources[sourceIndex].createPeriod(periodIndexInSource, allocator, positionUs);
        this.sourceIndexByMediaPeriod.put(mediaPeriod, sourceIndex);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        int sourceIndex = this.sourceIndexByMediaPeriod.get(mediaPeriod);
        this.sourceIndexByMediaPeriod.remove(mediaPeriod);
        this.mediaSources[sourceIndex].releasePeriod(mediaPeriod);
    }

    @Override
    public void releaseSource() {
        for (int i = 0; i < this.mediaSources.length; ++i) {
            if (this.duplicateFlags[i]) continue;
            this.mediaSources[i].releaseSource();
        }
    }

    private void handleSourceInfoRefreshed(int sourceFirstIndex, Timeline sourceTimeline, Object sourceManifest) {
        this.timelines[sourceFirstIndex] = sourceTimeline;
        this.manifests[sourceFirstIndex] = sourceManifest;
        for (int i = sourceFirstIndex + 1; i < this.mediaSources.length; ++i) {
            if (this.mediaSources[i] != this.mediaSources[sourceFirstIndex]) continue;
            this.timelines[i] = sourceTimeline;
            this.manifests[i] = sourceManifest;
        }
        for (Timeline timeline : this.timelines) {
            if (timeline != null) continue;
            return;
        }
        this.timeline = new ConcatenatedTimeline((Timeline[])this.timelines.clone());
        this.listener.onSourceInfoRefreshed(this.timeline, this.manifests.clone());
    }

    private static boolean[] buildDuplicateFlags(MediaSource[] mediaSources) {
        boolean[] duplicateFlags = new boolean[mediaSources.length];
        IdentityHashMap sources = new IdentityHashMap(mediaSources.length);
        for (int i = 0; i < mediaSources.length; ++i) {
            MediaSource source = mediaSources[i];
            if (!sources.containsKey(source)) {
                sources.put(source, null);
                continue;
            }
            duplicateFlags[i] = true;
        }
        return duplicateFlags;
    }

    private static final class ConcatenatedTimeline
    extends Timeline {
        private final Timeline[] timelines;
        private final int[] sourcePeriodOffsets;
        private final int[] sourceWindowOffsets;

        public ConcatenatedTimeline(Timeline[] timelines) {
            int[] sourcePeriodOffsets = new int[timelines.length];
            int[] sourceWindowOffsets = new int[timelines.length];
            int periodCount = 0;
            int windowCount = 0;
            for (int i = 0; i < timelines.length; ++i) {
                Timeline timeline = timelines[i];
                sourcePeriodOffsets[i] = periodCount += timeline.getPeriodCount();
                sourceWindowOffsets[i] = windowCount += timeline.getWindowCount();
            }
            this.timelines = timelines;
            this.sourcePeriodOffsets = sourcePeriodOffsets;
            this.sourceWindowOffsets = sourceWindowOffsets;
        }

        @Override
        public int getWindowCount() {
            return this.sourceWindowOffsets[this.sourceWindowOffsets.length - 1];
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, boolean setIds) {
            int sourceIndex = this.getSourceIndexForWindow(windowIndex);
            int firstWindowIndexInSource = this.getFirstWindowIndexInSource(sourceIndex);
            int firstPeriodIndexInSource = this.getFirstPeriodIndexInSource(sourceIndex);
            this.timelines[sourceIndex].getWindow(windowIndex - firstWindowIndexInSource, window, setIds);
            window.firstPeriodIndex += firstPeriodIndexInSource;
            window.lastPeriodIndex += firstPeriodIndexInSource;
            return window;
        }

        @Override
        public int getPeriodCount() {
            return this.sourcePeriodOffsets[this.sourcePeriodOffsets.length - 1];
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            int sourceIndex = this.getSourceIndexForPeriod(periodIndex);
            int firstWindowIndexInSource = this.getFirstWindowIndexInSource(sourceIndex);
            int firstPeriodIndexInSource = this.getFirstPeriodIndexInSource(sourceIndex);
            this.timelines[sourceIndex].getPeriod(periodIndex - firstPeriodIndexInSource, period, setIds);
            period.windowIndex += firstWindowIndexInSource;
            if (setIds) {
                period.uid = Pair.create((Object)sourceIndex, (Object)period.uid);
            }
            return period;
        }

        @Override
        public int getIndexOfPeriod(Object uid) {
            if (!(uid instanceof Pair)) {
                return -1;
            }
            Pair sourceIndexAndPeriodId = (Pair)uid;
            if (!(sourceIndexAndPeriodId.first instanceof Integer)) {
                return -1;
            }
            int sourceIndex = (Integer)sourceIndexAndPeriodId.first;
            Object periodId = sourceIndexAndPeriodId.second;
            if (sourceIndex < 0 || sourceIndex >= this.timelines.length) {
                return -1;
            }
            int periodIndexInSource = this.timelines[sourceIndex].getIndexOfPeriod(periodId);
            return periodIndexInSource == -1 ? -1 : this.getFirstPeriodIndexInSource(sourceIndex) + periodIndexInSource;
        }

        private int getSourceIndexForPeriod(int periodIndex) {
            return Util.binarySearchFloor(this.sourcePeriodOffsets, periodIndex, true, false) + 1;
        }

        private int getFirstPeriodIndexInSource(int sourceIndex) {
            return sourceIndex == 0 ? 0 : this.sourcePeriodOffsets[sourceIndex - 1];
        }

        private int getSourceIndexForWindow(int windowIndex) {
            return Util.binarySearchFloor(this.sourceWindowOffsets, windowIndex, true, false) + 1;
        }

        private int getFirstWindowIndexInSource(int sourceIndex) {
            return sourceIndex == 0 ? 0 : this.sourceWindowOffsets[sourceIndex - 1];
        }
    }
}

