/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import com.google.android.exoplayer2.source.SequenceableLoader;

public final class CompositeSequenceableLoader
implements SequenceableLoader {
    private final SequenceableLoader[] loaders;

    public CompositeSequenceableLoader(SequenceableLoader[] loaders) {
        this.loaders = loaders;
    }

    @Override
    public long getNextLoadPositionUs() {
        long nextLoadPositionUs = Long.MAX_VALUE;
        for (SequenceableLoader loader : this.loaders) {
            long loaderNextLoadPositionUs = loader.getNextLoadPositionUs();
            if (loaderNextLoadPositionUs == Long.MIN_VALUE) continue;
            nextLoadPositionUs = Math.min(nextLoadPositionUs, loaderNextLoadPositionUs);
        }
        return nextLoadPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : nextLoadPositionUs;
    }

    @Override
    public boolean continueLoading(long positionUs) {
        boolean madeProgressThisIteration;
        boolean madeProgress = false;
        do {
            madeProgressThisIteration = false;
            long nextLoadPositionUs = this.getNextLoadPositionUs();
            if (nextLoadPositionUs == Long.MIN_VALUE) break;
            for (SequenceableLoader loader : this.loaders) {
                if (loader.getNextLoadPositionUs() != nextLoadPositionUs) continue;
                madeProgressThisIteration |= loader.continueLoading(positionUs);
            }
            madeProgress |= madeProgressThisIteration;
        } while (madeProgressThisIteration);
        return madeProgress;
    }
}

