/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Handler;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;

public interface AdaptiveMediaSourceEventListener {
    public void onLoadStarted(DataSpec var1, int var2, int var3, Format var4, int var5, Object var6, long var7, long var9, long var11);

    public void onLoadCompleted(DataSpec var1, int var2, int var3, Format var4, int var5, Object var6, long var7, long var9, long var11, long var13, long var15);

    public void onLoadCanceled(DataSpec var1, int var2, int var3, Format var4, int var5, Object var6, long var7, long var9, long var11, long var13, long var15);

    public void onLoadError(DataSpec var1, int var2, int var3, Format var4, int var5, Object var6, long var7, long var9, long var11, long var13, long var15, IOException var17, boolean var18);

    public void onUpstreamDiscarded(int var1, long var2, long var4);

    public void onDownstreamFormatChanged(int var1, Format var2, int var3, Object var4, long var5);

    public static final class EventDispatcher {
        private final Handler handler;
        private final AdaptiveMediaSourceEventListener listener;

        public EventDispatcher(Handler handler, AdaptiveMediaSourceEventListener listener) {
            this.handler = listener != null ? Assertions.checkNotNull(handler) : null;
            this.listener = listener;
        }

        public void loadStarted(DataSpec dataSpec, int dataType, long elapsedRealtimeMs) {
            this.loadStarted(dataSpec, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L, elapsedRealtimeMs);
        }

        public void loadStarted(final DataSpec dataSpec, final int dataType, final int trackType, final Format trackFormat, final int trackSelectionReason, final Object trackSelectionData, final long mediaStartTimeUs, final long mediaEndTimeUs, final long elapsedRealtimeMs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onLoadStarted(dataSpec, dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, C.usToMs(mediaStartTimeUs), C.usToMs(mediaEndTimeUs), elapsedRealtimeMs);
                    }
                });
            }
        }

        public void loadCompleted(DataSpec dataSpec, int dataType, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
            this.loadCompleted(dataSpec, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L, elapsedRealtimeMs, loadDurationMs, bytesLoaded);
        }

        public void loadCompleted(final DataSpec dataSpec, final int dataType, final int trackType, final Format trackFormat, final int trackSelectionReason, final Object trackSelectionData, final long mediaStartTimeUs, final long mediaEndTimeUs, final long elapsedRealtimeMs, final long loadDurationMs, final long bytesLoaded) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onLoadCompleted(dataSpec, dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, C.usToMs(mediaStartTimeUs), C.usToMs(mediaEndTimeUs), elapsedRealtimeMs, loadDurationMs, bytesLoaded);
                    }
                });
            }
        }

        public void loadCanceled(DataSpec dataSpec, int dataType, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded) {
            this.loadCanceled(dataSpec, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L, elapsedRealtimeMs, loadDurationMs, bytesLoaded);
        }

        public void loadCanceled(final DataSpec dataSpec, final int dataType, final int trackType, final Format trackFormat, final int trackSelectionReason, final Object trackSelectionData, final long mediaStartTimeUs, final long mediaEndTimeUs, final long elapsedRealtimeMs, final long loadDurationMs, final long bytesLoaded) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onLoadCanceled(dataSpec, dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, C.usToMs(mediaStartTimeUs), C.usToMs(mediaEndTimeUs), elapsedRealtimeMs, loadDurationMs, bytesLoaded);
                    }
                });
            }
        }

        public void loadError(DataSpec dataSpec, int dataType, long elapsedRealtimeMs, long loadDurationMs, long bytesLoaded, IOException error, boolean wasCanceled) {
            this.loadError(dataSpec, dataType, -1, null, 0, null, -9223372036854775807L, -9223372036854775807L, elapsedRealtimeMs, loadDurationMs, bytesLoaded, error, wasCanceled);
        }

        public void loadError(final DataSpec dataSpec, final int dataType, final int trackType, final Format trackFormat, final int trackSelectionReason, final Object trackSelectionData, final long mediaStartTimeUs, final long mediaEndTimeUs, final long elapsedRealtimeMs, final long loadDurationMs, final long bytesLoaded, final IOException error, final boolean wasCanceled) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onLoadError(dataSpec, dataType, trackType, trackFormat, trackSelectionReason, trackSelectionData, C.usToMs(mediaStartTimeUs), C.usToMs(mediaEndTimeUs), elapsedRealtimeMs, loadDurationMs, bytesLoaded, error, wasCanceled);
                    }
                });
            }
        }

        public void upstreamDiscarded(final int trackType, final long mediaStartTimeUs, final long mediaEndTimeUs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onUpstreamDiscarded(trackType, C.usToMs(mediaStartTimeUs), C.usToMs(mediaEndTimeUs));
                    }
                });
            }
        }

        public void downstreamFormatChanged(final int trackType, final Format trackFormat, final int trackSelectionReason, final Object trackSelectionData, final long mediaTimeUs) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        EventDispatcher.this.listener.onDownstreamFormatChanged(trackType, trackFormat, trackSelectionReason, trackSelectionData, C.usToMs(mediaTimeUs));
                    }
                });
            }
        }
    }
}

