/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.metadata.MetadataDecoder;
import com.google.android.exoplayer2.metadata.MetadataDecoderException;
import com.google.android.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;

public final class MetadataRenderer<T>
extends BaseRenderer
implements Handler.Callback {
    private static final int MSG_INVOKE_RENDERER = 0;
    private final MetadataDecoder<T> metadataDecoder;
    private final Output<T> output;
    private final Handler outputHandler;
    private final FormatHolder formatHolder;
    private final DecoderInputBuffer buffer;
    private boolean inputStreamEnded;
    private long pendingMetadataTimestamp;
    private T pendingMetadata;

    public MetadataRenderer(Output<T> output, Looper outputLooper, MetadataDecoder<T> metadataDecoder) {
        super(4);
        this.output = Assertions.checkNotNull(output);
        this.outputHandler = outputLooper == null ? null : new Handler(outputLooper, (Handler.Callback)this);
        this.metadataDecoder = Assertions.checkNotNull(metadataDecoder);
        this.formatHolder = new FormatHolder();
        this.buffer = new DecoderInputBuffer(1);
    }

    @Override
    public int supportsFormat(Format format) {
        return this.metadataDecoder.canDecode(format.sampleMimeType) ? 3 : 0;
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) {
        this.pendingMetadata = null;
        this.inputStreamEnded = false;
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (!this.inputStreamEnded && this.pendingMetadata == null) {
            this.buffer.clear();
            int result = this.readSource(this.formatHolder, this.buffer);
            if (result == -4) {
                if (this.buffer.isEndOfStream()) {
                    this.inputStreamEnded = true;
                } else {
                    this.pendingMetadataTimestamp = this.buffer.timeUs;
                    try {
                        this.buffer.flip();
                        ByteBuffer bufferData = this.buffer.data;
                        this.pendingMetadata = this.metadataDecoder.decode(bufferData.array(), bufferData.limit());
                    }
                    catch (MetadataDecoderException e) {
                        throw ExoPlaybackException.createForRenderer(e, this.getIndex());
                    }
                }
            }
        }
        if (this.pendingMetadata != null && this.pendingMetadataTimestamp <= positionUs) {
            this.invokeRenderer(this.pendingMetadata);
            this.pendingMetadata = null;
        }
    }

    @Override
    protected void onDisabled() {
        this.pendingMetadata = null;
        super.onDisabled();
    }

    @Override
    public boolean isEnded() {
        return this.inputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void invokeRenderer(T metadata) {
        if (this.outputHandler != null) {
            this.outputHandler.obtainMessage(0, metadata).sendToTarget();
        } else {
            this.invokeRendererInternal(metadata);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeRendererInternal(msg.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeRendererInternal(T metadata) {
        this.output.onMetadata(metadata);
    }

    public static interface Output<T> {
        public void onMetadata(T var1);
    }
}

