/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TargetApi(value=16)
@SuppressLint(value={"InlinedApi"})
public final class MediaCodecUtil {
    private static final String TAG = "MediaCodecUtil";
    private static final MediaCodecInfo PASSTHROUGH_DECODER_INFO = MediaCodecInfo.newPassthroughInstance("OMX.google.raw.decoder");
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^\\D?(\\d+)$");
    private static final HashMap<CodecKey, List<MediaCodecInfo>> decoderInfosCache = new HashMap();
    private static final Map<Integer, Integer> AVC_PROFILE_NUMBER_TO_CONST;
    private static final Map<Integer, Integer> AVC_LEVEL_NUMBER_TO_CONST;
    private static final String CODEC_ID_AVC1 = "avc1";
    private static final String CODEC_ID_AVC2 = "avc2";
    private static final Map<String, Integer> HEVC_CODEC_STRING_TO_PROFILE_LEVEL;
    private static final String CODEC_ID_HEV1 = "hev1";
    private static final String CODEC_ID_HVC1 = "hvc1";
    private static int maxH264DecodableFrameSize;

    private MediaCodecUtil() {
    }

    public static void warmDecoderInfoCache(String mimeType, boolean secure) {
        try {
            MediaCodecUtil.getDecoderInfos(mimeType, secure);
        }
        catch (DecoderQueryException e) {
            Log.e((String)TAG, (String)"Codec warming failed", (Throwable)e);
        }
    }

    public static MediaCodecInfo getPassthroughDecoderInfo() {
        return PASSTHROUGH_DECODER_INFO;
    }

    public static MediaCodecInfo getDecoderInfo(String mimeType, boolean secure) throws DecoderQueryException {
        List<MediaCodecInfo> decoderInfos = MediaCodecUtil.getDecoderInfos(mimeType, secure);
        return decoderInfos.isEmpty() ? null : decoderInfos.get(0);
    }

    public static synchronized List<MediaCodecInfo> getDecoderInfos(String mimeType, boolean secure) throws DecoderQueryException {
        CodecKey key = new CodecKey(mimeType, secure);
        List<MediaCodecInfo> decoderInfos = decoderInfosCache.get(key);
        if (decoderInfos != null) {
            return decoderInfos;
        }
        MediaCodecListCompat mediaCodecList = Util.SDK_INT >= 21 ? new MediaCodecListCompatV21(secure) : new MediaCodecListCompatV16();
        decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList);
        if (secure && decoderInfos.isEmpty() && 21 <= Util.SDK_INT && Util.SDK_INT <= 23 && !(decoderInfos = MediaCodecUtil.getDecoderInfosInternal(key, mediaCodecList = new MediaCodecListCompatV16())).isEmpty()) {
            Log.w((String)TAG, (String)("MediaCodecList API didn't list secure decoder for: " + mimeType + ". Assuming: " + decoderInfos.get((int)0).name));
        }
        decoderInfos = Collections.unmodifiableList(decoderInfos);
        decoderInfosCache.put(key, decoderInfos);
        return decoderInfos;
    }

    private static List<MediaCodecInfo> getDecoderInfosInternal(CodecKey key, MediaCodecListCompat mediaCodecList) throws DecoderQueryException {
        try {
            ArrayList<MediaCodecInfo> decoderInfos = new ArrayList<MediaCodecInfo>();
            String mimeType = key.mimeType;
            int numberOfCodecs = mediaCodecList.getCodecCount();
            boolean secureDecodersExplicit = mediaCodecList.secureDecodersExplicit();
            for (int i = 0; i < numberOfCodecs; ++i) {
                String codecName;
                android.media.MediaCodecInfo codecInfo = mediaCodecList.getCodecInfoAt(i);
                if (!MediaCodecUtil.isCodecUsableDecoder(codecInfo, codecName = codecInfo.getName(), secureDecodersExplicit)) continue;
                for (String supportedType : codecInfo.getSupportedTypes()) {
                    if (!supportedType.equalsIgnoreCase(mimeType)) continue;
                    try {
                        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(supportedType);
                        boolean secure = mediaCodecList.isSecurePlaybackSupported(mimeType, capabilities);
                        if (secureDecodersExplicit && key.secure == secure || !secureDecodersExplicit && !key.secure) {
                            decoderInfos.add(MediaCodecInfo.newInstance(codecName, mimeType, capabilities));
                            continue;
                        }
                        if (secureDecodersExplicit || !secure) continue;
                        decoderInfos.add(MediaCodecInfo.newInstance(codecName + ".secure", mimeType, capabilities));
                        return decoderInfos;
                    }
                    catch (Exception e) {
                        if (Util.SDK_INT <= 23 && !decoderInfos.isEmpty()) {
                            Log.e((String)TAG, (String)("Skipping codec " + codecName + " (failed to query capabilities)"));
                            continue;
                        }
                        Log.e((String)TAG, (String)("Failed to query codec " + codecName + " (" + supportedType + ")"));
                        throw e;
                    }
                }
            }
            return decoderInfos;
        }
        catch (Exception e) {
            throw new DecoderQueryException(e);
        }
    }

    private static boolean isCodecUsableDecoder(android.media.MediaCodecInfo info, String name, boolean secureDecodersExplicit) {
        if (info.isEncoder() || !secureDecodersExplicit && name.endsWith(".secure")) {
            return false;
        }
        if (Util.SDK_INT < 21 && ("CIPAACDecoder".equals(name) || "CIPMP3Decoder".equals(name) || "CIPVorbisDecoder".equals(name) || "AACDecoder".equals(name) || "MP3Decoder".equals(name))) {
            return false;
        }
        if (Util.SDK_INT < 18 && "OMX.SEC.MP3.Decoder".equals(name)) {
            return false;
        }
        if (Util.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(name) && "a70".equals(Util.DEVICE)) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(name) && ("dlxu".equals(Util.DEVICE) || "protou".equals(Util.DEVICE) || "ville".equals(Util.DEVICE) || "villeplus".equals(Util.DEVICE) || "villec2".equals(Util.DEVICE) || Util.DEVICE.startsWith("gee") || "C6602".equals(Util.DEVICE) || "C6603".equals(Util.DEVICE) || "C6606".equals(Util.DEVICE) || "C6616".equals(Util.DEVICE) || "L36h".equals(Util.DEVICE) || "SO-02E".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(name) && ("C1504".equals(Util.DEVICE) || "C1505".equals(Util.DEVICE) || "C1604".equals(Util.DEVICE) || "C1605".equals(Util.DEVICE))) {
            return false;
        }
        if (Util.SDK_INT <= 19 && (Util.DEVICE.startsWith("d2") || Util.DEVICE.startsWith("serrano") || Util.DEVICE.startsWith("jflte") || Util.DEVICE.startsWith("santos")) && "samsung".equals(Util.MANUFACTURER) && "OMX.SEC.vp8.dec".equals(name)) {
            return false;
        }
        return Util.SDK_INT > 19 || !Util.DEVICE.startsWith("jflte") || !"OMX.qcom.video.decoder.vp8".equals(name);
    }

    public static int maxH264DecodableFrameSize() throws DecoderQueryException {
        if (maxH264DecodableFrameSize == -1) {
            int result = 0;
            MediaCodecInfo decoderInfo = MediaCodecUtil.getDecoderInfo("video/avc", false);
            if (decoderInfo != null) {
                for (MediaCodecInfo.CodecProfileLevel profileLevel : decoderInfo.getProfileLevels()) {
                    result = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(profileLevel.level), result);
                }
                result = Math.max(result, 172800);
            }
            maxH264DecodableFrameSize = result;
        }
        return maxH264DecodableFrameSize;
    }

    public static Pair<Integer, Integer> getCodecProfileAndLevel(String codec) {
        if (codec == null) {
            return null;
        }
        String[] parts = codec.split("\\.");
        switch (parts[0]) {
            case "hev1": 
            case "hvc1": {
                return MediaCodecUtil.getHevcProfileAndLevel(codec, parts);
            }
            case "avc1": 
            case "avc2": {
                return MediaCodecUtil.getAvcProfileAndLevel(codec, parts);
            }
        }
        return null;
    }

    private static Pair<Integer, Integer> getHevcProfileAndLevel(String codec, String[] parts) {
        int profile;
        if (parts.length < 4) {
            Log.w((String)TAG, (String)("Ignoring malformed HEVC codec string: " + codec));
            return null;
        }
        Matcher matcher = PROFILE_PATTERN.matcher(parts[1]);
        if (!matcher.matches()) {
            Log.w((String)TAG, (String)("Ignoring malformed HEVC codec string: " + codec));
            return null;
        }
        String profileString = matcher.group(1);
        if ("1".equals(profileString)) {
            profile = 1;
        } else if ("2".equals(profileString)) {
            profile = 2;
        } else {
            Log.w((String)TAG, (String)("Unknown HEVC profile string: " + profileString));
            return null;
        }
        Integer level = HEVC_CODEC_STRING_TO_PROFILE_LEVEL.get(parts[3]);
        if (level == null) {
            Log.w((String)TAG, (String)("Unknown HEVC level string: " + matcher.group(1)));
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static Pair<Integer, Integer> getAvcProfileAndLevel(String codec, String[] codecsParts) {
        Integer levelInteger;
        Integer profileInteger;
        block7: {
            if (codecsParts.length < 2) {
                Log.w((String)TAG, (String)("Ignoring malformed AVC codec string: " + codec));
                return null;
            }
            profileInteger = null;
            levelInteger = null;
            try {
                if (codecsParts[1].length() == 6) {
                    profileInteger = Integer.parseInt(codecsParts[1].substring(0, 2), 16);
                    levelInteger = Integer.parseInt(codecsParts[1].substring(4), 16);
                    break block7;
                }
                if (codecsParts.length >= 3) {
                    profileInteger = Integer.parseInt(codecsParts[1]);
                    levelInteger = Integer.parseInt(codecsParts[2]);
                    break block7;
                }
                Log.w((String)TAG, (String)("Ignoring malformed AVC codec string: " + codec));
                return null;
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("Ignoring malformed AVC codec string: " + codec));
                return null;
            }
        }
        Integer profile = AVC_PROFILE_NUMBER_TO_CONST.get(profileInteger);
        if (profile == null) {
            Log.w((String)TAG, (String)("Unknown AVC profile: " + profileInteger));
            return null;
        }
        Integer level = AVC_LEVEL_NUMBER_TO_CONST.get(levelInteger);
        if (level == null) {
            Log.w((String)TAG, (String)("Unknown AVC level: " + levelInteger));
            return null;
        }
        return new Pair((Object)profile, (Object)level);
    }

    private static int avcLevelToMaxFrameSize(int avcLevel) {
        switch (avcLevel) {
            case 1: {
                return 25344;
            }
            case 2: {
                return 25344;
            }
            case 8: {
                return 101376;
            }
            case 16: {
                return 101376;
            }
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: {
                return 414720;
            }
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: {
                return 0x200000;
            }
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: {
                return 0x900000;
            }
        }
        return -1;
    }

    static {
        maxH264DecodableFrameSize = -1;
        AVC_PROFILE_NUMBER_TO_CONST = new HashMap<Integer, Integer>();
        AVC_PROFILE_NUMBER_TO_CONST.put(66, 1);
        AVC_PROFILE_NUMBER_TO_CONST.put(77, 2);
        AVC_PROFILE_NUMBER_TO_CONST.put(88, 4);
        AVC_PROFILE_NUMBER_TO_CONST.put(100, 8);
        AVC_LEVEL_NUMBER_TO_CONST = new HashMap<Integer, Integer>();
        AVC_LEVEL_NUMBER_TO_CONST.put(10, 1);
        AVC_LEVEL_NUMBER_TO_CONST.put(11, 4);
        AVC_LEVEL_NUMBER_TO_CONST.put(12, 8);
        AVC_LEVEL_NUMBER_TO_CONST.put(13, 16);
        AVC_LEVEL_NUMBER_TO_CONST.put(20, 32);
        AVC_LEVEL_NUMBER_TO_CONST.put(21, 64);
        AVC_LEVEL_NUMBER_TO_CONST.put(22, 128);
        AVC_LEVEL_NUMBER_TO_CONST.put(30, 256);
        AVC_LEVEL_NUMBER_TO_CONST.put(31, 512);
        AVC_LEVEL_NUMBER_TO_CONST.put(32, 1024);
        AVC_LEVEL_NUMBER_TO_CONST.put(40, 2048);
        AVC_LEVEL_NUMBER_TO_CONST.put(41, 4096);
        AVC_LEVEL_NUMBER_TO_CONST.put(42, 8192);
        AVC_LEVEL_NUMBER_TO_CONST.put(50, 16384);
        AVC_LEVEL_NUMBER_TO_CONST.put(51, 32768);
        AVC_LEVEL_NUMBER_TO_CONST.put(52, 65536);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL = new HashMap<String, Integer>();
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L30", 1);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L60", 4);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L63", 16);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L90", 64);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L93", 256);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L120", 1024);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L123", 4096);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L150", 16384);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L153", 65536);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L156", 262144);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L180", 0x100000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L183", 0x400000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("L186", 0x1000000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H30", 2);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H60", 8);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H63", 32);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H90", 128);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H93", 512);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H120", 2048);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H123", 8192);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H150", 32768);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H153", 131072);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H156", 524288);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H180", 0x200000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H183", 0x800000);
        HEVC_CODEC_STRING_TO_PROFILE_LEVEL.put("H186", 0x2000000);
    }

    private static final class CodecKey {
        public final String mimeType;
        public final boolean secure;

        public CodecKey(String mimeType, boolean secure) {
            this.mimeType = mimeType;
            this.secure = secure;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.secure ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != CodecKey.class) {
                return false;
            }
            CodecKey other = (CodecKey)obj;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)other.mimeType) && this.secure == other.secure;
        }
    }

    private static final class MediaCodecListCompatV16
    implements MediaCodecListCompat {
        private MediaCodecListCompatV16() {
        }

        @Override
        public int getCodecCount() {
            return MediaCodecList.getCodecCount();
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int index) {
            return MediaCodecList.getCodecInfoAt((int)index);
        }

        @Override
        public boolean secureDecodersExplicit() {
            return false;
        }

        @Override
        public boolean isSecurePlaybackSupported(String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return "video/avc".equals(mimeType);
        }
    }

    @TargetApi(value=21)
    private static final class MediaCodecListCompatV21
    implements MediaCodecListCompat {
        private final int codecKind;
        private android.media.MediaCodecInfo[] mediaCodecInfos;

        public MediaCodecListCompatV21(boolean includeSecure) {
            this.codecKind = includeSecure ? 1 : 0;
        }

        @Override
        public int getCodecCount() {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos.length;
        }

        @Override
        public android.media.MediaCodecInfo getCodecInfoAt(int index) {
            this.ensureMediaCodecInfosInitialized();
            return this.mediaCodecInfos[index];
        }

        @Override
        public boolean secureDecodersExplicit() {
            return true;
        }

        @Override
        public boolean isSecurePlaybackSupported(String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
            return capabilities.isFeatureSupported("secure-playback");
        }

        private void ensureMediaCodecInfosInitialized() {
            if (this.mediaCodecInfos == null) {
                this.mediaCodecInfos = new MediaCodecList(this.codecKind).getCodecInfos();
            }
        }
    }

    private static interface MediaCodecListCompat {
        public int getCodecCount();

        public android.media.MediaCodecInfo getCodecInfoAt(int var1);

        public boolean secureDecodersExplicit();

        public boolean isSecurePlaybackSupported(String var1, MediaCodecInfo.CodecCapabilities var2);
    }

    public static class DecoderQueryException
    extends Exception {
        private DecoderQueryException(Throwable cause) {
            super("Failed to query underlying media codecs", cause);
        }
    }
}

