/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.util.Pair;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;

@TargetApi(value=16)
public final class MediaCodecInfo {
    public final String name;
    public final boolean adaptive;
    private final String mimeType;
    private final MediaCodecInfo.CodecCapabilities capabilities;

    public static MediaCodecInfo newPassthroughInstance(String name) {
        return new MediaCodecInfo(name, null, null);
    }

    public static MediaCodecInfo newInstance(String name, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
        return new MediaCodecInfo(name, mimeType, capabilities);
    }

    private MediaCodecInfo(String name, String mimeType, MediaCodecInfo.CodecCapabilities capabilities) {
        this.name = Assertions.checkNotNull(name);
        this.mimeType = mimeType;
        this.capabilities = capabilities;
        this.adaptive = capabilities != null && MediaCodecInfo.isAdaptive(capabilities);
    }

    public MediaCodecInfo.CodecProfileLevel[] getProfileLevels() {
        return this.capabilities == null || this.capabilities.profileLevels == null ? new MediaCodecInfo.CodecProfileLevel[]{} : this.capabilities.profileLevels;
    }

    public boolean isCodecSupported(String codec) {
        if (codec == null || this.mimeType == null) {
            return true;
        }
        String codecMimeType = MimeTypes.getMediaMimeType(codec);
        if (codecMimeType == null) {
            return true;
        }
        if (!this.mimeType.equals(codecMimeType)) {
            return false;
        }
        Pair<Integer, Integer> codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(codec);
        if (codecProfileAndLevel == null) {
            return true;
        }
        for (MediaCodecInfo.CodecProfileLevel capabilities : this.getProfileLevels()) {
            if (capabilities.profile != (Integer)codecProfileAndLevel.first || capabilities.level < (Integer)codecProfileAndLevel.second) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=21)
    public boolean isVideoSizeSupportedV21(int width, int height) {
        if (this.capabilities == null) {
            return false;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
        return videoCapabilities != null && videoCapabilities.isSizeSupported(width, height);
    }

    @TargetApi(value=21)
    public boolean isVideoSizeAndRateSupportedV21(int width, int height, double frameRate) {
        if (this.capabilities == null) {
            return false;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
        return videoCapabilities != null && videoCapabilities.areSizeAndRateSupported(width, height, frameRate);
    }

    @TargetApi(value=21)
    public boolean isAudioSampleRateSupportedV21(int sampleRate) {
        if (this.capabilities == null) {
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.capabilities.getAudioCapabilities();
        return audioCapabilities != null && audioCapabilities.isSampleRateSupported(sampleRate);
    }

    @TargetApi(value=21)
    public boolean isAudioChannelCountSupportedV21(int channelCount) {
        if (this.capabilities == null) {
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.capabilities.getAudioCapabilities();
        return audioCapabilities != null && audioCapabilities.getMaxInputChannelCount() >= channelCount;
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 19 && MediaCodecInfo.isAdaptiveV19(capabilities);
    }

    @TargetApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("adaptive-playback");
    }
}

