/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.wav;

final class WavHeader {
    private final int numChannels;
    private final int sampleRateHz;
    private final int averageBytesPerSecond;
    private final int blockAlignment;
    private final int bitsPerSample;
    private final int encoding;
    private long dataStartPosition;
    private long dataSize;

    public WavHeader(int numChannels, int sampleRateHz, int averageBytesPerSecond, int blockAlignment, int bitsPerSample, int encoding) {
        this.numChannels = numChannels;
        this.sampleRateHz = sampleRateHz;
        this.averageBytesPerSecond = averageBytesPerSecond;
        this.blockAlignment = blockAlignment;
        this.bitsPerSample = bitsPerSample;
        this.encoding = encoding;
    }

    public long getDurationUs() {
        long numFrames = this.dataSize / (long)this.blockAlignment;
        return numFrames * 1000000L / (long)this.sampleRateHz;
    }

    public int getBytesPerFrame() {
        return this.blockAlignment;
    }

    public int getBitrate() {
        return this.sampleRateHz * this.bitsPerSample * this.numChannels;
    }

    public int getSampleRateHz() {
        return this.sampleRateHz;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public long getPosition(long timeUs) {
        long unroundedPosition = timeUs * (long)this.averageBytesPerSecond / 1000000L;
        long position = unroundedPosition / (long)this.blockAlignment * (long)this.blockAlignment;
        return Math.min(position, this.dataSize - (long)this.blockAlignment) + this.dataStartPosition;
    }

    public long getTimeUs(long position) {
        return position * 1000000L / (long)this.averageBytesPerSecond;
    }

    public boolean hasDataBounds() {
        return this.dataStartPosition != 0L && this.dataSize != 0L;
    }

    public void setDataBounds(long dataStartPosition, long dataSize) {
        this.dataStartPosition = dataStartPosition;
        this.dataSize = dataSize;
    }

    public int getEncoding() {
        return this.encoding;
    }
}

