/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TimestampAdjuster;
import com.google.android.exoplayer2.extractor.ts.DefaultStreamReaderFactory;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;

public final class TsExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        @Override
        public Extractor[] createExtractors() {
            return new Extractor[]{new TsExtractor()};
        }
    };
    public static final int TS_STREAM_TYPE_MPA = 3;
    public static final int TS_STREAM_TYPE_MPA_LSF = 4;
    public static final int TS_STREAM_TYPE_AAC = 15;
    public static final int TS_STREAM_TYPE_AC3 = 129;
    public static final int TS_STREAM_TYPE_DTS = 138;
    public static final int TS_STREAM_TYPE_HDMV_DTS = 130;
    public static final int TS_STREAM_TYPE_E_AC3 = 135;
    public static final int TS_STREAM_TYPE_H262 = 2;
    public static final int TS_STREAM_TYPE_H264 = 27;
    public static final int TS_STREAM_TYPE_H265 = 36;
    public static final int TS_STREAM_TYPE_ID3 = 21;
    private static final String TAG = "TsExtractor";
    private static final int TS_PACKET_SIZE = 188;
    private static final int TS_SYNC_BYTE = 71;
    private static final int TS_PAT_PID = 0;
    private static final int MAX_PID_PLUS_ONE = 8192;
    private static final long AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("AC-3");
    private static final long E_AC3_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("EAC3");
    private static final long HEVC_FORMAT_IDENTIFIER = Util.getIntegerCodeForString("HEVC");
    private static final int BUFFER_PACKET_COUNT = 5;
    private static final int BUFFER_SIZE = 940;
    private final boolean mapByType;
    private final TimestampAdjuster timestampAdjuster;
    private final ParsableByteArray tsPacketBuffer;
    private final ParsableBitArray tsScratch;
    private final SparseIntArray continuityCounters;
    private final ElementaryStreamReader.Factory streamReaderFactory;
    private final SparseArray<TsPayloadReader> tsPayloadReaders;
    private final SparseBooleanArray trackIds;
    private ExtractorOutput output;
    private boolean tracksEnded;
    private ElementaryStreamReader id3Reader;

    public TsExtractor() {
        this(new TimestampAdjuster(0L));
    }

    public TsExtractor(TimestampAdjuster timestampAdjuster) {
        this(timestampAdjuster, new DefaultStreamReaderFactory(), false);
    }

    public TsExtractor(TimestampAdjuster timestampAdjuster, ElementaryStreamReader.Factory customReaderFactory, boolean mapByType) {
        this.timestampAdjuster = timestampAdjuster;
        this.streamReaderFactory = Assertions.checkNotNull(customReaderFactory);
        this.mapByType = mapByType;
        this.tsPacketBuffer = new ParsableByteArray(940);
        this.tsScratch = new ParsableBitArray(new byte[3]);
        this.trackIds = new SparseBooleanArray();
        this.tsPayloadReaders = new SparseArray();
        this.continuityCounters = new SparseIntArray();
        this.resetPayloadReaders();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        byte[] buffer = this.tsPacketBuffer.data;
        input.peekFully(buffer, 0, 940);
        block0: for (int j = 0; j < 188; ++j) {
            int i = 0;
            while (true) {
                if (i == 5) {
                    input.skipFully(j);
                    return true;
                }
                if (buffer[j + i * 188] != 71) continue block0;
                ++i;
            }
        }
        return false;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.output = output;
        output.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
    }

    @Override
    public void seek(long position) {
        this.timestampAdjuster.reset();
        this.tsPacketBuffer.reset();
        this.continuityCounters.clear();
        this.resetPayloadReaders();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        TsPayloadReader payloadReader;
        int position;
        int limit;
        byte[] data = this.tsPacketBuffer.data;
        if (940 - this.tsPacketBuffer.getPosition() < 188) {
            int bytesLeft = this.tsPacketBuffer.bytesLeft();
            if (bytesLeft > 0) {
                System.arraycopy(data, this.tsPacketBuffer.getPosition(), data, 0, bytesLeft);
            }
            this.tsPacketBuffer.reset(data, bytesLeft);
        }
        while (this.tsPacketBuffer.bytesLeft() < 188) {
            limit = this.tsPacketBuffer.limit();
            int read = input.read(data, limit, 940 - limit);
            if (read == -1) {
                return -1;
            }
            this.tsPacketBuffer.setLimit(limit + read);
        }
        limit = this.tsPacketBuffer.limit();
        for (position = this.tsPacketBuffer.getPosition(); position < limit && data[position] != 71; ++position) {
        }
        this.tsPacketBuffer.setPosition(position);
        int endOfPacket = position + 188;
        if (endOfPacket > limit) {
            return 0;
        }
        this.tsPacketBuffer.skipBytes(1);
        this.tsPacketBuffer.readBytes(this.tsScratch, 3);
        if (this.tsScratch.readBit()) {
            this.tsPacketBuffer.setPosition(endOfPacket);
            return 0;
        }
        boolean payloadUnitStartIndicator = this.tsScratch.readBit();
        this.tsScratch.skipBits(1);
        int pid = this.tsScratch.readBits(13);
        this.tsScratch.skipBits(2);
        boolean adaptationFieldExists = this.tsScratch.readBit();
        boolean payloadExists = this.tsScratch.readBit();
        boolean discontinuityFound = false;
        int continuityCounter = this.tsScratch.readBits(4);
        int previousCounter = this.continuityCounters.get(pid, continuityCounter - 1);
        this.continuityCounters.put(pid, continuityCounter);
        if (previousCounter == continuityCounter) {
            this.tsPacketBuffer.setPosition(endOfPacket);
            return 0;
        }
        if (continuityCounter != (previousCounter + 1) % 16) {
            discontinuityFound = true;
        }
        if (adaptationFieldExists) {
            int adaptationFieldLength = this.tsPacketBuffer.readUnsignedByte();
            this.tsPacketBuffer.skipBytes(adaptationFieldLength);
        }
        if (payloadExists && (payloadReader = (TsPayloadReader)this.tsPayloadReaders.get(pid)) != null) {
            if (discontinuityFound) {
                payloadReader.seek();
            }
            this.tsPacketBuffer.setLimit(endOfPacket);
            payloadReader.consume(this.tsPacketBuffer, payloadUnitStartIndicator, this.output);
            Assertions.checkState(this.tsPacketBuffer.getPosition() <= endOfPacket);
            this.tsPacketBuffer.setLimit(limit);
        }
        this.tsPacketBuffer.setPosition(endOfPacket);
        return 0;
    }

    private void resetPayloadReaders() {
        this.trackIds.clear();
        this.tsPayloadReaders.clear();
        this.tsPayloadReaders.put(0, (Object)new PatReader());
        this.id3Reader = null;
    }

    private static final class PesReader
    extends TsPayloadReader {
        private static final int STATE_FINDING_HEADER = 0;
        private static final int STATE_READING_HEADER = 1;
        private static final int STATE_READING_HEADER_EXTENSION = 2;
        private static final int STATE_READING_BODY = 3;
        private static final int HEADER_SIZE = 9;
        private static final int MAX_HEADER_EXTENSION_SIZE = 10;
        private static final int PES_SCRATCH_SIZE = 10;
        private final ElementaryStreamReader pesPayloadReader;
        private final TimestampAdjuster timestampAdjuster;
        private final ParsableBitArray pesScratch;
        private int state;
        private int bytesRead;
        private boolean ptsFlag;
        private boolean dtsFlag;
        private boolean seenFirstDts;
        private int extendedHeaderLength;
        private int payloadSize;
        private boolean dataAlignmentIndicator;
        private long timeUs;

        public PesReader(ElementaryStreamReader pesPayloadReader, TimestampAdjuster timestampAdjuster) {
            this.pesPayloadReader = pesPayloadReader;
            this.timestampAdjuster = timestampAdjuster;
            this.pesScratch = new ParsableBitArray(new byte[10]);
            this.state = 0;
        }

        @Override
        public void seek() {
            this.state = 0;
            this.bytesRead = 0;
            this.seenFirstDts = false;
            this.pesPayloadReader.seek();
        }

        @Override
        public void consume(ParsableByteArray data, boolean payloadUnitStartIndicator, ExtractorOutput output) {
            if (payloadUnitStartIndicator) {
                switch (this.state) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        Log.w((String)TsExtractor.TAG, (String)"Unexpected start indicator reading extended header");
                        break;
                    }
                    case 3: {
                        if (this.payloadSize != -1) {
                            Log.w((String)TsExtractor.TAG, (String)("Unexpected start indicator: expected " + this.payloadSize + " more bytes"));
                        }
                        this.pesPayloadReader.packetFinished();
                    }
                }
                this.setState(1);
            }
            while (data.bytesLeft() > 0) {
                switch (this.state) {
                    case 0: {
                        data.skipBytes(data.bytesLeft());
                        break;
                    }
                    case 1: {
                        if (!this.continueRead(data, this.pesScratch.data, 9)) break;
                        this.setState(this.parseHeader() ? 2 : 0);
                        break;
                    }
                    case 2: {
                        int readLength = Math.min(10, this.extendedHeaderLength);
                        if (!this.continueRead(data, this.pesScratch.data, readLength) || !this.continueRead(data, null, this.extendedHeaderLength)) break;
                        this.parseHeaderExtension();
                        this.pesPayloadReader.packetStarted(this.timeUs, this.dataAlignmentIndicator);
                        this.setState(3);
                        break;
                    }
                    case 3: {
                        int padding;
                        int readLength = data.bytesLeft();
                        int n = padding = this.payloadSize == -1 ? 0 : readLength - this.payloadSize;
                        if (padding > 0) {
                            data.setLimit(data.getPosition() + (readLength -= padding));
                        }
                        this.pesPayloadReader.consume(data);
                        if (this.payloadSize == -1) break;
                        this.payloadSize -= readLength;
                        if (this.payloadSize != 0) break;
                        this.pesPayloadReader.packetFinished();
                        this.setState(1);
                    }
                }
            }
        }

        private void setState(int state) {
            this.state = state;
            this.bytesRead = 0;
        }

        private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
            int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
            if (bytesToRead <= 0) {
                return true;
            }
            if (target == null) {
                source.skipBytes(bytesToRead);
            } else {
                source.readBytes(target, this.bytesRead, bytesToRead);
            }
            this.bytesRead += bytesToRead;
            return this.bytesRead == targetLength;
        }

        private boolean parseHeader() {
            this.pesScratch.setPosition(0);
            int startCodePrefix = this.pesScratch.readBits(24);
            if (startCodePrefix != 1) {
                Log.w((String)TsExtractor.TAG, (String)("Unexpected start code prefix: " + startCodePrefix));
                this.payloadSize = -1;
                return false;
            }
            this.pesScratch.skipBits(8);
            int packetLength = this.pesScratch.readBits(16);
            this.pesScratch.skipBits(5);
            this.dataAlignmentIndicator = this.pesScratch.readBit();
            this.pesScratch.skipBits(2);
            this.ptsFlag = this.pesScratch.readBit();
            this.dtsFlag = this.pesScratch.readBit();
            this.pesScratch.skipBits(6);
            this.extendedHeaderLength = this.pesScratch.readBits(8);
            this.payloadSize = packetLength == 0 ? -1 : packetLength + 6 - 9 - this.extendedHeaderLength;
            return true;
        }

        private void parseHeaderExtension() {
            this.pesScratch.setPosition(0);
            this.timeUs = -9223372036854775807L;
            if (this.ptsFlag) {
                this.pesScratch.skipBits(4);
                long pts = (long)this.pesScratch.readBits(3) << 30;
                this.pesScratch.skipBits(1);
                pts |= (long)(this.pesScratch.readBits(15) << 15);
                this.pesScratch.skipBits(1);
                pts |= (long)this.pesScratch.readBits(15);
                this.pesScratch.skipBits(1);
                if (!this.seenFirstDts && this.dtsFlag) {
                    this.pesScratch.skipBits(4);
                    long dts = (long)this.pesScratch.readBits(3) << 30;
                    this.pesScratch.skipBits(1);
                    dts |= (long)(this.pesScratch.readBits(15) << 15);
                    this.pesScratch.skipBits(1);
                    this.pesScratch.skipBits(1);
                    this.timestampAdjuster.adjustTsTimestamp(dts |= (long)this.pesScratch.readBits(15));
                    this.seenFirstDts = true;
                }
                this.timeUs = this.timestampAdjuster.adjustTsTimestamp(pts);
            }
        }
    }

    private class PmtReader
    extends TsPayloadReader {
        private static final int TS_PMT_DESC_REGISTRATION = 5;
        private static final int TS_PMT_DESC_ISO639_LANG = 10;
        private static final int TS_PMT_DESC_AC3 = 106;
        private static final int TS_PMT_DESC_EAC3 = 122;
        private static final int TS_PMT_DESC_DTS = 123;
        private final ParsableBitArray pmtScratch;
        private final ParsableByteArray sectionData;
        private final int pid;
        private int sectionLength;
        private int sectionBytesRead;
        private int crc;

        public PmtReader(int pid) {
            this.pmtScratch = new ParsableBitArray(new byte[5]);
            this.sectionData = new ParsableByteArray();
            this.pid = pid;
        }

        @Override
        public void seek() {
        }

        @Override
        public void consume(ParsableByteArray data, boolean payloadUnitStartIndicator, ExtractorOutput output) {
            if (payloadUnitStartIndicator) {
                int pointerField = data.readUnsignedByte();
                data.skipBytes(pointerField);
                data.readBytes(this.pmtScratch, 3);
                this.pmtScratch.skipBits(12);
                this.sectionLength = this.pmtScratch.readBits(12);
                this.sectionBytesRead = 0;
                this.crc = Util.crc(this.pmtScratch.data, 0, 3, -1);
                this.sectionData.reset(this.sectionLength);
            }
            int bytesToRead = Math.min(data.bytesLeft(), this.sectionLength - this.sectionBytesRead);
            data.readBytes(this.sectionData.data, this.sectionBytesRead, bytesToRead);
            this.sectionBytesRead += bytesToRead;
            if (this.sectionBytesRead < this.sectionLength) {
                return;
            }
            if (Util.crc(this.sectionData.data, 0, this.sectionLength, this.crc) != 0) {
                return;
            }
            this.sectionData.skipBytes(7);
            this.sectionData.readBytes(this.pmtScratch, 2);
            this.pmtScratch.skipBits(4);
            int programInfoLength = this.pmtScratch.readBits(12);
            this.sectionData.skipBytes(programInfoLength);
            if (TsExtractor.this.mapByType && TsExtractor.this.id3Reader == null) {
                ElementaryStreamReader.EsInfo dummyEsInfo = new ElementaryStreamReader.EsInfo(21, null, new byte[0]);
                TsExtractor.this.id3Reader = TsExtractor.this.streamReaderFactory.createStreamReader(21, dummyEsInfo);
                TsExtractor.this.id3Reader.init(output, new ElementaryStreamReader.TrackIdGenerator(21, 8192));
            }
            int remainingEntriesLength = this.sectionLength - 9 - programInfoLength - 4;
            while (remainingEntriesLength > 0) {
                ElementaryStreamReader pesPayloadReader;
                int trackId;
                this.sectionData.readBytes(this.pmtScratch, 5);
                int streamType = this.pmtScratch.readBits(8);
                this.pmtScratch.skipBits(3);
                int elementaryPid = this.pmtScratch.readBits(13);
                this.pmtScratch.skipBits(4);
                int esInfoLength = this.pmtScratch.readBits(12);
                ElementaryStreamReader.EsInfo esInfo = this.readEsInfo(this.sectionData, esInfoLength);
                if (streamType == 6) {
                    streamType = esInfo.streamType;
                }
                remainingEntriesLength -= esInfoLength + 5;
                int n = trackId = TsExtractor.this.mapByType ? streamType : elementaryPid;
                if (TsExtractor.this.trackIds.get(trackId)) continue;
                TsExtractor.this.trackIds.put(trackId, true);
                if (TsExtractor.this.mapByType && streamType == 21) {
                    pesPayloadReader = TsExtractor.this.id3Reader;
                } else {
                    pesPayloadReader = TsExtractor.this.streamReaderFactory.createStreamReader(streamType, esInfo);
                    pesPayloadReader.init(output, new ElementaryStreamReader.TrackIdGenerator(trackId, 8192));
                }
                if (pesPayloadReader == null) continue;
                TsExtractor.this.tsPayloadReaders.put(elementaryPid, (Object)new PesReader(pesPayloadReader, TsExtractor.this.timestampAdjuster));
            }
            if (TsExtractor.this.mapByType) {
                if (!TsExtractor.this.tracksEnded) {
                    output.endTracks();
                }
            } else {
                TsExtractor.this.tsPayloadReaders.remove(0);
                TsExtractor.this.tsPayloadReaders.remove(this.pid);
                output.endTracks();
            }
            TsExtractor.this.tracksEnded = true;
        }

        private ElementaryStreamReader.EsInfo readEsInfo(ParsableByteArray data, int length) {
            int descriptorsStartPosition = data.getPosition();
            int descriptorsEndPosition = descriptorsStartPosition + length;
            int streamType = -1;
            String language = null;
            while (data.getPosition() < descriptorsEndPosition) {
                int descriptorTag = data.readUnsignedByte();
                int descriptorLength = data.readUnsignedByte();
                int positionOfNextDescriptor = data.getPosition() + descriptorLength;
                if (descriptorTag == 5) {
                    long formatIdentifier = data.readUnsignedInt();
                    if (formatIdentifier == AC3_FORMAT_IDENTIFIER) {
                        streamType = 129;
                    } else if (formatIdentifier == E_AC3_FORMAT_IDENTIFIER) {
                        streamType = 135;
                    } else if (formatIdentifier == HEVC_FORMAT_IDENTIFIER) {
                        streamType = 36;
                    }
                } else if (descriptorTag == 106) {
                    streamType = 129;
                } else if (descriptorTag == 122) {
                    streamType = 135;
                } else if (descriptorTag == 123) {
                    streamType = 138;
                } else if (descriptorTag == 10) {
                    language = new String(data.data, data.getPosition(), 3).trim();
                }
                data.skipBytes(positionOfNextDescriptor - data.getPosition());
            }
            data.setPosition(descriptorsEndPosition);
            return new ElementaryStreamReader.EsInfo(streamType, language, Arrays.copyOfRange(this.sectionData.data, descriptorsStartPosition, descriptorsEndPosition));
        }
    }

    private class PatReader
    extends TsPayloadReader {
        private final ParsableByteArray sectionData;
        private final ParsableBitArray patScratch;
        private int sectionLength;
        private int sectionBytesRead;
        private int crc;

        public PatReader() {
            this.sectionData = new ParsableByteArray();
            this.patScratch = new ParsableBitArray(new byte[4]);
        }

        @Override
        public void seek() {
        }

        @Override
        public void consume(ParsableByteArray data, boolean payloadUnitStartIndicator, ExtractorOutput output) {
            if (payloadUnitStartIndicator) {
                int pointerField = data.readUnsignedByte();
                data.skipBytes(pointerField);
                data.readBytes(this.patScratch, 3);
                this.patScratch.skipBits(12);
                this.sectionLength = this.patScratch.readBits(12);
                this.sectionBytesRead = 0;
                this.crc = Util.crc(this.patScratch.data, 0, 3, -1);
                this.sectionData.reset(this.sectionLength);
            }
            int bytesToRead = Math.min(data.bytesLeft(), this.sectionLength - this.sectionBytesRead);
            data.readBytes(this.sectionData.data, this.sectionBytesRead, bytesToRead);
            this.sectionBytesRead += bytesToRead;
            if (this.sectionBytesRead < this.sectionLength) {
                return;
            }
            if (Util.crc(this.sectionData.data, 0, this.sectionLength, this.crc) != 0) {
                return;
            }
            this.sectionData.skipBytes(5);
            int programCount = (this.sectionLength - 9) / 4;
            for (int i = 0; i < programCount; ++i) {
                this.sectionData.readBytes(this.patScratch, 4);
                int programNumber = this.patScratch.readBits(16);
                this.patScratch.skipBits(3);
                if (programNumber == 0) {
                    this.patScratch.skipBits(13);
                    continue;
                }
                int pid = this.patScratch.readBits(13);
                TsExtractor.this.tsPayloadReaders.put(pid, (Object)new PmtReader(pid));
            }
        }
    }

    private static abstract class TsPayloadReader {
        private TsPayloadReader() {
        }

        public abstract void seek();

        public abstract void consume(ParsableByteArray var1, boolean var2, ExtractorOutput var3);
    }
}

