/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.text.cea.Cea608Decoder;
import com.google.android.exoplayer2.util.ParsableByteArray;

final class SeiReader {
    private final TrackOutput output;

    public SeiReader(TrackOutput output) {
        this.output = output;
        output.format(Format.createTextSampleFormat(null, "application/cea-608", null, -1, 0, null, null));
    }

    public void consume(long pesTimeUs, ParsableByteArray seiBuffer) {
        while (seiBuffer.bytesLeft() > 1) {
            int b;
            int payloadType = 0;
            do {
                b = seiBuffer.readUnsignedByte();
                payloadType += b;
            } while (b == 255);
            int payloadSize = 0;
            do {
                b = seiBuffer.readUnsignedByte();
                payloadSize += b;
            } while (b == 255);
            if (Cea608Decoder.isSeiMessageCea608(payloadType, payloadSize, seiBuffer)) {
                seiBuffer.skipBytes(8);
                int ccCount = seiBuffer.readUnsignedByte() & 0x1F;
                seiBuffer.skipBytes(1);
                int sampleBytes = 0;
                for (int i = 0; i < ccCount; ++i) {
                    int ccValidityAndType = seiBuffer.peekUnsignedByte() & 7;
                    if (ccValidityAndType != 4) {
                        seiBuffer.skipBytes(3);
                        continue;
                    }
                    sampleBytes += 3;
                    this.output.sampleData(seiBuffer, 3);
                }
                this.output.sampleMetadata(pesTimeUs, 1, sampleBytes, 0, null);
                seiBuffer.skipBytes(payloadSize - (10 + ccCount * 3));
                continue;
            }
            seiBuffer.skipBytes(payloadSize);
        }
    }
}

