/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;
import java.util.Collections;

final class H262Reader
extends ElementaryStreamReader {
    private static final int START_PICTURE = 0;
    private static final int START_SEQUENCE_HEADER = 179;
    private static final int START_EXTENSION = 181;
    private static final int START_GROUP = 184;
    private TrackOutput output;
    private static final double[] FRAME_RATE_VALUES = new double[]{23.976023976023978, 24.0, 25.0, 29.97002997002997, 30.0, 50.0, 59.94005994005994, 60.0};
    private boolean hasOutputFormat;
    private long frameDurationUs;
    private final boolean[] prefixFlags = new boolean[4];
    private final CsdBuffer csdBuffer = new CsdBuffer(128);
    private boolean foundFirstFrameInGroup;
    private long totalBytesWritten;
    private long pesTimeUs;
    private boolean pesPtsUsAvailable;
    private boolean isKeyframe;
    private long framePosition;
    private long frameTimeUs;

    @Override
    public void seek() {
        NalUnitUtil.clearPrefixFlags(this.prefixFlags);
        this.csdBuffer.reset();
        this.pesPtsUsAvailable = false;
        this.foundFirstFrameInGroup = false;
        this.totalBytesWritten = 0L;
    }

    @Override
    public void init(ExtractorOutput extractorOutput, ElementaryStreamReader.TrackIdGenerator idGenerator) {
        this.output = extractorOutput.track(idGenerator.getNextId());
    }

    @Override
    public void packetStarted(long pesTimeUs, boolean dataAlignmentIndicator) {
        boolean bl = this.pesPtsUsAvailable = pesTimeUs != -9223372036854775807L;
        if (this.pesPtsUsAvailable) {
            this.pesTimeUs = pesTimeUs;
        }
    }

    @Override
    public void consume(ParsableByteArray data) {
        int offset = data.getPosition();
        int limit = data.limit();
        byte[] dataArray = data.data;
        this.totalBytesWritten += (long)data.bytesLeft();
        this.output.sampleData(data, data.bytesLeft());
        int searchOffset = offset;
        while (true) {
            int startCodeOffset;
            if ((startCodeOffset = NalUnitUtil.findNalUnit(dataArray, searchOffset, limit, this.prefixFlags)) == limit) {
                if (!this.hasOutputFormat) {
                    this.csdBuffer.onData(dataArray, offset, limit);
                }
                return;
            }
            int startCodeValue = data.data[startCodeOffset + 3] & 0xFF;
            if (!this.hasOutputFormat) {
                int bytesAlreadyPassed;
                int lengthToStartCode = startCodeOffset - offset;
                if (lengthToStartCode > 0) {
                    this.csdBuffer.onData(dataArray, offset, startCodeOffset);
                }
                int n = bytesAlreadyPassed = lengthToStartCode < 0 ? -lengthToStartCode : 0;
                if (this.csdBuffer.onStartCode(startCodeValue, bytesAlreadyPassed)) {
                    Pair<Format, Long> result = H262Reader.parseCsdBuffer(this.csdBuffer);
                    this.output.format((Format)result.first);
                    this.frameDurationUs = (Long)result.second;
                    this.hasOutputFormat = true;
                }
            }
            if (this.hasOutputFormat && (startCodeValue == 184 || startCodeValue == 0)) {
                int bytesWrittenPastStartCode = limit - startCodeOffset;
                if (this.foundFirstFrameInGroup) {
                    int flags = this.isKeyframe ? 1 : 0;
                    int size = (int)(this.totalBytesWritten - this.framePosition) - bytesWrittenPastStartCode;
                    this.output.sampleMetadata(this.frameTimeUs, flags, size, bytesWrittenPastStartCode, null);
                    this.isKeyframe = false;
                }
                if (startCodeValue == 184) {
                    this.foundFirstFrameInGroup = false;
                    this.isKeyframe = true;
                } else {
                    this.frameTimeUs = this.pesPtsUsAvailable ? this.pesTimeUs : this.frameTimeUs + this.frameDurationUs;
                    this.framePosition = this.totalBytesWritten - (long)bytesWrittenPastStartCode;
                    this.pesPtsUsAvailable = false;
                    this.foundFirstFrameInGroup = true;
                }
            }
            offset = startCodeOffset;
            searchOffset = offset + 3;
        }
    }

    @Override
    public void packetFinished() {
    }

    private static Pair<Format, Long> parseCsdBuffer(CsdBuffer csdBuffer) {
        byte[] csdData = Arrays.copyOf(csdBuffer.data, csdBuffer.length);
        int firstByte = csdData[4] & 0xFF;
        int secondByte = csdData[5] & 0xFF;
        int thirdByte = csdData[6] & 0xFF;
        int width = firstByte << 4 | secondByte >> 4;
        int height = (secondByte & 0xF) << 8 | thirdByte;
        float pixelWidthHeightRatio = 1.0f;
        int aspectRatioCode = (csdData[7] & 0xF0) >> 4;
        switch (aspectRatioCode) {
            case 2: {
                pixelWidthHeightRatio = (float)(4 * height) / (float)(3 * width);
                break;
            }
            case 3: {
                pixelWidthHeightRatio = (float)(16 * height) / (float)(9 * width);
                break;
            }
            case 4: {
                pixelWidthHeightRatio = (float)(121 * height) / (float)(100 * width);
                break;
            }
        }
        Format format = Format.createVideoSampleFormat(null, "video/mpeg2", null, -1, -1, width, height, -1.0f, Collections.singletonList(csdData), -1, pixelWidthHeightRatio, null);
        long frameDurationUs = 0L;
        int frameRateCodeMinusOne = (csdData[7] & 0xF) - 1;
        if (0 <= frameRateCodeMinusOne && frameRateCodeMinusOne < FRAME_RATE_VALUES.length) {
            double frameRate = FRAME_RATE_VALUES[frameRateCodeMinusOne];
            int sequenceExtensionPosition = csdBuffer.sequenceExtensionPosition;
            int frameRateExtensionN = (csdData[sequenceExtensionPosition + 9] & 0x60) >> 5;
            int frameRateExtensionD = csdData[sequenceExtensionPosition + 9] & 0x1F;
            if (frameRateExtensionN != frameRateExtensionD) {
                frameRate *= ((double)frameRateExtensionN + 1.0) / (double)(frameRateExtensionD + 1);
            }
            frameDurationUs = (long)(1000000.0 / frameRate);
        }
        return Pair.create((Object)format, (Object)frameDurationUs);
    }

    private static final class CsdBuffer {
        private boolean isFilling;
        public int length;
        public int sequenceExtensionPosition;
        public byte[] data;

        public CsdBuffer(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        public void reset() {
            this.isFilling = false;
            this.length = 0;
            this.sequenceExtensionPosition = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean onStartCode(int startCodeValue, int bytesAlreadyPassed) {
            if (!this.isFilling) {
                if (startCodeValue != 179) return false;
                this.isFilling = true;
                return false;
            }
            if (this.sequenceExtensionPosition == 0 && startCodeValue == 181) {
                this.sequenceExtensionPosition = this.length;
                return false;
            }
            this.length -= bytesAlreadyPassed;
            this.isFilling = false;
            return true;
        }

        public void onData(byte[] newData, int offset, int limit) {
            if (!this.isFilling) {
                return;
            }
            int readLength = limit - offset;
            if (this.data.length < this.length + readLength) {
                this.data = Arrays.copyOf(this.data, (this.length + readLength) * 2);
            }
            System.arraycopy(newData, offset, this.data, this.length, readLength);
            this.length += readLength;
        }
    }
}

