/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.util.ParsableByteArray;

public abstract class ElementaryStreamReader {
    public abstract void seek();

    public abstract void init(ExtractorOutput var1, TrackIdGenerator var2);

    public abstract void packetStarted(long var1, boolean var3);

    public abstract void consume(ParsableByteArray var1);

    public abstract void packetFinished();

    public static final class TrackIdGenerator {
        private final int firstId;
        private final int idIncrement;
        private int generatedIdCount;

        public TrackIdGenerator(int firstId, int idIncrement) {
            this.firstId = firstId;
            this.idIncrement = idIncrement;
        }

        public int getNextId() {
            return this.firstId + this.idIncrement * this.generatedIdCount++;
        }
    }

    public static final class EsInfo {
        public final int streamType;
        public String language;
        public byte[] descriptorBytes;

        public EsInfo(int streamType, String language, byte[] descriptorBytes) {
            this.streamType = streamType;
            this.language = language;
            this.descriptorBytes = descriptorBytes;
        }
    }

    public static interface Factory {
        public ElementaryStreamReader createStreamReader(int var1, EsInfo var2);
    }
}

