/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.extractor.ts.Ac3Reader;
import com.google.android.exoplayer2.extractor.ts.AdtsReader;
import com.google.android.exoplayer2.extractor.ts.DtsReader;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.extractor.ts.H262Reader;
import com.google.android.exoplayer2.extractor.ts.H264Reader;
import com.google.android.exoplayer2.extractor.ts.H265Reader;
import com.google.android.exoplayer2.extractor.ts.Id3Reader;
import com.google.android.exoplayer2.extractor.ts.MpegAudioReader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class DefaultStreamReaderFactory
implements ElementaryStreamReader.Factory {
    public static final int FLAG_ALLOW_NON_IDR_KEYFRAMES = 1;
    public static final int FLAG_IGNORE_AAC_STREAM = 2;
    public static final int FLAG_IGNORE_H264_STREAM = 4;
    public static final int FLAG_DETECT_ACCESS_UNITS = 8;
    private final int flags;

    public DefaultStreamReaderFactory() {
        this(0);
    }

    public DefaultStreamReaderFactory(int flags) {
        this.flags = flags;
    }

    @Override
    public ElementaryStreamReader createStreamReader(int streamType, ElementaryStreamReader.EsInfo esInfo) {
        switch (streamType) {
            case 3: 
            case 4: {
                return new MpegAudioReader(esInfo.language);
            }
            case 15: {
                return (this.flags & 2) != 0 ? null : new AdtsReader(false, esInfo.language);
            }
            case 129: 
            case 135: {
                return new Ac3Reader(esInfo.language);
            }
            case 130: 
            case 138: {
                return new DtsReader(esInfo.language);
            }
            case 2: {
                return new H262Reader();
            }
            case 27: {
                return (this.flags & 4) != 0 ? null : new H264Reader((this.flags & 1) != 0, (this.flags & 8) != 0);
            }
            case 36: {
                return new H265Reader();
            }
            case 21: {
                return new Id3Reader();
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

