/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;
import java.util.Collections;

final class AdtsReader
extends ElementaryStreamReader {
    private static final String TAG = "AdtsReader";
    private static final int STATE_FINDING_SAMPLE = 0;
    private static final int STATE_READING_ID3_HEADER = 1;
    private static final int STATE_READING_ADTS_HEADER = 2;
    private static final int STATE_READING_SAMPLE = 3;
    private static final int HEADER_SIZE = 5;
    private static final int CRC_SIZE = 2;
    private static final int MATCH_STATE_VALUE_SHIFT = 8;
    private static final int MATCH_STATE_START = 256;
    private static final int MATCH_STATE_FF = 512;
    private static final int MATCH_STATE_I = 768;
    private static final int MATCH_STATE_ID = 1024;
    private static final int ID3_HEADER_SIZE = 10;
    private static final int ID3_SIZE_OFFSET = 6;
    private static final byte[] ID3_IDENTIFIER = new byte[]{73, 68, 51};
    private final boolean exposeId3;
    private final ParsableBitArray adtsScratch = new ParsableBitArray(new byte[7]);
    private final ParsableByteArray id3HeaderBuffer = new ParsableByteArray(Arrays.copyOf(ID3_IDENTIFIER, 10));
    private final String language;
    private TrackOutput output;
    private TrackOutput id3Output;
    private int state;
    private int bytesRead;
    private int matchState;
    private boolean hasCrc;
    private boolean hasOutputFormat;
    private long sampleDurationUs;
    private int sampleSize;
    private long timeUs;
    private TrackOutput currentOutput;
    private long currentSampleDuration;

    public AdtsReader(boolean exposeId3) {
        this(exposeId3, null);
    }

    public AdtsReader(boolean exposeId3, String language) {
        this.setFindingSampleState();
        this.exposeId3 = exposeId3;
        this.language = language;
    }

    @Override
    public void seek() {
        this.setFindingSampleState();
    }

    @Override
    public void init(ExtractorOutput extractorOutput, ElementaryStreamReader.TrackIdGenerator idGenerator) {
        this.output = extractorOutput.track(idGenerator.getNextId());
        if (this.exposeId3) {
            this.id3Output = extractorOutput.track(idGenerator.getNextId());
            this.id3Output.format(Format.createSampleFormat(null, "application/id3", null, -1, null));
        } else {
            this.id3Output = new DummyTrackOutput();
        }
    }

    @Override
    public void packetStarted(long pesTimeUs, boolean dataAlignmentIndicator) {
        this.timeUs = pesTimeUs;
    }

    @Override
    public void consume(ParsableByteArray data) {
        while (data.bytesLeft() > 0) {
            switch (this.state) {
                case 0: {
                    this.findNextSample(data);
                    break;
                }
                case 1: {
                    if (!this.continueRead(data, this.id3HeaderBuffer.data, 10)) break;
                    this.parseId3Header();
                    break;
                }
                case 2: {
                    int targetLength;
                    int n = targetLength = this.hasCrc ? 7 : 5;
                    if (!this.continueRead(data, this.adtsScratch.data, targetLength)) break;
                    this.parseAdtsHeader();
                    break;
                }
                case 3: {
                    this.readSample(data);
                }
            }
        }
    }

    @Override
    public void packetFinished() {
    }

    private boolean continueRead(ParsableByteArray source, byte[] target, int targetLength) {
        int bytesToRead = Math.min(source.bytesLeft(), targetLength - this.bytesRead);
        source.readBytes(target, this.bytesRead, bytesToRead);
        this.bytesRead += bytesToRead;
        return this.bytesRead == targetLength;
    }

    private void setFindingSampleState() {
        this.state = 0;
        this.bytesRead = 0;
        this.matchState = 256;
    }

    private void setReadingId3HeaderState() {
        this.state = 1;
        this.bytesRead = ID3_IDENTIFIER.length;
        this.sampleSize = 0;
        this.id3HeaderBuffer.setPosition(0);
    }

    private void setReadingSampleState(TrackOutput outputToUse, long currentSampleDuration, int priorReadBytes, int sampleSize) {
        this.state = 3;
        this.bytesRead = priorReadBytes;
        this.currentOutput = outputToUse;
        this.currentSampleDuration = currentSampleDuration;
        this.sampleSize = sampleSize;
    }

    private void setReadingAdtsHeaderState() {
        this.state = 2;
        this.bytesRead = 0;
    }

    private void findNextSample(ParsableByteArray pesBuffer) {
        byte[] adtsData = pesBuffer.data;
        int position = pesBuffer.getPosition();
        int endOffset = pesBuffer.limit();
        block6: while (position < endOffset) {
            int data = adtsData[position++] & 0xFF;
            if (this.matchState == 512 && data >= 240 && data != 255) {
                this.hasCrc = (data & 1) == 0;
                this.setReadingAdtsHeaderState();
                pesBuffer.setPosition(position);
                return;
            }
            switch (this.matchState | data) {
                case 511: {
                    this.matchState = 512;
                    continue block6;
                }
                case 329: {
                    this.matchState = 768;
                    continue block6;
                }
                case 836: {
                    this.matchState = 1024;
                    continue block6;
                }
                case 1075: {
                    this.setReadingId3HeaderState();
                    pesBuffer.setPosition(position);
                    return;
                }
            }
            if (this.matchState == 256) continue;
            this.matchState = 256;
            --position;
        }
        pesBuffer.setPosition(position);
    }

    private void parseId3Header() {
        this.id3Output.sampleData(this.id3HeaderBuffer, 10);
        this.id3HeaderBuffer.setPosition(6);
        this.setReadingSampleState(this.id3Output, 0L, 10, this.id3HeaderBuffer.readSynchSafeInt() + 10);
    }

    private void parseAdtsHeader() {
        this.adtsScratch.setPosition(0);
        if (!this.hasOutputFormat) {
            int audioObjectType = this.adtsScratch.readBits(2) + 1;
            if (audioObjectType != 2) {
                Log.w((String)TAG, (String)("Detected audio object type: " + audioObjectType + ", but assuming AAC LC."));
                audioObjectType = 2;
            }
            int sampleRateIndex = this.adtsScratch.readBits(4);
            this.adtsScratch.skipBits(1);
            int channelConfig = this.adtsScratch.readBits(3);
            byte[] audioSpecificConfig = CodecSpecificDataUtil.buildAacAudioSpecificConfig(audioObjectType, sampleRateIndex, channelConfig);
            Pair<Integer, Integer> audioParams = CodecSpecificDataUtil.parseAacAudioSpecificConfig(audioSpecificConfig);
            Format format = Format.createAudioSampleFormat(null, "audio/mp4a-latm", null, -1, -1, (Integer)audioParams.second, (Integer)audioParams.first, Collections.singletonList(audioSpecificConfig), null, 0, this.language);
            this.sampleDurationUs = 1024000000L / (long)format.sampleRate;
            this.output.format(format);
            this.hasOutputFormat = true;
        } else {
            this.adtsScratch.skipBits(10);
        }
        this.adtsScratch.skipBits(4);
        int sampleSize = this.adtsScratch.readBits(13) - 2 - 5;
        if (this.hasCrc) {
            sampleSize -= 2;
        }
        this.setReadingSampleState(this.output, this.sampleDurationUs, 0, sampleSize);
    }

    private void readSample(ParsableByteArray data) {
        int bytesToRead = Math.min(data.bytesLeft(), this.sampleSize - this.bytesRead);
        this.currentOutput.sampleData(data, bytesToRead);
        this.bytesRead += bytesToRead;
        if (this.bytesRead == this.sampleSize) {
            this.currentOutput.sampleMetadata(this.timeUs, 1, this.sampleSize, 0, null);
            this.timeUs += this.currentSampleDuration;
            this.setFindingSampleState();
        }
    }
}

