/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ts.Ac3Reader;
import com.google.android.exoplayer2.extractor.ts.ElementaryStreamReader;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class Ac3Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        @Override
        public Extractor[] createExtractors() {
            return new Extractor[]{new Ac3Extractor()};
        }
    };
    private static final int MAX_SNIFF_BYTES = 8192;
    private static final int AC3_SYNC_WORD = 2935;
    private static final int MAX_SYNC_FRAME_SIZE = 2786;
    private static final int ID3_TAG = Util.getIntegerCodeForString("ID3");
    private final long firstSampleTimestampUs;
    private final ParsableByteArray sampleData;
    private Ac3Reader reader;
    private boolean startedPacket;

    public Ac3Extractor() {
        this(0L);
    }

    public Ac3Extractor(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.sampleData = new ParsableByteArray(2786);
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        ParsableByteArray scratch = new ParsableByteArray(10);
        int startPosition = 0;
        while (true) {
            input.peekFully(scratch.data, 0, 10);
            scratch.setPosition(0);
            if (scratch.readUnsignedInt24() != ID3_TAG) break;
            scratch.skipBytes(3);
            int length = scratch.readSynchSafeInt();
            startPosition += 10 + length;
            input.advancePeekPosition(length);
        }
        input.resetPeekPosition();
        input.advancePeekPosition(startPosition);
        int headerPosition = startPosition;
        int validFramesCount = 0;
        while (true) {
            input.peekFully(scratch.data, 0, 5);
            scratch.setPosition(0);
            int syncBytes = scratch.readUnsignedShort();
            if (syncBytes != 2935) {
                validFramesCount = 0;
                input.resetPeekPosition();
                if (++headerPosition - startPosition >= 8192) {
                    return false;
                }
                input.advancePeekPosition(headerPosition);
                continue;
            }
            if (++validFramesCount >= 4) {
                return true;
            }
            int frameSize = Ac3Util.parseAc3SyncframeSize(scratch.data);
            if (frameSize == -1) {
                return false;
            }
            input.advancePeekPosition(frameSize - 5);
        }
    }

    @Override
    public void init(ExtractorOutput output) {
        this.reader = new Ac3Reader();
        this.reader.init(output, new ElementaryStreamReader.TrackIdGenerator(0, 1));
        output.endTracks();
        output.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
    }

    @Override
    public void seek(long position) {
        this.startedPacket = false;
        this.reader.seek();
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        int bytesRead = input.read(this.sampleData.data, 0, 2786);
        if (bytesRead == -1) {
            return -1;
        }
        this.sampleData.setPosition(0);
        this.sampleData.setLimit(bytesRead);
        if (!this.startedPacket) {
            this.reader.packetStarted(this.firstSampleTimestampUs, true);
            this.startedPacket = true;
        }
        this.reader.consume(this.sampleData);
        return 0;
    }
}

