/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.rawcc;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public final class RawCcExtractor
implements Extractor {
    private static final int SCRATCH_SIZE = 9;
    private static final int HEADER_SIZE = 8;
    private static final int HEADER_ID = Util.getIntegerCodeForString("RCC\u0001");
    private static final int TIMESTAMP_SIZE_V0 = 4;
    private static final int TIMESTAMP_SIZE_V1 = 8;
    private static final int STATE_READING_HEADER = 0;
    private static final int STATE_READING_TIMESTAMP_AND_COUNT = 1;
    private static final int STATE_READING_SAMPLES = 2;
    private final ParsableByteArray dataScratch = new ParsableByteArray(9);
    private ExtractorOutput extractorOutput;
    private TrackOutput trackOutput;
    private int parserState = 0;
    private int version;
    private long timestampUs;
    private int remainingSampleCount;
    private int sampleBytesWritten;

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        this.trackOutput = this.extractorOutput.track(0);
        this.extractorOutput.endTracks();
        this.trackOutput.format(Format.createTextSampleFormat(null, "application/cea-608", null, -1, 0, null, null));
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        this.dataScratch.reset();
        input.peekFully(this.dataScratch.data, 0, 8);
        return this.dataScratch.readInt() == HEADER_ID;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        block5: while (true) {
            switch (this.parserState) {
                case 0: {
                    this.parseHeader(input);
                    this.parserState = 1;
                    continue block5;
                }
                case 1: {
                    if (this.parseTimestampAndSampleCount(input)) {
                        this.parserState = 2;
                        continue block5;
                    }
                    this.parserState = 0;
                    return -1;
                }
                case 2: {
                    this.parseSamples(input);
                    this.parserState = 1;
                    return 0;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public void seek(long position) {
        this.parserState = 0;
    }

    @Override
    public void release() {
    }

    private void parseHeader(ExtractorInput input) throws IOException, InterruptedException {
        this.dataScratch.reset();
        input.readFully(this.dataScratch.data, 0, 8);
        if (this.dataScratch.readInt() != HEADER_ID) {
            throw new IOException("Input not RawCC");
        }
        this.version = this.dataScratch.readUnsignedByte();
    }

    private boolean parseTimestampAndSampleCount(ExtractorInput input) throws IOException, InterruptedException {
        this.dataScratch.reset();
        if (this.version == 0) {
            if (!input.readFully(this.dataScratch.data, 0, 5, true)) {
                return false;
            }
            this.timestampUs = this.dataScratch.readUnsignedInt() * 1000L / 45L;
        } else if (this.version == 1) {
            if (!input.readFully(this.dataScratch.data, 0, 9, true)) {
                return false;
            }
            this.timestampUs = this.dataScratch.readLong();
        } else {
            throw new ParserException("Unsupported version number: " + this.version);
        }
        this.remainingSampleCount = this.dataScratch.readUnsignedByte();
        this.sampleBytesWritten = 0;
        return true;
    }

    private void parseSamples(ExtractorInput input) throws IOException, InterruptedException {
        while (this.remainingSampleCount > 0) {
            this.dataScratch.reset();
            input.readFully(this.dataScratch.data, 0, 3);
            this.trackOutput.sampleData(this.dataScratch, 3);
            this.sampleBytesWritten += 3;
            --this.remainingSampleCount;
        }
        if (this.sampleBytesWritten > 0) {
            this.trackOutput.sampleMetadata(this.timestampUs, 1, this.sampleBytesWritten, 0, null);
        }
    }
}

