/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.util.Assertions;

final class VorbisBitArray {
    public final byte[] data;
    private int limit;
    private int byteOffset;
    private int bitOffset;

    public VorbisBitArray(byte[] data) {
        this(data, data.length);
    }

    public VorbisBitArray(byte[] data, int limit) {
        this.data = data;
        this.limit = limit * 8;
    }

    public void reset() {
        this.byteOffset = 0;
        this.bitOffset = 0;
    }

    public boolean readBit() {
        return this.readBits(1) == 1;
    }

    public int readBits(int numBits) {
        Assertions.checkState(this.getPosition() + numBits <= this.limit);
        if (numBits == 0) {
            return 0;
        }
        int result = 0;
        int bitCount = 0;
        if (this.bitOffset != 0) {
            bitCount = Math.min(numBits, 8 - this.bitOffset);
            int mask = 255 >>> 8 - bitCount;
            result = this.data[this.byteOffset] >>> this.bitOffset & mask;
            this.bitOffset += bitCount;
            if (this.bitOffset == 8) {
                ++this.byteOffset;
                this.bitOffset = 0;
            }
        }
        if (numBits - bitCount > 7) {
            int numBytes = (numBits - bitCount) / 8;
            for (int i = 0; i < numBytes; ++i) {
                result = (int)((long)result | ((long)this.data[this.byteOffset++] & 0xFFL) << bitCount);
                bitCount += 8;
            }
        }
        if (numBits > bitCount) {
            int bitsOnNextByte = numBits - bitCount;
            int mask = 255 >>> 8 - bitsOnNextByte;
            result |= (this.data[this.byteOffset] & mask) << bitCount;
            this.bitOffset += bitsOnNextByte;
        }
        return result;
    }

    public void skipBits(int numberOfBits) {
        Assertions.checkState(this.getPosition() + numberOfBits <= this.limit);
        this.byteOffset += numberOfBits / 8;
        this.bitOffset += numberOfBits % 8;
        if (this.bitOffset > 7) {
            ++this.byteOffset;
            this.bitOffset -= 8;
        }
    }

    public int getPosition() {
        return this.byteOffset * 8 + this.bitOffset;
    }

    public void setPosition(int position) {
        Assertions.checkArgument(position < this.limit && position >= 0);
        this.byteOffset = position / 8;
        this.bitOffset = position - this.byteOffset * 8;
    }

    public int bitsLeft() {
        return this.limit - this.getPosition();
    }

    public int limit() {
        return this.limit;
    }
}

