/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.ogg.FlacReader;
import com.google.android.exoplayer2.extractor.ogg.OggPageHeader;
import com.google.android.exoplayer2.extractor.ogg.OpusReader;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.extractor.ogg.VorbisReader;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;

public class OggExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        @Override
        public Extractor[] createExtractors() {
            return new Extractor[]{new OggExtractor()};
        }
    };
    private static final int MAX_VERIFICATION_BYTES = 8;
    private StreamReader streamReader;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        try {
            OggPageHeader header = new OggPageHeader();
            if (!header.populate(input, true) || (header.type & 2) != 2) {
                return false;
            }
            int length = Math.min(header.bodySize, 8);
            ParsableByteArray scratch = new ParsableByteArray(length);
            input.peekFully(scratch.data, 0, length);
            if (FlacReader.verifyBitstreamType(OggExtractor.resetPosition(scratch))) {
                this.streamReader = new FlacReader();
            } else if (VorbisReader.verifyBitstreamType(OggExtractor.resetPosition(scratch))) {
                this.streamReader = new VorbisReader();
            } else if (OpusReader.verifyBitstreamType(OggExtractor.resetPosition(scratch))) {
                this.streamReader = new OpusReader();
            } else {
                return false;
            }
            return true;
        }
        catch (ParserException e) {
            return false;
        }
    }

    @Override
    public void init(ExtractorOutput output) {
        TrackOutput trackOutput = output.track(0);
        output.endTracks();
        this.streamReader.init(output, trackOutput);
    }

    @Override
    public void seek(long position) {
        this.streamReader.seek(position);
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        return this.streamReader.read(input, seekPosition);
    }

    StreamReader getStreamReader() {
        return this.streamReader;
    }

    private static ParsableByteArray resetPosition(ParsableByteArray scratch) {
        scratch.setPosition(0);
        return scratch;
    }
}

