/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.ogg.OggPageHeader;
import com.google.android.exoplayer2.extractor.ogg.OggSeeker;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.Assertions;
import java.io.EOFException;
import java.io.IOException;

final class DefaultOggSeeker
implements OggSeeker {
    public static final int MATCH_RANGE = 72000;
    public static final int MATCH_BYTE_RANGE = 100000;
    private static final int DEFAULT_OFFSET = 30000;
    private static final int STATE_SEEK_TO_END = 0;
    private static final int STATE_READ_LAST_PAGE = 1;
    private static final int STATE_SEEK = 2;
    private static final int STATE_IDLE = 3;
    private final OggPageHeader pageHeader = new OggPageHeader();
    private final long startPosition;
    private final long endPosition;
    private final StreamReader streamReader;
    private int state;
    private long totalGranules;
    private volatile long queriedGranule;
    private long positionBeforeSeekToEnd;
    private long targetGranule;
    private long start;
    private long end;
    private long startGranule;
    private long endGranule;

    public DefaultOggSeeker(long startPosition, long endPosition, StreamReader streamReader) {
        Assertions.checkArgument(startPosition >= 0L && endPosition > startPosition);
        this.streamReader = streamReader;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.state = 0;
    }

    @Override
    public long read(ExtractorInput input) throws IOException, InterruptedException {
        switch (this.state) {
            case 3: {
                return -1L;
            }
            case 0: {
                this.positionBeforeSeekToEnd = input.getPosition();
                this.state = 1;
                long lastPagePosition = this.endPosition - 65307L;
                if (lastPagePosition > this.positionBeforeSeekToEnd) {
                    return lastPagePosition;
                }
            }
            case 1: {
                this.totalGranules = this.readGranuleOfLastPage(input);
                this.state = 3;
                return this.positionBeforeSeekToEnd;
            }
            case 2: {
                long currentGranule;
                if (this.targetGranule == 0L) {
                    currentGranule = 0L;
                } else {
                    long position = this.getNextSeekPosition(this.targetGranule, input);
                    if (position >= 0L) {
                        return position;
                    }
                    currentGranule = this.skipToPageOfGranule(input, this.targetGranule, -(position + 2L));
                }
                this.state = 3;
                return -(currentGranule + 2L);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public long startSeek() {
        Assertions.checkArgument(this.state == 3 || this.state == 2);
        this.targetGranule = this.queriedGranule;
        this.state = 2;
        this.resetSeeking();
        return this.targetGranule;
    }

    @Override
    public OggSeekMap createSeekMap() {
        return this.totalGranules != 0L ? new OggSeekMap() : null;
    }

    public void resetSeeking() {
        this.start = this.startPosition;
        this.end = this.endPosition;
        this.startGranule = 0L;
        this.endGranule = this.totalGranules;
    }

    public long getNextSeekPosition(long targetGranule, ExtractorInput input) throws IOException, InterruptedException {
        if (this.start == this.end) {
            return -(this.startGranule + 2L);
        }
        long initialPosition = input.getPosition();
        if (!this.skipToNextPage(input, this.end)) {
            if (this.start == initialPosition) {
                throw new IOException("No ogg page can be found.");
            }
            return this.start;
        }
        this.pageHeader.populate(input, false);
        input.resetPeekPosition();
        long granuleDistance = targetGranule - this.pageHeader.granulePosition;
        int pageSize = this.pageHeader.headerSize + this.pageHeader.bodySize;
        if (granuleDistance < 0L || granuleDistance > 72000L) {
            if (granuleDistance < 0L) {
                this.end = initialPosition;
                this.endGranule = this.pageHeader.granulePosition;
            } else {
                this.start = input.getPosition() + (long)pageSize;
                this.startGranule = this.pageHeader.granulePosition;
                if (this.end - this.start + (long)pageSize < 100000L) {
                    input.skipFully(pageSize);
                    return -(this.startGranule + 2L);
                }
            }
            if (this.end - this.start < 100000L) {
                this.end = this.start;
                return this.start;
            }
            long offset = pageSize * (granuleDistance <= 0L ? 2 : 1);
            long nextPosition = input.getPosition() - offset + granuleDistance * (this.end - this.start) / (this.endGranule - this.startGranule);
            nextPosition = Math.max(nextPosition, this.start);
            nextPosition = Math.min(nextPosition, this.end - 1L);
            return nextPosition;
        }
        input.skipFully(pageSize);
        return -(this.pageHeader.granulePosition + 2L);
    }

    private long getEstimatedPosition(long position, long granuleDistance, long offset) {
        if ((position += granuleDistance * (this.endPosition - this.startPosition) / this.totalGranules - offset) < this.startPosition) {
            position = this.startPosition;
        }
        if (position >= this.endPosition) {
            position = this.endPosition - 1L;
        }
        return position;
    }

    void skipToNextPage(ExtractorInput input) throws IOException, InterruptedException {
        if (!this.skipToNextPage(input, this.endPosition)) {
            throw new EOFException();
        }
    }

    boolean skipToNextPage(ExtractorInput input, long until) throws IOException, InterruptedException {
        until = Math.min(until + 3L, this.endPosition);
        byte[] buffer = new byte[2048];
        int peekLength = buffer.length;
        while (input.getPosition() + (long)peekLength <= until || (peekLength = (int)(until - input.getPosition())) >= 4) {
            input.peekFully(buffer, 0, peekLength, false);
            for (int i = 0; i < peekLength - 3; ++i) {
                if (buffer[i] != 79 || buffer[i + 1] != 103 || buffer[i + 2] != 103 || buffer[i + 3] != 83) continue;
                input.skipFully(i);
                return true;
            }
            input.skipFully(peekLength - 3);
        }
        return false;
    }

    long readGranuleOfLastPage(ExtractorInput input) throws IOException, InterruptedException {
        this.skipToNextPage(input);
        this.pageHeader.reset();
        while ((this.pageHeader.type & 4) != 4 && input.getPosition() < this.endPosition) {
            this.pageHeader.populate(input, false);
            input.skipFully(this.pageHeader.headerSize + this.pageHeader.bodySize);
        }
        return this.pageHeader.granulePosition;
    }

    long skipToPageOfGranule(ExtractorInput input, long targetGranule, long currentGranule) throws IOException, InterruptedException {
        this.pageHeader.populate(input, false);
        while (this.pageHeader.granulePosition < targetGranule) {
            input.skipFully(this.pageHeader.headerSize + this.pageHeader.bodySize);
            currentGranule = this.pageHeader.granulePosition;
            this.pageHeader.populate(input, false);
        }
        input.resetPeekPosition();
        return currentGranule;
    }

    private class OggSeekMap
    implements SeekMap {
        private OggSeekMap() {
        }

        @Override
        public boolean isSeekable() {
            return true;
        }

        @Override
        public long getPosition(long timeUs) {
            if (timeUs == 0L) {
                DefaultOggSeeker.this.queriedGranule = 0L;
                return DefaultOggSeeker.this.startPosition;
            }
            DefaultOggSeeker.this.queriedGranule = DefaultOggSeeker.this.streamReader.convertTimeToGranule(timeUs);
            return DefaultOggSeeker.this.getEstimatedPosition(DefaultOggSeeker.this.startPosition, DefaultOggSeeker.this.queriedGranule, 30000L);
        }

        @Override
        public long getDurationUs() {
            return DefaultOggSeeker.this.streamReader.convertGranuleToTime(DefaultOggSeeker.this.totalGranules);
        }
    }
}

