/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.mp4.Atom;
import com.google.android.exoplayer2.extractor.mp4.FixedSampleSizeRechunker;
import com.google.android.exoplayer2.extractor.mp4.Track;
import com.google.android.exoplayer2.extractor.mp4.TrackEncryptionBox;
import com.google.android.exoplayer2.extractor.mp4.TrackSampleTable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.AvcConfig;
import com.google.android.exoplayer2.video.HevcConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class AtomParsers {
    private static final String TAG = "AtomParsers";
    private static final int TYPE_vide = Util.getIntegerCodeForString("vide");
    private static final int TYPE_soun = Util.getIntegerCodeForString("soun");
    private static final int TYPE_text = Util.getIntegerCodeForString("text");
    private static final int TYPE_sbtl = Util.getIntegerCodeForString("sbtl");
    private static final int TYPE_subt = Util.getIntegerCodeForString("subt");
    private static final int TYPE_clcp = Util.getIntegerCodeForString("clcp");
    private static final int TYPE_cenc = Util.getIntegerCodeForString("cenc");

    public static Track parseTrak(Atom.ContainerAtom trak, Atom.LeafAtom mvhd, long duration, DrmInitData drmInitData, boolean isQuickTime) throws ParserException {
        Atom.ContainerAtom mdia = trak.getContainerAtomOfType(Atom.TYPE_mdia);
        int trackType = AtomParsers.parseHdlr(mdia.getLeafAtomOfType((int)Atom.TYPE_hdlr).data);
        if (trackType == -1) {
            return null;
        }
        TkhdData tkhdData = AtomParsers.parseTkhd(trak.getLeafAtomOfType((int)Atom.TYPE_tkhd).data);
        if (duration == -9223372036854775807L) {
            duration = tkhdData.duration;
        }
        long movieTimescale = AtomParsers.parseMvhd(mvhd.data);
        long durationUs = duration == -9223372036854775807L ? -9223372036854775807L : Util.scaleLargeTimestamp(duration, 1000000L, movieTimescale);
        Atom.ContainerAtom stbl = mdia.getContainerAtomOfType(Atom.TYPE_minf).getContainerAtomOfType(Atom.TYPE_stbl);
        Pair<Long, String> mdhdData = AtomParsers.parseMdhd(mdia.getLeafAtomOfType((int)Atom.TYPE_mdhd).data);
        StsdData stsdData = AtomParsers.parseStsd(stbl.getLeafAtomOfType((int)Atom.TYPE_stsd).data, tkhdData.id, tkhdData.rotationDegrees, (String)mdhdData.second, drmInitData, isQuickTime);
        Pair<long[], long[]> edtsData = AtomParsers.parseEdts(trak.getContainerAtomOfType(Atom.TYPE_edts));
        return stsdData.format == null ? null : new Track(tkhdData.id, trackType, (Long)mdhdData.first, movieTimescale, durationUs, stsdData.format, stsdData.requiredSampleTransformation, stsdData.trackEncryptionBoxes, stsdData.nalUnitLengthFieldLength, (long[])edtsData.first, (long[])edtsData.second);
    }

    public static TrackSampleTable parseStbl(Track track, Atom.ContainerAtom stblAtom, GaplessInfoHolder gaplessInfoHolder) throws ParserException {
        int i;
        int[] flags;
        long[] timestamps;
        int[] sizes;
        long[] offsets;
        SampleSizeBox sampleSizeBox;
        Atom.LeafAtom stszAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_stsz);
        if (stszAtom != null) {
            sampleSizeBox = new StszSampleSizeBox(stszAtom);
        } else {
            Atom.LeafAtom stz2Atom = stblAtom.getLeafAtomOfType(Atom.TYPE_stz2);
            if (stz2Atom == null) {
                throw new ParserException("Track has no sample table size information");
            }
            sampleSizeBox = new Stz2SampleSizeBox(stz2Atom);
        }
        int sampleCount = sampleSizeBox.getSampleCount();
        if (sampleCount == 0) {
            return new TrackSampleTable(new long[0], new int[0], 0, new long[0], new int[0]);
        }
        boolean chunkOffsetsAreLongs = false;
        Atom.LeafAtom chunkOffsetsAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_stco);
        if (chunkOffsetsAtom == null) {
            chunkOffsetsAreLongs = true;
            chunkOffsetsAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_co64);
        }
        ParsableByteArray chunkOffsets = chunkOffsetsAtom.data;
        ParsableByteArray stsc = stblAtom.getLeafAtomOfType((int)Atom.TYPE_stsc).data;
        ParsableByteArray stts = stblAtom.getLeafAtomOfType((int)Atom.TYPE_stts).data;
        Atom.LeafAtom stssAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_stss);
        ParsableByteArray stss = stssAtom != null ? stssAtom.data : null;
        Atom.LeafAtom cttsAtom = stblAtom.getLeafAtomOfType(Atom.TYPE_ctts);
        ParsableByteArray ctts = cttsAtom != null ? cttsAtom.data : null;
        ChunkIterator chunkIterator = new ChunkIterator(stsc, chunkOffsets, chunkOffsetsAreLongs);
        stts.setPosition(12);
        int remainingTimestampDeltaChanges = stts.readUnsignedIntToInt() - 1;
        int remainingSamplesAtTimestampDelta = stts.readUnsignedIntToInt();
        int timestampDeltaInTimeUnits = stts.readUnsignedIntToInt();
        int remainingSamplesAtTimestampOffset = 0;
        int remainingTimestampOffsetChanges = 0;
        int timestampOffset = 0;
        if (ctts != null) {
            ctts.setPosition(12);
            remainingTimestampOffsetChanges = ctts.readUnsignedIntToInt();
        }
        int nextSynchronizationSampleIndex = -1;
        int remainingSynchronizationSamples = 0;
        if (stss != null) {
            stss.setPosition(12);
            remainingSynchronizationSamples = stss.readUnsignedIntToInt();
            if (remainingSynchronizationSamples > 0) {
                nextSynchronizationSampleIndex = stss.readUnsignedIntToInt() - 1;
            } else {
                stss = null;
            }
        }
        boolean isRechunkable = sampleSizeBox.isFixedSampleSize() && "audio/raw".equals(track.format.sampleMimeType) && remainingTimestampDeltaChanges == 0 && remainingTimestampOffsetChanges == 0 && remainingSynchronizationSamples == 0;
        int maximumSize = 0;
        long timestampTimeUnits = 0L;
        if (!isRechunkable) {
            offsets = new long[sampleCount];
            sizes = new int[sampleCount];
            timestamps = new long[sampleCount];
            flags = new int[sampleCount];
            long offset = 0L;
            int remainingSamplesInChunk = 0;
            for (i = 0; i < sampleCount; ++i) {
                while (remainingSamplesInChunk == 0) {
                    Assertions.checkState(chunkIterator.moveNext());
                    offset = chunkIterator.offset;
                    remainingSamplesInChunk = chunkIterator.numSamples;
                }
                if (ctts != null) {
                    while (remainingSamplesAtTimestampOffset == 0 && remainingTimestampOffsetChanges > 0) {
                        remainingSamplesAtTimestampOffset = ctts.readUnsignedIntToInt();
                        timestampOffset = ctts.readInt();
                        --remainingTimestampOffsetChanges;
                    }
                    --remainingSamplesAtTimestampOffset;
                }
                offsets[i] = offset;
                sizes[i] = sampleSizeBox.readNextSampleSize();
                if (sizes[i] > maximumSize) {
                    maximumSize = sizes[i];
                }
                timestamps[i] = timestampTimeUnits + (long)timestampOffset;
                int n = flags[i] = stss == null ? 1 : 0;
                if (i == nextSynchronizationSampleIndex) {
                    flags[i] = 1;
                    if (--remainingSynchronizationSamples > 0) {
                        nextSynchronizationSampleIndex = stss.readUnsignedIntToInt() - 1;
                    }
                }
                timestampTimeUnits += (long)timestampDeltaInTimeUnits;
                if (--remainingSamplesAtTimestampDelta == 0 && remainingTimestampDeltaChanges > 0) {
                    remainingSamplesAtTimestampDelta = stts.readUnsignedIntToInt();
                    timestampDeltaInTimeUnits = stts.readUnsignedIntToInt();
                    --remainingTimestampDeltaChanges;
                }
                offset += (long)sizes[i];
                --remainingSamplesInChunk;
            }
            Assertions.checkArgument(remainingSamplesAtTimestampOffset == 0);
            while (remainingTimestampOffsetChanges > 0) {
                Assertions.checkArgument(ctts.readUnsignedIntToInt() == 0);
                ctts.readInt();
                --remainingTimestampOffsetChanges;
            }
            if (remainingSynchronizationSamples != 0 || remainingSamplesAtTimestampDelta != 0 || remainingSamplesInChunk != 0 || remainingTimestampDeltaChanges != 0) {
                Log.w((String)TAG, (String)("Inconsistent stbl box for track " + track.id + ": remainingSynchronizationSamples " + remainingSynchronizationSamples + ", remainingSamplesAtTimestampDelta " + remainingSamplesAtTimestampDelta + ", remainingSamplesInChunk " + remainingSamplesInChunk + ", remainingTimestampDeltaChanges " + remainingTimestampDeltaChanges));
            }
        } else {
            long[] chunkOffsetsBytes = new long[chunkIterator.length];
            int[] chunkSampleCounts = new int[chunkIterator.length];
            while (chunkIterator.moveNext()) {
                chunkOffsetsBytes[chunkIterator.index] = chunkIterator.offset;
                chunkSampleCounts[chunkIterator.index] = chunkIterator.numSamples;
            }
            int fixedSampleSize = sampleSizeBox.readNextSampleSize();
            FixedSampleSizeRechunker.Results rechunkedResults = FixedSampleSizeRechunker.rechunk(fixedSampleSize, chunkOffsetsBytes, chunkSampleCounts, timestampDeltaInTimeUnits);
            offsets = rechunkedResults.offsets;
            sizes = rechunkedResults.sizes;
            maximumSize = rechunkedResults.maximumSize;
            timestamps = rechunkedResults.timestamps;
            flags = rechunkedResults.flags;
        }
        if (track.editListDurations == null || gaplessInfoHolder.hasGaplessInfo()) {
            Util.scaleLargeTimestampsInPlace(timestamps, 1000000L, track.timescale);
            return new TrackSampleTable(offsets, sizes, maximumSize, timestamps, flags);
        }
        if (track.editListDurations.length == 1 && track.type == 1 && timestamps.length >= 2) {
            long editStartTime = track.editListMediaTimes[0];
            long editEndTime = editStartTime + Util.scaleLargeTimestamp(track.editListDurations[0], track.timescale, track.movieTimescale);
            long lastSampleEndTime = timestampTimeUnits;
            if (timestamps[0] <= editStartTime && editStartTime < timestamps[1] && timestamps[timestamps.length - 1] < editEndTime && editEndTime <= lastSampleEndTime) {
                long paddingTimeUnits = lastSampleEndTime - editEndTime;
                long encoderDelay = Util.scaleLargeTimestamp(editStartTime - timestamps[0], track.format.sampleRate, track.timescale);
                long encoderPadding = Util.scaleLargeTimestamp(paddingTimeUnits, track.format.sampleRate, track.timescale);
                if ((encoderDelay != 0L || encoderPadding != 0L) && encoderDelay <= Integer.MAX_VALUE && encoderPadding <= Integer.MAX_VALUE) {
                    gaplessInfoHolder.encoderDelay = (int)encoderDelay;
                    gaplessInfoHolder.encoderPadding = (int)encoderPadding;
                    Util.scaleLargeTimestampsInPlace(timestamps, 1000000L, track.timescale);
                    return new TrackSampleTable(offsets, sizes, maximumSize, timestamps, flags);
                }
            }
        }
        if (track.editListDurations.length == 1 && track.editListDurations[0] == 0L) {
            for (int i2 = 0; i2 < timestamps.length; ++i2) {
                timestamps[i2] = Util.scaleLargeTimestamp(timestamps[i2] - track.editListMediaTimes[0], 1000000L, track.timescale);
            }
            return new TrackSampleTable(offsets, sizes, maximumSize, timestamps, flags);
        }
        int editedSampleCount = 0;
        int nextSampleIndex = 0;
        boolean copyMetadata = false;
        for (i = 0; i < track.editListDurations.length; ++i) {
            long mediaTime = track.editListMediaTimes[i];
            if (mediaTime == -1L) continue;
            long duration = Util.scaleLargeTimestamp(track.editListDurations[i], track.timescale, track.movieTimescale);
            int startIndex = Util.binarySearchCeil(timestamps, mediaTime, true, true);
            int endIndex = Util.binarySearchCeil(timestamps, mediaTime + duration, true, false);
            editedSampleCount += endIndex - startIndex;
            copyMetadata |= nextSampleIndex != startIndex;
            nextSampleIndex = endIndex;
        }
        long[] editedOffsets = (copyMetadata |= editedSampleCount != sampleCount) ? new long[editedSampleCount] : offsets;
        int[] editedSizes = copyMetadata ? new int[editedSampleCount] : sizes;
        int editedMaximumSize = copyMetadata ? 0 : maximumSize;
        int[] editedFlags = copyMetadata ? new int[editedSampleCount] : flags;
        long[] editedTimestamps = new long[editedSampleCount];
        long pts = 0L;
        int sampleIndex = 0;
        for (int i3 = 0; i3 < track.editListDurations.length; ++i3) {
            long mediaTime = track.editListMediaTimes[i3];
            long duration = track.editListDurations[i3];
            if (mediaTime != -1L) {
                long endMediaTime = mediaTime + Util.scaleLargeTimestamp(duration, track.timescale, track.movieTimescale);
                int startIndex = Util.binarySearchCeil(timestamps, mediaTime, true, true);
                int endIndex = Util.binarySearchCeil(timestamps, endMediaTime, true, false);
                if (copyMetadata) {
                    int count = endIndex - startIndex;
                    System.arraycopy(offsets, startIndex, editedOffsets, sampleIndex, count);
                    System.arraycopy(sizes, startIndex, editedSizes, sampleIndex, count);
                    System.arraycopy(flags, startIndex, editedFlags, sampleIndex, count);
                }
                for (int j = startIndex; j < endIndex; ++j) {
                    long ptsUs = Util.scaleLargeTimestamp(pts, 1000000L, track.movieTimescale);
                    long timeInSegmentUs = Util.scaleLargeTimestamp(timestamps[j] - mediaTime, 1000000L, track.timescale);
                    editedTimestamps[sampleIndex] = ptsUs + timeInSegmentUs;
                    if (copyMetadata && editedSizes[sampleIndex] > editedMaximumSize) {
                        editedMaximumSize = sizes[j];
                    }
                    ++sampleIndex;
                }
            }
            pts += duration;
        }
        boolean hasSyncSample = false;
        for (int i4 = 0; i4 < editedFlags.length && !hasSyncSample; hasSyncSample |= (editedFlags[i4] & 1) != 0, ++i4) {
        }
        if (!hasSyncSample) {
            throw new ParserException("The edited sample sequence does not contain a sync sample.");
        }
        return new TrackSampleTable(editedOffsets, editedSizes, editedMaximumSize, editedTimestamps, editedFlags);
    }

    public static void parseUdta(Atom.LeafAtom udtaAtom, boolean isQuickTime, GaplessInfoHolder out) {
        if (isQuickTime) {
            return;
        }
        ParsableByteArray udtaData = udtaAtom.data;
        udtaData.setPosition(8);
        while (udtaData.bytesLeft() >= 8) {
            int atomSize = udtaData.readInt();
            int atomType = udtaData.readInt();
            if (atomType == Atom.TYPE_meta) {
                udtaData.setPosition(udtaData.getPosition() - 8);
                udtaData.setLimit(udtaData.getPosition() + atomSize);
                AtomParsers.parseMetaAtom(udtaData, out);
                break;
            }
            udtaData.skipBytes(atomSize - 8);
        }
    }

    private static void parseMetaAtom(ParsableByteArray data, GaplessInfoHolder out) {
        data.skipBytes(12);
        ParsableByteArray ilst = new ParsableByteArray();
        while (data.bytesLeft() >= 8) {
            int payloadSize = data.readInt() - 8;
            int atomType = data.readInt();
            if (atomType == Atom.TYPE_ilst) {
                ilst.reset(data.data, data.getPosition() + payloadSize);
                ilst.setPosition(data.getPosition());
                AtomParsers.parseIlst(ilst, out);
                if (out.hasGaplessInfo()) {
                    return;
                }
            }
            data.skipBytes(payloadSize);
        }
    }

    private static void parseIlst(ParsableByteArray ilst, GaplessInfoHolder out) {
        while (ilst.bytesLeft() > 0) {
            int position = ilst.getPosition();
            int endPosition = position + ilst.readInt();
            int type = ilst.readInt();
            if (type == Atom.TYPE_DASHES) {
                String lastCommentMean = null;
                String lastCommentName = null;
                String lastCommentData = null;
                while (ilst.getPosition() < endPosition) {
                    int length = ilst.readInt() - 12;
                    int key = ilst.readInt();
                    ilst.skipBytes(4);
                    if (key == Atom.TYPE_mean) {
                        lastCommentMean = ilst.readString(length);
                        continue;
                    }
                    if (key == Atom.TYPE_name) {
                        lastCommentName = ilst.readString(length);
                        continue;
                    }
                    if (key == Atom.TYPE_data) {
                        ilst.skipBytes(4);
                        lastCommentData = ilst.readString(length - 4);
                        continue;
                    }
                    ilst.skipBytes(length);
                }
                if (lastCommentName == null || lastCommentData == null || !"com.apple.iTunes".equals(lastCommentMean)) continue;
                out.setFromComment(lastCommentName, lastCommentData);
                break;
            }
            ilst.setPosition(endPosition);
        }
    }

    private static long parseMvhd(ParsableByteArray mvhd) {
        mvhd.setPosition(8);
        int fullAtom = mvhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        mvhd.skipBytes(version == 0 ? 8 : 16);
        return mvhd.readUnsignedInt();
    }

    private static TkhdData parseTkhd(ParsableByteArray tkhd) {
        long duration;
        tkhd.setPosition(8);
        int fullAtom = tkhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        tkhd.skipBytes(version == 0 ? 8 : 16);
        int trackId = tkhd.readInt();
        tkhd.skipBytes(4);
        boolean durationUnknown = true;
        int durationPosition = tkhd.getPosition();
        int durationByteCount = version == 0 ? 4 : 8;
        for (int i = 0; i < durationByteCount; ++i) {
            if (tkhd.data[durationPosition + i] == -1) continue;
            durationUnknown = false;
            break;
        }
        if (durationUnknown) {
            tkhd.skipBytes(durationByteCount);
            duration = -9223372036854775807L;
        } else {
            long l = duration = version == 0 ? tkhd.readUnsignedInt() : tkhd.readUnsignedLongToLong();
            if (duration == 0L) {
                duration = -9223372036854775807L;
            }
        }
        tkhd.skipBytes(16);
        int a00 = tkhd.readInt();
        int a01 = tkhd.readInt();
        tkhd.skipBytes(4);
        int a10 = tkhd.readInt();
        int a11 = tkhd.readInt();
        int fixedOne = 65536;
        int rotationDegrees = a00 == 0 && a01 == fixedOne && a10 == -fixedOne && a11 == 0 ? 90 : (a00 == 0 && a01 == -fixedOne && a10 == fixedOne && a11 == 0 ? 270 : (a00 == -fixedOne && a01 == 0 && a10 == 0 && a11 == -fixedOne ? 180 : 0));
        return new TkhdData(trackId, duration, rotationDegrees);
    }

    private static int parseHdlr(ParsableByteArray hdlr) {
        hdlr.setPosition(16);
        int trackType = hdlr.readInt();
        if (trackType == TYPE_soun) {
            return 1;
        }
        if (trackType == TYPE_vide) {
            return 2;
        }
        if (trackType == TYPE_text || trackType == TYPE_sbtl || trackType == TYPE_subt || trackType == TYPE_clcp) {
            return 3;
        }
        return -1;
    }

    private static Pair<Long, String> parseMdhd(ParsableByteArray mdhd) {
        mdhd.setPosition(8);
        int fullAtom = mdhd.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        mdhd.skipBytes(version == 0 ? 8 : 16);
        long timescale = mdhd.readUnsignedInt();
        mdhd.skipBytes(version == 0 ? 4 : 8);
        int languageCode = mdhd.readUnsignedShort();
        String language = "" + (char)((languageCode >> 10 & 0x1F) + 96) + (char)((languageCode >> 5 & 0x1F) + 96) + (char)((languageCode & 0x1F) + 96);
        return Pair.create((Object)timescale, (Object)language);
    }

    private static StsdData parseStsd(ParsableByteArray stsd, int trackId, int rotationDegrees, String language, DrmInitData drmInitData, boolean isQuickTime) throws ParserException {
        stsd.setPosition(12);
        int numberOfEntries = stsd.readInt();
        StsdData out = new StsdData(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            int childStartPosition = stsd.getPosition();
            int childAtomSize = stsd.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = stsd.readInt();
            if (childAtomType == Atom.TYPE_avc1 || childAtomType == Atom.TYPE_avc3 || childAtomType == Atom.TYPE_encv || childAtomType == Atom.TYPE_mp4v || childAtomType == Atom.TYPE_hvc1 || childAtomType == Atom.TYPE_hev1 || childAtomType == Atom.TYPE_s263 || childAtomType == Atom.TYPE_vp08 || childAtomType == Atom.TYPE_vp09) {
                AtomParsers.parseVideoSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, rotationDegrees, drmInitData, out, i);
            } else if (childAtomType == Atom.TYPE_mp4a || childAtomType == Atom.TYPE_enca || childAtomType == Atom.TYPE_ac_3 || childAtomType == Atom.TYPE_ec_3 || childAtomType == Atom.TYPE_dtsc || childAtomType == Atom.TYPE_dtse || childAtomType == Atom.TYPE_dtsh || childAtomType == Atom.TYPE_dtsl || childAtomType == Atom.TYPE_samr || childAtomType == Atom.TYPE_sawb || childAtomType == Atom.TYPE_lpcm || childAtomType == Atom.TYPE_sowt) {
                AtomParsers.parseAudioSampleEntry(stsd, childAtomType, childStartPosition, childAtomSize, trackId, language, isQuickTime, drmInitData, out, i);
            } else if (childAtomType == Atom.TYPE_TTML) {
                out.format = Format.createTextSampleFormat(Integer.toString(trackId), "application/ttml+xml", null, -1, 0, language, drmInitData);
            } else if (childAtomType == Atom.TYPE_tx3g) {
                out.format = Format.createTextSampleFormat(Integer.toString(trackId), "application/x-quicktime-tx3g", null, -1, 0, language, drmInitData);
            } else if (childAtomType == Atom.TYPE_wvtt) {
                out.format = Format.createTextSampleFormat(Integer.toString(trackId), "application/x-mp4vtt", null, -1, 0, language, drmInitData);
            } else if (childAtomType == Atom.TYPE_stpp) {
                out.format = Format.createTextSampleFormat(Integer.toString(trackId), "application/ttml+xml", null, -1, 0, language, drmInitData, 0L);
            } else if (childAtomType == Atom.TYPE_c608) {
                out.format = Format.createTextSampleFormat(Integer.toString(trackId), "application/cea-608", null, -1, 0, language, drmInitData);
                out.requiredSampleTransformation = 1;
            }
            stsd.setPosition(childStartPosition + childAtomSize);
        }
        return out;
    }

    private static void parseVideoSampleEntry(ParsableByteArray parent, int atomType, int position, int size, int trackId, int rotationDegrees, DrmInitData drmInitData, StsdData out, int entryIndex) throws ParserException {
        parent.setPosition(position + 8);
        parent.skipBytes(24);
        int width = parent.readUnsignedShort();
        int height = parent.readUnsignedShort();
        boolean pixelWidthHeightRatioFromPasp = false;
        float pixelWidthHeightRatio = 1.0f;
        parent.skipBytes(50);
        int childPosition = parent.getPosition();
        if (atomType == Atom.TYPE_encv) {
            atomType = AtomParsers.parseSampleEntryEncryptionData(parent, position, size, out, entryIndex);
            parent.setPosition(childPosition);
        }
        List<Object> initializationData = null;
        String mimeType = null;
        byte[] projectionData = null;
        int stereoMode = -1;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            if (childAtomSize == 0 && parent.getPosition() - position == size) break;
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_avcC) {
                Assertions.checkState(mimeType == null);
                mimeType = "video/avc";
                parent.setPosition(childStartPosition + 8);
                AvcConfig avcConfig = AvcConfig.parse(parent);
                initializationData = avcConfig.initializationData;
                out.nalUnitLengthFieldLength = avcConfig.nalUnitLengthFieldLength;
                if (!pixelWidthHeightRatioFromPasp) {
                    pixelWidthHeightRatio = avcConfig.pixelWidthAspectRatio;
                }
            } else if (childAtomType == Atom.TYPE_hvcC) {
                Assertions.checkState(mimeType == null);
                mimeType = "video/hevc";
                parent.setPosition(childStartPosition + 8);
                HevcConfig hevcConfig = HevcConfig.parse(parent);
                initializationData = hevcConfig.initializationData;
                out.nalUnitLengthFieldLength = hevcConfig.nalUnitLengthFieldLength;
            } else if (childAtomType == Atom.TYPE_vpcC) {
                Assertions.checkState(mimeType == null);
                mimeType = atomType == Atom.TYPE_vp08 ? "video/x-vnd.on2.vp8" : "video/x-vnd.on2.vp9";
            } else if (childAtomType == Atom.TYPE_d263) {
                Assertions.checkState(mimeType == null);
                mimeType = "video/3gpp";
            } else if (childAtomType == Atom.TYPE_esds) {
                Assertions.checkState(mimeType == null);
                Pair<String, byte[]> mimeTypeAndInitializationData = AtomParsers.parseEsdsFromParent(parent, childStartPosition);
                mimeType = (String)mimeTypeAndInitializationData.first;
                initializationData = Collections.singletonList(mimeTypeAndInitializationData.second);
            } else if (childAtomType == Atom.TYPE_pasp) {
                pixelWidthHeightRatio = AtomParsers.parsePaspFromParent(parent, childStartPosition);
                pixelWidthHeightRatioFromPasp = true;
            } else if (childAtomType == Atom.TYPE_sv3d) {
                projectionData = AtomParsers.parseProjFromParent(parent, childStartPosition, childAtomSize);
            } else if (childAtomType == Atom.TYPE_st3d) {
                int version = parent.readUnsignedByte();
                parent.skipBytes(3);
                if (version == 0) {
                    int layout = parent.readUnsignedByte();
                    switch (layout) {
                        case 0: {
                            stereoMode = 0;
                            break;
                        }
                        case 1: {
                            stereoMode = 1;
                            break;
                        }
                        case 2: {
                            stereoMode = 2;
                            break;
                        }
                    }
                }
            }
            childPosition += childAtomSize;
        }
        if (mimeType == null) {
            return;
        }
        out.format = Format.createVideoSampleFormat(Integer.toString(trackId), mimeType, null, -1, -1, width, height, -1.0f, initializationData, rotationDegrees, pixelWidthHeightRatio, projectionData, stereoMode, drmInitData);
    }

    private static Pair<long[], long[]> parseEdts(Atom.ContainerAtom edtsAtom) {
        Atom.LeafAtom elst;
        if (edtsAtom == null || (elst = edtsAtom.getLeafAtomOfType(Atom.TYPE_elst)) == null) {
            return Pair.create(null, null);
        }
        ParsableByteArray elstData = elst.data;
        elstData.setPosition(8);
        int fullAtom = elstData.readInt();
        int version = Atom.parseFullAtomVersion(fullAtom);
        int entryCount = elstData.readUnsignedIntToInt();
        long[] editListDurations = new long[entryCount];
        long[] editListMediaTimes = new long[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            editListDurations[i] = version == 1 ? elstData.readUnsignedLongToLong() : elstData.readUnsignedInt();
            editListMediaTimes[i] = version == 1 ? elstData.readLong() : (long)elstData.readInt();
            short mediaRateInteger = elstData.readShort();
            if (mediaRateInteger != 1) {
                throw new IllegalArgumentException("Unsupported media rate.");
            }
            elstData.skipBytes(2);
        }
        return Pair.create((Object)editListDurations, (Object)editListMediaTimes);
    }

    private static float parsePaspFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8);
        int hSpacing = parent.readUnsignedIntToInt();
        int vSpacing = parent.readUnsignedIntToInt();
        return (float)hSpacing / (float)vSpacing;
    }

    private static void parseAudioSampleEntry(ParsableByteArray parent, int atomType, int position, int size, int trackId, String language, boolean isQuickTime, DrmInitData drmInitData, StsdData out, int entryIndex) {
        int sampleRate;
        int channelCount;
        parent.setPosition(position + 8);
        int quickTimeSoundDescriptionVersion = 0;
        if (isQuickTime) {
            parent.skipBytes(8);
            quickTimeSoundDescriptionVersion = parent.readUnsignedShort();
            parent.skipBytes(6);
        } else {
            parent.skipBytes(16);
        }
        if (quickTimeSoundDescriptionVersion == 0 || quickTimeSoundDescriptionVersion == 1) {
            channelCount = parent.readUnsignedShort();
            parent.skipBytes(6);
            sampleRate = parent.readUnsignedFixedPoint1616();
            if (quickTimeSoundDescriptionVersion == 1) {
                parent.skipBytes(16);
            }
        } else if (quickTimeSoundDescriptionVersion == 2) {
            parent.skipBytes(16);
            sampleRate = (int)Math.round(parent.readDouble());
            channelCount = parent.readUnsignedIntToInt();
            parent.skipBytes(20);
        } else {
            return;
        }
        int childPosition = parent.getPosition();
        if (atomType == Atom.TYPE_enca) {
            atomType = AtomParsers.parseSampleEntryEncryptionData(parent, position, size, out, entryIndex);
            parent.setPosition(childPosition);
        }
        String mimeType = null;
        if (atomType == Atom.TYPE_ac_3) {
            mimeType = "audio/ac3";
        } else if (atomType == Atom.TYPE_ec_3) {
            mimeType = "audio/eac3";
        } else if (atomType == Atom.TYPE_dtsc) {
            mimeType = "audio/vnd.dts";
        } else if (atomType == Atom.TYPE_dtsh || atomType == Atom.TYPE_dtsl) {
            mimeType = "audio/vnd.dts.hd";
        } else if (atomType == Atom.TYPE_dtse) {
            mimeType = "audio/vnd.dts.hd;profile=lbr";
        } else if (atomType == Atom.TYPE_samr) {
            mimeType = "audio/3gpp";
        } else if (atomType == Atom.TYPE_sawb) {
            mimeType = "audio/amr-wb";
        } else if (atomType == Atom.TYPE_lpcm || atomType == Atom.TYPE_sowt) {
            mimeType = "audio/raw";
        }
        byte[] initializationData = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_esds || isQuickTime && childAtomType == Atom.TYPE_wave) {
                int esdsAtomPosition;
                int n = esdsAtomPosition = childAtomType == Atom.TYPE_esds ? childPosition : AtomParsers.findEsdsPosition(parent, childPosition, childAtomSize);
                if (esdsAtomPosition != -1) {
                    Pair<String, byte[]> mimeTypeAndInitializationData = AtomParsers.parseEsdsFromParent(parent, esdsAtomPosition);
                    mimeType = (String)mimeTypeAndInitializationData.first;
                    initializationData = (byte[])mimeTypeAndInitializationData.second;
                    if ("audio/mp4a-latm".equals(mimeType)) {
                        Pair<Integer, Integer> audioSpecificConfig = CodecSpecificDataUtil.parseAacAudioSpecificConfig(initializationData);
                        sampleRate = (Integer)audioSpecificConfig.first;
                        channelCount = (Integer)audioSpecificConfig.second;
                    }
                }
            } else if (childAtomType == Atom.TYPE_dac3) {
                parent.setPosition(8 + childPosition);
                out.format = Ac3Util.parseAc3AnnexFFormat(parent, Integer.toString(trackId), language, drmInitData);
            } else if (childAtomType == Atom.TYPE_dec3) {
                parent.setPosition(8 + childPosition);
                out.format = Ac3Util.parseEAc3AnnexFFormat(parent, Integer.toString(trackId), language, drmInitData);
            } else if (childAtomType == Atom.TYPE_ddts) {
                out.format = Format.createAudioSampleFormat(Integer.toString(trackId), mimeType, null, -1, -1, channelCount, sampleRate, null, drmInitData, 0, language);
            }
            childPosition += childAtomSize;
        }
        if (out.format == null && mimeType != null) {
            int pcmEncoding = "audio/raw".equals(mimeType) ? 2 : -1;
            out.format = Format.createAudioSampleFormat(Integer.toString(trackId), mimeType, null, -1, -1, channelCount, sampleRate, pcmEncoding, initializationData == null ? null : Collections.singletonList(initializationData), drmInitData, 0, language);
        }
    }

    private static int findEsdsPosition(ParsableByteArray parent, int position, int size) {
        int childAtomPosition = parent.getPosition();
        while (childAtomPosition - position < size) {
            parent.setPosition(childAtomPosition);
            int childAtomSize = parent.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childType = parent.readInt();
            if (childType == Atom.TYPE_esds) {
                return childAtomPosition;
            }
            childAtomPosition += childAtomSize;
        }
        return -1;
    }

    private static Pair<String, byte[]> parseEsdsFromParent(ParsableByteArray parent, int position) {
        String mimeType;
        parent.setPosition(position + 8 + 4);
        parent.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parent);
        parent.skipBytes(2);
        int flags = parent.readUnsignedByte();
        if ((flags & 0x80) != 0) {
            parent.skipBytes(2);
        }
        if ((flags & 0x40) != 0) {
            parent.skipBytes(parent.readUnsignedShort());
        }
        if ((flags & 0x20) != 0) {
            parent.skipBytes(2);
        }
        parent.skipBytes(1);
        AtomParsers.parseExpandableClassSize(parent);
        int objectTypeIndication = parent.readUnsignedByte();
        switch (objectTypeIndication) {
            case 107: {
                String mimeType2 = "audio/mpeg";
                return Pair.create((Object)mimeType2, null);
            }
            case 32: {
                mimeType = "video/mp4v-es";
                break;
            }
            case 33: {
                mimeType = "video/avc";
                break;
            }
            case 35: {
                mimeType = "video/hevc";
                break;
            }
            case 64: 
            case 102: 
            case 103: 
            case 104: {
                mimeType = "audio/mp4a-latm";
                break;
            }
            case 165: {
                mimeType = "audio/ac3";
                break;
            }
            case 166: {
                mimeType = "audio/eac3";
                break;
            }
            case 169: 
            case 172: {
                String mimeType3 = "audio/vnd.dts";
                return Pair.create((Object)mimeType3, null);
            }
            case 170: 
            case 171: {
                String mimeType4 = "audio/vnd.dts.hd";
                return Pair.create((Object)mimeType4, null);
            }
            default: {
                mimeType = null;
            }
        }
        parent.skipBytes(12);
        parent.skipBytes(1);
        int initializationDataSize = AtomParsers.parseExpandableClassSize(parent);
        byte[] initializationData = new byte[initializationDataSize];
        parent.readBytes(initializationData, 0, initializationDataSize);
        return Pair.create((Object)mimeType, (Object)initializationData);
    }

    private static int parseSampleEntryEncryptionData(ParsableByteArray parent, int position, int size, StsdData out, int entryIndex) {
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            Pair<Integer, TrackEncryptionBox> result;
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            Assertions.checkArgument(childAtomSize > 0, "childAtomSize should be positive");
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_sinf && (result = AtomParsers.parseSinfFromParent(parent, childPosition, childAtomSize)) != null) {
                out.trackEncryptionBoxes[entryIndex] = (TrackEncryptionBox)result.second;
                return (Integer)result.first;
            }
            childPosition += childAtomSize;
        }
        return 0;
    }

    private static Pair<Integer, TrackEncryptionBox> parseSinfFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        boolean isCencScheme = false;
        TrackEncryptionBox trackEncryptionBox = null;
        Integer dataFormat = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_frma) {
                dataFormat = parent.readInt();
            } else if (childAtomType == Atom.TYPE_schm) {
                parent.skipBytes(4);
                isCencScheme = parent.readInt() == TYPE_cenc;
            } else if (childAtomType == Atom.TYPE_schi) {
                trackEncryptionBox = AtomParsers.parseSchiFromParent(parent, childPosition, childAtomSize);
            }
            childPosition += childAtomSize;
        }
        if (isCencScheme) {
            Assertions.checkArgument(dataFormat != null, "frma atom is mandatory");
            Assertions.checkArgument(trackEncryptionBox != null, "schi->tenc atom is mandatory");
            return Pair.create(dataFormat, trackEncryptionBox);
        }
        return null;
    }

    private static TrackEncryptionBox parseSchiFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_tenc) {
                parent.skipBytes(6);
                boolean defaultIsEncrypted = parent.readUnsignedByte() == 1;
                int defaultInitVectorSize = parent.readUnsignedByte();
                byte[] defaultKeyId = new byte[16];
                parent.readBytes(defaultKeyId, 0, defaultKeyId.length);
                return new TrackEncryptionBox(defaultIsEncrypted, defaultInitVectorSize, defaultKeyId);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static byte[] parseProjFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == Atom.TYPE_proj) {
                return Arrays.copyOfRange(parent.data, childPosition, childPosition + childAtomSize);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static int parseExpandableClassSize(ParsableByteArray data) {
        int currentByte = data.readUnsignedByte();
        int size = currentByte & 0x7F;
        while ((currentByte & 0x80) == 128) {
            currentByte = data.readUnsignedByte();
            size = size << 7 | currentByte & 0x7F;
        }
        return size;
    }

    private AtomParsers() {
    }

    static final class Stz2SampleSizeBox
    implements SampleSizeBox {
        private final ParsableByteArray data;
        private final int sampleCount;
        private final int fieldSize;
        private int sampleIndex;
        private int currentByte;

        public Stz2SampleSizeBox(Atom.LeafAtom stz2Atom) {
            this.data = stz2Atom.data;
            this.data.setPosition(12);
            this.fieldSize = this.data.readUnsignedIntToInt() & 0xFF;
            this.sampleCount = this.data.readUnsignedIntToInt();
        }

        @Override
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public int readNextSampleSize() {
            if (this.fieldSize == 8) {
                return this.data.readUnsignedByte();
            }
            if (this.fieldSize == 16) {
                return this.data.readUnsignedShort();
            }
            if (this.sampleIndex++ % 2 == 0) {
                this.currentByte = this.data.readUnsignedByte();
                return (this.currentByte & 0xF0) >> 4;
            }
            return this.currentByte & 0xF;
        }

        @Override
        public boolean isFixedSampleSize() {
            return false;
        }
    }

    static final class StszSampleSizeBox
    implements SampleSizeBox {
        private final int fixedSampleSize;
        private final int sampleCount;
        private final ParsableByteArray data;

        public StszSampleSizeBox(Atom.LeafAtom stszAtom) {
            this.data = stszAtom.data;
            this.data.setPosition(12);
            this.fixedSampleSize = this.data.readUnsignedIntToInt();
            this.sampleCount = this.data.readUnsignedIntToInt();
        }

        @Override
        public int getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public int readNextSampleSize() {
            return this.fixedSampleSize == 0 ? this.data.readUnsignedIntToInt() : this.fixedSampleSize;
        }

        @Override
        public boolean isFixedSampleSize() {
            return this.fixedSampleSize != 0;
        }
    }

    private static interface SampleSizeBox {
        public int getSampleCount();

        public int readNextSampleSize();

        public boolean isFixedSampleSize();
    }

    private static final class StsdData {
        public final TrackEncryptionBox[] trackEncryptionBoxes;
        public Format format;
        public int nalUnitLengthFieldLength;
        public int requiredSampleTransformation;

        public StsdData(int numberOfEntries) {
            this.trackEncryptionBoxes = new TrackEncryptionBox[numberOfEntries];
            this.requiredSampleTransformation = 0;
        }
    }

    private static final class TkhdData {
        private final int id;
        private final long duration;
        private final int rotationDegrees;

        public TkhdData(int id, long duration, int rotationDegrees) {
            this.id = id;
            this.duration = duration;
            this.rotationDegrees = rotationDegrees;
        }
    }

    private static final class ChunkIterator {
        public final int length;
        public int index;
        public int numSamples;
        public long offset;
        private final boolean chunkOffsetsAreLongs;
        private final ParsableByteArray chunkOffsets;
        private final ParsableByteArray stsc;
        private int nextSamplesPerChunkChangeIndex;
        private int remainingSamplesPerChunkChanges;

        public ChunkIterator(ParsableByteArray stsc, ParsableByteArray chunkOffsets, boolean chunkOffsetsAreLongs) {
            this.stsc = stsc;
            this.chunkOffsets = chunkOffsets;
            this.chunkOffsetsAreLongs = chunkOffsetsAreLongs;
            chunkOffsets.setPosition(12);
            this.length = chunkOffsets.readUnsignedIntToInt();
            stsc.setPosition(12);
            this.remainingSamplesPerChunkChanges = stsc.readUnsignedIntToInt();
            Assertions.checkState(stsc.readInt() == 1, "first_chunk must be 1");
            this.index = -1;
        }

        public boolean moveNext() {
            if (++this.index == this.length) {
                return false;
            }
            long l = this.offset = this.chunkOffsetsAreLongs ? this.chunkOffsets.readUnsignedLongToLong() : this.chunkOffsets.readUnsignedInt();
            if (this.index == this.nextSamplesPerChunkChangeIndex) {
                this.numSamples = this.stsc.readUnsignedIntToInt();
                this.stsc.skipBytes(4);
                this.nextSamplesPerChunkChangeIndex = --this.remainingSamplesPerChunkChanges > 0 ? this.stsc.readUnsignedIntToInt() - 1 : -1;
            }
            return true;
        }
    }
}

