/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import com.google.android.exoplayer2.extractor.MpegAudioHeader;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;

final class XingSeeker
implements Mp3Extractor.Seeker {
    private final long firstFramePosition;
    private final long durationUs;
    private final long inputLength;
    private final long[] tableOfContents;
    private final long sizeBytes;
    private final int headerSize;

    public static XingSeeker create(MpegAudioHeader mpegAudioHeader, ParsableByteArray frame, long position, long inputLength) {
        int frameCount;
        int samplesPerFrame = mpegAudioHeader.samplesPerFrame;
        int sampleRate = mpegAudioHeader.sampleRate;
        long firstFramePosition = position + (long)mpegAudioHeader.frameSize;
        int flags = frame.readInt();
        if ((flags & 1) != 1 || (frameCount = frame.readUnsignedIntToInt()) == 0) {
            return null;
        }
        long durationUs = Util.scaleLargeTimestamp(frameCount, (long)samplesPerFrame * 1000000L, sampleRate);
        if ((flags & 6) != 6) {
            return new XingSeeker(firstFramePosition, durationUs, inputLength);
        }
        long sizeBytes = frame.readUnsignedIntToInt();
        frame.skipBytes(1);
        long[] tableOfContents = new long[99];
        for (int i = 0; i < 99; ++i) {
            tableOfContents[i] = frame.readUnsignedByte();
        }
        return new XingSeeker(firstFramePosition, durationUs, inputLength, tableOfContents, sizeBytes, mpegAudioHeader.frameSize);
    }

    private XingSeeker(long firstFramePosition, long durationUs, long inputLength) {
        this(firstFramePosition, durationUs, inputLength, null, 0L, 0);
    }

    private XingSeeker(long firstFramePosition, long durationUs, long inputLength, long[] tableOfContents, long sizeBytes, int headerSize) {
        this.firstFramePosition = firstFramePosition;
        this.durationUs = durationUs;
        this.inputLength = inputLength;
        this.tableOfContents = tableOfContents;
        this.sizeBytes = sizeBytes;
        this.headerSize = headerSize;
    }

    @Override
    public boolean isSeekable() {
        return this.tableOfContents != null;
    }

    @Override
    public long getPosition(long timeUs) {
        float fx;
        if (!this.isSeekable()) {
            return this.firstFramePosition;
        }
        float percent = (float)timeUs * 100.0f / (float)this.durationUs;
        if (percent <= 0.0f) {
            fx = 0.0f;
        } else if (percent >= 100.0f) {
            fx = 256.0f;
        } else {
            int a = (int)percent;
            float fa = a == 0 ? 0.0f : (float)this.tableOfContents[a - 1];
            float fb = a < 99 ? (float)this.tableOfContents[a] : 256.0f;
            fx = fa + (fb - fa) * (percent - (float)a);
        }
        long position = Math.round(0.00390625 * (double)fx * (double)this.sizeBytes) + this.firstFramePosition;
        long maximumPosition = this.inputLength != -1L ? this.inputLength - 1L : this.firstFramePosition - (long)this.headerSize + this.sizeBytes - 1L;
        return Math.min(position, maximumPosition);
    }

    @Override
    public long getTimeUs(long position) {
        if (!this.isSeekable() || position < this.firstFramePosition) {
            return 0L;
        }
        double offsetByte = 256.0 * (double)(position - this.firstFramePosition) / (double)this.sizeBytes;
        int previousTocPosition = Util.binarySearchFloor(this.tableOfContents, (long)offsetByte, true, false) + 1;
        long previousTime = this.getTimeUsForTocPosition(previousTocPosition);
        long previousByte = previousTocPosition == 0 ? 0L : this.tableOfContents[previousTocPosition - 1];
        long nextByte = previousTocPosition == 99 ? 256L : this.tableOfContents[previousTocPosition];
        long nextTime = this.getTimeUsForTocPosition(previousTocPosition + 1);
        long timeOffset = nextByte == previousByte ? 0L : (long)((double)(nextTime - previousTime) * (offsetByte - (double)previousByte) / (double)(nextByte - previousByte));
        return previousTime + timeOffset;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    private long getTimeUsForTocPosition(int tocPosition) {
        return this.durationUs * (long)tocPosition / 100L;
    }
}

