/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import com.google.android.exoplayer2.extractor.MpegAudioHeader;
import com.google.android.exoplayer2.extractor.mp3.Mp3Extractor;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;

final class VbriSeeker
implements Mp3Extractor.Seeker {
    private final long[] timesUs;
    private final long[] positions;
    private final long durationUs;

    public static VbriSeeker create(MpegAudioHeader mpegAudioHeader, ParsableByteArray frame, long position, long inputLength) {
        frame.skipBytes(10);
        int numFrames = frame.readInt();
        if (numFrames <= 0) {
            return null;
        }
        int sampleRate = mpegAudioHeader.sampleRate;
        long durationUs = Util.scaleLargeTimestamp(numFrames, 1000000L * (long)(sampleRate >= 32000 ? 1152 : 576), sampleRate);
        int entryCount = frame.readUnsignedShort();
        int scale = frame.readUnsignedShort();
        int entrySize = frame.readUnsignedShort();
        frame.skipBytes(2);
        long[] timesUs = new long[entryCount + 1];
        long[] positions = new long[entryCount + 1];
        timesUs[0] = 0L;
        positions[0] = position += (long)mpegAudioHeader.frameSize;
        for (int index = 1; index < timesUs.length; ++index) {
            int segmentSize;
            switch (entrySize) {
                case 1: {
                    segmentSize = frame.readUnsignedByte();
                    break;
                }
                case 2: {
                    segmentSize = frame.readUnsignedShort();
                    break;
                }
                case 3: {
                    segmentSize = frame.readUnsignedInt24();
                    break;
                }
                case 4: {
                    segmentSize = frame.readUnsignedIntToInt();
                    break;
                }
                default: {
                    return null;
                }
            }
            timesUs[index] = (long)index * durationUs / (long)entryCount;
            positions[index] = inputLength == -1L ? position : Math.min(inputLength, position += (long)(segmentSize * scale));
        }
        return new VbriSeeker(timesUs, positions, durationUs);
    }

    private VbriSeeker(long[] timesUs, long[] positions, long durationUs) {
        this.timesUs = timesUs;
        this.positions = positions;
        this.durationUs = durationUs;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public long getPosition(long timeUs) {
        return this.positions[Util.binarySearchFloor(this.timesUs, timeUs, true, true)];
    }

    @Override
    public long getTimeUs(long position) {
        return this.timesUs[Util.binarySearchFloor(this.positions, position, true, true)];
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }
}

