/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.MpegAudioHeader;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp3.ConstantBitrateSeeker;
import com.google.android.exoplayer2.extractor.mp3.Id3Util;
import com.google.android.exoplayer2.extractor.mp3.VbriSeeker;
import com.google.android.exoplayer2.extractor.mp3.XingSeeker;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;

public final class Mp3Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = new ExtractorsFactory(){

        @Override
        public Extractor[] createExtractors() {
            return new Extractor[]{new Mp3Extractor()};
        }
    };
    private static final int MAX_SYNC_BYTES = 131072;
    private static final int MAX_SNIFF_BYTES = 4096;
    private static final int HEADER_MASK = -128000;
    private static final int XING_HEADER = Util.getIntegerCodeForString("Xing");
    private static final int INFO_HEADER = Util.getIntegerCodeForString("Info");
    private static final int VBRI_HEADER = Util.getIntegerCodeForString("VBRI");
    private final long forcedFirstSampleTimestampUs;
    private final ParsableByteArray scratch;
    private final MpegAudioHeader synchronizedHeader;
    private final GaplessInfoHolder gaplessInfoHolder;
    private ExtractorOutput extractorOutput;
    private TrackOutput trackOutput;
    private int synchronizedHeaderData;
    private Seeker seeker;
    private long basisTimeUs;
    private long samplesRead;
    private int sampleBytesRemaining;

    public Mp3Extractor() {
        this(-9223372036854775807L);
    }

    public Mp3Extractor(long forcedFirstSampleTimestampUs) {
        this.forcedFirstSampleTimestampUs = forcedFirstSampleTimestampUs;
        this.scratch = new ParsableByteArray(4);
        this.synchronizedHeader = new MpegAudioHeader();
        this.gaplessInfoHolder = new GaplessInfoHolder();
        this.basisTimeUs = -9223372036854775807L;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException, InterruptedException {
        return this.synchronize(input, true);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.trackOutput = this.extractorOutput.track(0);
        this.extractorOutput.endTracks();
    }

    @Override
    public void seek(long position) {
        this.synchronizedHeaderData = 0;
        this.basisTimeUs = -9223372036854775807L;
        this.samplesRead = 0L;
        this.sampleBytesRemaining = 0;
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException, InterruptedException {
        if (this.synchronizedHeaderData == 0) {
            try {
                this.synchronize(input, false);
            }
            catch (EOFException e) {
                return -1;
            }
        }
        if (this.seeker == null) {
            this.seeker = this.setupSeeker(input);
            this.extractorOutput.seekMap(this.seeker);
            this.trackOutput.format(Format.createAudioSampleFormat(null, this.synchronizedHeader.mimeType, null, -1, 4096, this.synchronizedHeader.channels, this.synchronizedHeader.sampleRate, -1, this.gaplessInfoHolder.encoderDelay, this.gaplessInfoHolder.encoderPadding, null, null, 0, null));
        }
        return this.readSample(input);
    }

    private int readSample(ExtractorInput extractorInput) throws IOException, InterruptedException {
        int bytesAppended;
        if (this.sampleBytesRemaining == 0) {
            extractorInput.resetPeekPosition();
            if (!extractorInput.peekFully(this.scratch.data, 0, 4, true)) {
                return -1;
            }
            this.scratch.setPosition(0);
            int sampleHeaderData = this.scratch.readInt();
            if ((sampleHeaderData & 0xFFFE0C00) != (this.synchronizedHeaderData & 0xFFFE0C00) || MpegAudioHeader.getFrameSize(sampleHeaderData) == -1) {
                extractorInput.skipFully(1);
                this.synchronizedHeaderData = 0;
                return 0;
            }
            MpegAudioHeader.populateHeader(sampleHeaderData, this.synchronizedHeader);
            if (this.basisTimeUs == -9223372036854775807L) {
                this.basisTimeUs = this.seeker.getTimeUs(extractorInput.getPosition());
                if (this.forcedFirstSampleTimestampUs != -9223372036854775807L) {
                    long embeddedFirstSampleTimestampUs = this.seeker.getTimeUs(0L);
                    this.basisTimeUs += this.forcedFirstSampleTimestampUs - embeddedFirstSampleTimestampUs;
                }
            }
            this.sampleBytesRemaining = this.synchronizedHeader.frameSize;
        }
        if ((bytesAppended = this.trackOutput.sampleData(extractorInput, this.sampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.sampleBytesRemaining -= bytesAppended;
        if (this.sampleBytesRemaining > 0) {
            return 0;
        }
        long timeUs = this.basisTimeUs + this.samplesRead * 1000000L / (long)this.synchronizedHeader.sampleRate;
        this.trackOutput.sampleMetadata(timeUs, 1, this.synchronizedHeader.frameSize, 0, null);
        this.samplesRead += (long)this.synchronizedHeader.samplesPerFrame;
        this.sampleBytesRemaining = 0;
        return 0;
    }

    private boolean synchronize(ExtractorInput input, boolean sniffing) throws IOException, InterruptedException {
        int validFrameCount = 0;
        int candidateSynchronizedHeaderData = 0;
        int peekedId3Bytes = 0;
        int searchedBytes = 0;
        int searchLimitBytes = sniffing ? 4096 : 131072;
        input.resetPeekPosition();
        if (input.getPosition() == 0L) {
            Id3Util.parseId3(input, this.gaplessInfoHolder);
            peekedId3Bytes = (int)input.getPeekPosition();
            if (!sniffing) {
                input.skipFully(peekedId3Bytes);
            }
        }
        while (input.peekFully(this.scratch.data, 0, 4, validFrameCount > 0)) {
            int frameSize;
            this.scratch.setPosition(0);
            int headerData = this.scratch.readInt();
            if (candidateSynchronizedHeaderData != 0 && (headerData & 0xFFFE0C00) != (candidateSynchronizedHeaderData & 0xFFFE0C00) || (frameSize = MpegAudioHeader.getFrameSize(headerData)) == -1) {
                if (searchedBytes++ == searchLimitBytes) {
                    if (!sniffing) {
                        throw new ParserException("Searched too many bytes.");
                    }
                    return false;
                }
                validFrameCount = 0;
                candidateSynchronizedHeaderData = 0;
                if (sniffing) {
                    input.resetPeekPosition();
                    input.advancePeekPosition(peekedId3Bytes + searchedBytes);
                    continue;
                }
                input.skipFully(1);
                continue;
            }
            if (++validFrameCount == 1) {
                MpegAudioHeader.populateHeader(headerData, this.synchronizedHeader);
                candidateSynchronizedHeaderData = headerData;
            } else if (validFrameCount == 4) break;
            input.advancePeekPosition(frameSize - 4);
        }
        if (sniffing) {
            input.skipFully(peekedId3Bytes + searchedBytes);
        } else {
            input.resetPeekPosition();
        }
        this.synchronizedHeaderData = candidateSynchronizedHeaderData;
        return true;
    }

    private Seeker setupSeeker(ExtractorInput input) throws IOException, InterruptedException {
        int xingBase;
        ParsableByteArray frame = new ParsableByteArray(this.synchronizedHeader.frameSize);
        input.peekFully(frame.data, 0, this.synchronizedHeader.frameSize);
        long position = input.getPosition();
        long length = input.getLength();
        int headerData = 0;
        Seeker seeker = null;
        int n = (this.synchronizedHeader.version & 1) != 0 ? (this.synchronizedHeader.channels != 1 ? 36 : 21) : (xingBase = this.synchronizedHeader.channels != 1 ? 21 : 13);
        if (frame.limit() >= xingBase + 4) {
            frame.setPosition(xingBase);
            headerData = frame.readInt();
        }
        if (headerData == XING_HEADER || headerData == INFO_HEADER) {
            seeker = XingSeeker.create(this.synchronizedHeader, frame, position, length);
            if (seeker != null && !this.gaplessInfoHolder.hasGaplessInfo()) {
                input.resetPeekPosition();
                input.advancePeekPosition(xingBase + 141);
                input.peekFully(this.scratch.data, 0, 3);
                this.scratch.setPosition(0);
                this.gaplessInfoHolder.setFromXingHeaderValue(this.scratch.readUnsignedInt24());
            }
            input.skipFully(this.synchronizedHeader.frameSize);
        } else if (frame.limit() >= 40) {
            frame.setPosition(36);
            headerData = frame.readInt();
            if (headerData == VBRI_HEADER) {
                seeker = VbriSeeker.create(this.synchronizedHeader, frame, position, length);
                input.skipFully(this.synchronizedHeader.frameSize);
            }
        }
        if (seeker == null) {
            input.resetPeekPosition();
            input.peekFully(this.scratch.data, 0, 4);
            this.scratch.setPosition(0);
            MpegAudioHeader.populateHeader(this.scratch.readInt(), this.synchronizedHeader);
            seeker = new ConstantBitrateSeeker(input.getPosition(), this.synchronizedHeader.bitrate, length);
        }
        return seeker;
    }

    static interface Seeker
    extends SeekMap {
        public long getTimeUs(long var1);
    }
}

